/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.deprecated;

import com.google.cloud.compute.deprecated.AttachedDisk;
import com.google.cloud.compute.deprecated.Compute;
import com.google.cloud.compute.deprecated.ComputeOptions;
import com.google.cloud.compute.deprecated.InstanceId;
import com.google.cloud.compute.deprecated.InstanceInfo;
import com.google.cloud.compute.deprecated.MachineTypeId;
import com.google.cloud.compute.deprecated.Metadata;
import com.google.cloud.compute.deprecated.NetworkInterface;
import com.google.cloud.compute.deprecated.Operation;
import com.google.cloud.compute.deprecated.SchedulingOptions;
import com.google.cloud.compute.deprecated.ServiceAccount;
import com.google.cloud.compute.deprecated.Tags;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Instance
extends InstanceInfo {
    private static final long serialVersionUID = 3072508155558980677L;
    private final ComputeOptions options;
    private transient Compute compute;

    Instance(Compute compute, InstanceInfo.BuilderImpl infoBuilder) {
        super(infoBuilder);
        this.compute = (Compute)Preconditions.checkNotNull((Object)compute);
        this.options = (ComputeOptions)compute.getOptions();
    }

    public boolean exists() {
        return this.reload(Compute.InstanceOption.fields(new Compute.InstanceField[0])) != null;
    }

    public Instance reload(Compute.InstanceOption ... options) {
        return this.compute.getInstance(this.getInstanceId(), options);
    }

    public Operation delete(Compute.OperationOption ... options) {
        return this.compute.deleteInstance(this.getInstanceId(), options);
    }

    public Operation addAccessConfig(String networkInterface, NetworkInterface.AccessConfig accessConfig, Compute.OperationOption ... options) {
        return this.compute.addAccessConfig(this.getInstanceId(), networkInterface, accessConfig, options);
    }

    public Operation attachDisk(AttachedDisk.PersistentDiskConfiguration configuration, Compute.OperationOption ... options) {
        return this.compute.attachDisk(this.getInstanceId(), configuration, options);
    }

    public Operation attachDisk(String deviceName, AttachedDisk.PersistentDiskConfiguration configuration, Compute.OperationOption ... options) {
        return this.compute.attachDisk(this.getInstanceId(), deviceName, configuration, options);
    }

    public Operation attachDisk(String deviceName, AttachedDisk.PersistentDiskConfiguration configuration, int index, Compute.OperationOption ... options) {
        return this.compute.attachDisk(this.getInstanceId(), deviceName, configuration, index, options);
    }

    public Operation deleteAccessConfig(String networkInterface, String accessConfig, Compute.OperationOption ... options) {
        return this.compute.deleteAccessConfig(this.getInstanceId(), networkInterface, accessConfig, options);
    }

    public Operation detachDisk(String deviceName, Compute.OperationOption ... options) {
        return this.compute.detachDisk(this.getInstanceId(), deviceName, options);
    }

    public String getSerialPortOutput(int port) {
        return this.compute.getSerialPortOutput(this.getInstanceId(), port);
    }

    public String getSerialPortOutput() {
        return this.compute.getSerialPortOutput(this.getInstanceId());
    }

    public Operation reset(Compute.OperationOption ... options) {
        return this.compute.reset(this.getInstanceId(), options);
    }

    public Operation setDiskAutoDelete(String deviceName, boolean autoDelete, Compute.OperationOption ... options) {
        return this.compute.setDiskAutoDelete(this.getInstanceId(), deviceName, autoDelete, options);
    }

    public Operation setMachineType(MachineTypeId machineType, Compute.OperationOption ... options) {
        return this.compute.setMachineType(this.getInstanceId(), machineType, options);
    }

    public Operation setMetadata(Metadata metadata, Compute.OperationOption ... options) {
        return this.compute.setMetadata(this.getInstanceId(), metadata, options);
    }

    public Operation setMetadata(Map<String, String> metadata, Compute.OperationOption ... options) {
        return this.setMetadata(this.getMetadata().toBuilder().setValues(metadata).build(), options);
    }

    public Operation setSchedulingOptions(SchedulingOptions scheduling, Compute.OperationOption ... options) {
        return this.compute.setSchedulingOptions(this.getInstanceId(), scheduling, options);
    }

    public Operation setTags(Tags tags, Compute.OperationOption ... options) {
        return this.compute.setTags(this.getInstanceId(), tags, options);
    }

    public Operation setTags(Iterable<String> tags, Compute.OperationOption ... options) {
        return this.setTags(this.getTags().toBuilder().setValues(tags).build(), options);
    }

    public Operation start(Compute.OperationOption ... options) {
        return this.compute.start(this.getInstanceId(), options);
    }

    public Operation stop(Compute.OperationOption ... options) {
        return this.compute.stop(this.getInstanceId(), options);
    }

    public Compute getCompute() {
        return this.compute;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Instance.class)) {
            return false;
        }
        Instance other = (Instance)obj;
        return Objects.equals(this.toPb(), other.toPb()) && Objects.equals((Object)this.options, (Object)other.options);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.options});
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.compute = (Compute)this.options.getService();
    }

    static Instance fromPb(Compute compute, com.google.api.services.compute.model.Instance instancePb) {
        return new Instance(compute, new InstanceInfo.BuilderImpl(instancePb));
    }

    public static class Builder
    extends InstanceInfo.Builder {
        private final Compute compute;
        private final InstanceInfo.BuilderImpl infoBuilder;

        Builder(Compute compute, InstanceId instanceId, MachineTypeId machineType, AttachedDisk attachedDisk, NetworkInterface networkInterface) {
            this.compute = compute;
            this.infoBuilder = new InstanceInfo.BuilderImpl(instanceId);
            this.infoBuilder.setMachineType(machineType);
            this.infoBuilder.setAttachedDisks((List<AttachedDisk>)ImmutableList.of((Object)attachedDisk));
            this.infoBuilder.setNetworkInterfaces((List<NetworkInterface>)ImmutableList.of((Object)networkInterface));
        }

        Builder(Instance instance) {
            this.compute = instance.compute;
            this.infoBuilder = new InstanceInfo.BuilderImpl(instance);
        }

        @Override
        Builder setGeneratedId(String generatedId) {
            this.infoBuilder.setGeneratedId(generatedId);
            return this;
        }

        @Override
        public Builder setInstanceId(InstanceId instanceId) {
            this.infoBuilder.setInstanceId(instanceId);
            return this;
        }

        @Override
        Builder setCreationTimestamp(Long creationTimestamp) {
            this.infoBuilder.setCreationTimestamp(creationTimestamp);
            return this;
        }

        @Override
        public Builder setDescription(String description) {
            this.infoBuilder.setDescription(description);
            return this;
        }

        @Override
        Builder setStatus(InstanceInfo.Status status) {
            this.infoBuilder.setStatus(status);
            return this;
        }

        @Override
        Builder setStatusMessage(String statusMessage) {
            this.infoBuilder.setStatusMessage(statusMessage);
            return this;
        }

        @Override
        public Builder setTags(Tags tags) {
            this.infoBuilder.setTags(tags);
            return this;
        }

        @Override
        public Builder setMachineType(MachineTypeId machineType) {
            this.infoBuilder.setMachineType(machineType);
            return this;
        }

        @Override
        public Builder setCanIpForward(Boolean canIpForward) {
            this.infoBuilder.setCanIpForward(canIpForward);
            return this;
        }

        @Override
        public Builder setNetworkInterfaces(List<NetworkInterface> networkInterfaces) {
            this.infoBuilder.setNetworkInterfaces(networkInterfaces);
            return this;
        }

        @Override
        public Builder setNetworkInterfaces(NetworkInterface ... networkInterfaces) {
            this.infoBuilder.setNetworkInterfaces(networkInterfaces);
            return this;
        }

        @Override
        public Builder setAttachedDisks(List<AttachedDisk> attachedDisks) {
            this.infoBuilder.setAttachedDisks(attachedDisks);
            return this;
        }

        @Override
        public Builder setAttachedDisks(AttachedDisk ... attachedDisks) {
            this.infoBuilder.setAttachedDisks(attachedDisks);
            return this;
        }

        @Override
        public Builder setMetadata(Metadata metadata) {
            this.infoBuilder.setMetadata(metadata);
            return this;
        }

        @Override
        public Builder setServiceAccounts(List<ServiceAccount> serviceAccounts) {
            this.infoBuilder.setServiceAccounts(serviceAccounts);
            return this;
        }

        @Override
        public Builder setSchedulingOptions(SchedulingOptions schedulingOptions) {
            this.infoBuilder.setSchedulingOptions(schedulingOptions);
            return this;
        }

        @Override
        Builder setCpuPlatform(String cpuPlatform) {
            this.infoBuilder.setCpuPlatform(cpuPlatform);
            return this;
        }

        @Override
        public Instance build() {
            return new Instance(this.compute, this.infoBuilder);
        }
    }
}

