/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dns;

import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.gax.paging.Page;
import com.google.api.services.dns.model.Change;
import com.google.api.services.dns.model.ChangesListResponse;
import com.google.api.services.dns.model.ManagedZone;
import com.google.api.services.dns.model.ManagedZonesListResponse;
import com.google.api.services.dns.model.Project;
import com.google.api.services.dns.model.ResourceRecordSetsListResponse;
import com.google.cloud.PageImpl;
import com.google.cloud.dns.ChangeRequest;
import com.google.cloud.dns.ChangeRequestInfo;
import com.google.cloud.dns.Dns;
import com.google.cloud.dns.DnsBatchResult;
import com.google.cloud.dns.DnsException;
import com.google.cloud.dns.DnsImpl;
import com.google.cloud.dns.DnsOptions;
import com.google.cloud.dns.ProjectInfo;
import com.google.cloud.dns.RecordSet;
import com.google.cloud.dns.Zone;
import com.google.cloud.dns.ZoneInfo;
import com.google.cloud.dns.spi.v1.DnsRpc;
import com.google.cloud.dns.spi.v1.RpcBatch;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;

public class DnsBatch {
    private final RpcBatch batch;
    private final DnsRpc dnsRpc;
    private final DnsOptions options;

    DnsBatch(DnsOptions options) {
        this.options = options;
        this.dnsRpc = options.getDnsRpcV1();
        this.batch = this.dnsRpc.createBatch();
    }

    @VisibleForTesting
    Object getBatch() {
        return this.batch;
    }

    @VisibleForTesting
    DnsRpc getDnsRpc() {
        return this.dnsRpc;
    }

    @VisibleForTesting
    DnsOptions getOptions() {
        return this.options;
    }

    public DnsBatchResult<Page<Zone>> listZones(Dns.ZoneListOption ... options) {
        DnsBatchResult<Page<Zone>> result = new DnsBatchResult<Page<Zone>>();
        Map<DnsRpc.Option, ?> optionMap = DnsImpl.optionMap(options);
        RpcBatch.Callback<ManagedZonesListResponse> callback = this.createListZonesCallback(result, optionMap);
        this.batch.addListZones(callback, optionMap);
        return result;
    }

    public DnsBatchResult<Zone> createZone(ZoneInfo zone, Dns.ZoneOption ... options) {
        DnsBatchResult<Zone> result = new DnsBatchResult<Zone>();
        RpcBatch.Callback<ManagedZone> callback = this.createZoneCallback(this.options, result, false, true);
        Map<DnsRpc.Option, ?> optionMap = DnsImpl.optionMap(options);
        this.batch.addCreateZone(zone.toPb(), callback, optionMap);
        return result;
    }

    public DnsBatchResult<Boolean> deleteZone(String zoneName) {
        DnsBatchResult<Boolean> result = new DnsBatchResult<Boolean>();
        RpcBatch.Callback<Void> callback = this.createDeleteZoneCallback(result);
        this.batch.addDeleteZone(zoneName, callback);
        return result;
    }

    public DnsBatchResult<Zone> getZone(String zoneName, Dns.ZoneOption ... options) {
        DnsBatchResult<Zone> result = new DnsBatchResult<Zone>();
        RpcBatch.Callback<ManagedZone> callback = this.createZoneCallback(this.options, result, true, true);
        Map<DnsRpc.Option, ?> optionMap = DnsImpl.optionMap(options);
        this.batch.addGetZone(zoneName, callback, optionMap);
        return result;
    }

    public DnsBatchResult<ProjectInfo> getProject(Dns.ProjectOption ... options) {
        DnsBatchResult<ProjectInfo> result = new DnsBatchResult<ProjectInfo>();
        RpcBatch.Callback<Project> callback = this.createProjectCallback(result);
        Map<DnsRpc.Option, ?> optionMap = DnsImpl.optionMap(options);
        this.batch.addGetProject(callback, optionMap);
        return result;
    }

    public DnsBatchResult<Page<RecordSet>> listRecordSets(String zoneName, Dns.RecordSetListOption ... options) {
        DnsBatchResult<Page<RecordSet>> result = new DnsBatchResult<Page<RecordSet>>();
        Map<DnsRpc.Option, ?> optionMap = DnsImpl.optionMap(options);
        RpcBatch.Callback<ResourceRecordSetsListResponse> callback = this.createListRecordSetsCallback(zoneName, result, optionMap);
        this.batch.addListRecordSets(zoneName, callback, optionMap);
        return result;
    }

    public DnsBatchResult<Page<ChangeRequest>> listChangeRequests(String zoneName, Dns.ChangeRequestListOption ... options) {
        DnsBatchResult<Page<ChangeRequest>> result = new DnsBatchResult<Page<ChangeRequest>>();
        Map<DnsRpc.Option, ?> optionMap = DnsImpl.optionMap(options);
        RpcBatch.Callback<ChangesListResponse> callback = this.createListChangeRequestsCallback(zoneName, result, optionMap);
        this.batch.addListChangeRequests(zoneName, callback, optionMap);
        return result;
    }

    public DnsBatchResult<ChangeRequest> getChangeRequest(String zoneName, String changeRequestId, Dns.ChangeRequestOption ... options) {
        DnsBatchResult<ChangeRequest> result = new DnsBatchResult<ChangeRequest>();
        RpcBatch.Callback<Change> callback = this.createChangeRequestCallback(zoneName, result, true, true);
        Map<DnsRpc.Option, ?> optionMap = DnsImpl.optionMap(options);
        this.batch.addGetChangeRequest(zoneName, changeRequestId, callback, optionMap);
        return result;
    }

    public DnsBatchResult<ChangeRequest> applyChangeRequest(String zoneName, ChangeRequestInfo changeRequest, Dns.ChangeRequestOption ... options) {
        DnsBatchResult<ChangeRequest> result = new DnsBatchResult<ChangeRequest>();
        RpcBatch.Callback<Change> callback = this.createChangeRequestCallback(zoneName, result, false, false);
        Map<DnsRpc.Option, ?> optionMap = DnsImpl.optionMap(options);
        this.batch.addApplyChangeRequest(zoneName, changeRequest.toPb(), callback, optionMap);
        return result;
    }

    public void submit() {
        this.batch.submit();
    }

    private RpcBatch.Callback<ManagedZonesListResponse> createListZonesCallback(final DnsBatchResult<Page<Zone>> result, final Map<DnsRpc.Option, ?> optionMap) {
        return new RpcBatch.Callback<ManagedZonesListResponse>(){

            @Override
            public void onSuccess(ManagedZonesListResponse response) {
                List zones = response.getManagedZones();
                PageImpl zonePage = new PageImpl((PageImpl.NextPageFetcher)new DnsImpl.ZonePageFetcher(DnsBatch.this.options, response.getNextPageToken(), optionMap), response.getNextPageToken(), (Iterable)(zones == null ? ImmutableList.of() : Iterables.transform((Iterable)zones, DnsImpl.zoneFromPb(DnsBatch.this.options))));
                result.success(zonePage);
            }

            @Override
            public void onFailure(GoogleJsonError googleJsonError) {
                result.error(new DnsException(googleJsonError, true));
            }
        };
    }

    private RpcBatch.Callback<Void> createDeleteZoneCallback(final DnsBatchResult<Boolean> result) {
        return new RpcBatch.Callback<Void>(){

            @Override
            public void onSuccess(Void response) {
                result.success(true);
            }

            @Override
            public void onFailure(GoogleJsonError googleJsonError) {
                DnsException serviceException = new DnsException(googleJsonError, false);
                if (serviceException.getCode() == 404) {
                    result.success(false);
                } else {
                    result.error(serviceException);
                }
            }
        };
    }

    private RpcBatch.Callback<ManagedZone> createZoneCallback(final DnsOptions serviceOptions, final DnsBatchResult<Zone> result, final boolean nullForNotFound, final boolean idempotent) {
        return new RpcBatch.Callback<ManagedZone>(){

            @Override
            public void onSuccess(ManagedZone response) {
                result.success(response == null ? null : Zone.fromPb((Dns)serviceOptions.getService(), response));
            }

            @Override
            public void onFailure(GoogleJsonError googleJsonError) {
                DnsException serviceException = new DnsException(googleJsonError, idempotent);
                if (nullForNotFound && serviceException.getCode() == 404) {
                    result.success(null);
                } else {
                    result.error(serviceException);
                }
            }
        };
    }

    private RpcBatch.Callback<Project> createProjectCallback(final DnsBatchResult<ProjectInfo> result) {
        return new RpcBatch.Callback<Project>(){

            @Override
            public void onSuccess(Project response) {
                result.success(response == null ? null : ProjectInfo.fromPb(response));
            }

            @Override
            public void onFailure(GoogleJsonError googleJsonError) {
                result.error(new DnsException(googleJsonError, true));
            }
        };
    }

    private RpcBatch.Callback<ResourceRecordSetsListResponse> createListRecordSetsCallback(final String zoneName, final DnsBatchResult<Page<RecordSet>> result, final Map<DnsRpc.Option, ?> optionMap) {
        return new RpcBatch.Callback<ResourceRecordSetsListResponse>(){

            @Override
            public void onSuccess(ResourceRecordSetsListResponse response) {
                List recordSets = response.getRrsets();
                PageImpl page = new PageImpl((PageImpl.NextPageFetcher)new DnsImpl.RecordSetPageFetcher(zoneName, DnsBatch.this.options, response.getNextPageToken(), optionMap), response.getNextPageToken(), (Iterable)(recordSets == null ? ImmutableList.of() : Iterables.transform((Iterable)recordSets, RecordSet.FROM_PB_FUNCTION)));
                result.success(page);
            }

            @Override
            public void onFailure(GoogleJsonError googleJsonError) {
                result.error(new DnsException(googleJsonError, true));
            }
        };
    }

    private RpcBatch.Callback<ChangesListResponse> createListChangeRequestsCallback(final String zoneName, final DnsBatchResult<Page<ChangeRequest>> result, final Map<DnsRpc.Option, ?> optionMap) {
        return new RpcBatch.Callback<ChangesListResponse>(){

            @Override
            public void onSuccess(ChangesListResponse response) {
                List changes = response.getChanges();
                PageImpl page = new PageImpl((PageImpl.NextPageFetcher)new DnsImpl.ChangeRequestPageFetcher(zoneName, DnsBatch.this.options, response.getNextPageToken(), optionMap), response.getNextPageToken(), (Iterable)(changes == null ? ImmutableList.of() : Iterables.transform((Iterable)changes, ChangeRequest.fromPbFunction((Dns)DnsBatch.this.options.getService(), zoneName))));
                result.success(page);
            }

            @Override
            public void onFailure(GoogleJsonError googleJsonError) {
                result.error(new DnsException(googleJsonError, true));
            }
        };
    }

    private RpcBatch.Callback<Change> createChangeRequestCallback(final String zoneName, final DnsBatchResult<ChangeRequest> result, boolean nullForNotFound, final boolean idempotent) {
        return new RpcBatch.Callback<Change>(){

            @Override
            public void onSuccess(Change response) {
                result.success(response == null ? null : ChangeRequest.fromPb((Dns)DnsBatch.this.options.getService(), zoneName, response));
            }

            @Override
            public void onFailure(GoogleJsonError googleJsonError) {
                DnsException serviceException = new DnsException(googleJsonError, idempotent);
                if (serviceException.getCode() == 404 && ("entity.parameters.changeId".equals(serviceException.getLocation()) || serviceException.getMessage() != null && serviceException.getMessage().contains("parameters.changeId"))) {
                    result.success(null);
                    return;
                }
                result.error(serviceException);
            }
        };
    }
}

