/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio;

import com.google.cloud.storage.contrib.nio.AutoValue_CloudStorageConfiguration;
import com.google.cloud.storage.contrib.nio.UnixPath;
import com.google.common.base.Preconditions;
import java.util.Map;

public abstract class CloudStorageConfiguration {
    public static final CloudStorageConfiguration DEFAULT = CloudStorageConfiguration.builder().build();

    public abstract String workingDirectory();

    public abstract boolean permitEmptyPathComponents();

    public abstract boolean stripPrefixSlash();

    public abstract boolean usePseudoDirectories();

    public abstract int blockSize();

    public abstract int maxChannelReopens();

    public static Builder builder() {
        return new Builder();
    }

    static CloudStorageConfiguration fromMap(Map<String, ?> env) {
        return CloudStorageConfiguration.fromMap(CloudStorageConfiguration.builder(), env);
    }

    static CloudStorageConfiguration fromMap(CloudStorageConfiguration defaultValues, Map<String, ?> env) {
        return CloudStorageConfiguration.fromMap(new Builder(defaultValues), env);
    }

    private static CloudStorageConfiguration fromMap(Builder builder, Map<String, ?> env) {
        block16: for (Map.Entry<String, ?> entry : env.entrySet()) {
            switch (entry.getKey()) {
                case "workingDirectory": {
                    builder.workingDirectory((String)entry.getValue());
                    continue block16;
                }
                case "permitEmptyPathComponents": {
                    builder.permitEmptyPathComponents((Boolean)entry.getValue());
                    continue block16;
                }
                case "stripPrefixSlash": {
                    builder.stripPrefixSlash((Boolean)entry.getValue());
                    continue block16;
                }
                case "usePseudoDirectories": {
                    builder.usePseudoDirectories((Boolean)entry.getValue());
                    continue block16;
                }
                case "blockSize": {
                    builder.blockSize((Integer)entry.getValue());
                    continue block16;
                }
                case "maxChannelReopens": {
                    builder.maxChannelReopens((Integer)entry.getValue());
                    continue block16;
                }
            }
            throw new IllegalArgumentException(entry.getKey());
        }
        return builder.build();
    }

    CloudStorageConfiguration() {
    }

    public static final class Builder {
        private String workingDirectory = "/";
        private boolean permitEmptyPathComponents;
        private boolean stripPrefixSlash = true;
        private boolean usePseudoDirectories = true;
        private int blockSize = 0x200000;
        private int maxChannelReopens = 0;

        public Builder workingDirectory(String path) {
            Preconditions.checkArgument((boolean)UnixPath.getPath(false, path).isAbsolute(), (String)"not absolute: %s", (Object)path);
            this.workingDirectory = path;
            return this;
        }

        public Builder permitEmptyPathComponents(boolean value) {
            this.permitEmptyPathComponents = value;
            return this;
        }

        public Builder stripPrefixSlash(boolean value) {
            this.stripPrefixSlash = value;
            return this;
        }

        public Builder usePseudoDirectories(boolean value) {
            this.usePseudoDirectories = value;
            return this;
        }

        public Builder blockSize(int value) {
            this.blockSize = value;
            return this;
        }

        public Builder maxChannelReopens(int value) {
            this.maxChannelReopens = value;
            return this;
        }

        public CloudStorageConfiguration build() {
            return new AutoValue_CloudStorageConfiguration(this.workingDirectory, this.permitEmptyPathComponents, this.stripPrefixSlash, this.usePseudoDirectories, this.blockSize, this.maxChannelReopens);
        }

        Builder(CloudStorageConfiguration toModify) {
            this.workingDirectory = toModify.workingDirectory();
            this.permitEmptyPathComponents = toModify.permitEmptyPathComponents();
            this.stripPrefixSlash = toModify.stripPrefixSlash();
            this.usePseudoDirectories = toModify.usePseudoDirectories();
            this.blockSize = toModify.blockSize();
            this.maxChannelReopens = toModify.maxChannelReopens();
        }

        Builder() {
        }
    }
}

