
package com.google.cloud.pubsub.v1;

import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_PublisherStats extends PublisherStats {

  private final long ackedMessages;
  private final long failedMessages;
  private final long pendingMessages;
  private final long sentMessages;

  private AutoValue_PublisherStats(
      long ackedMessages,
      long failedMessages,
      long pendingMessages,
      long sentMessages) {
    this.ackedMessages = ackedMessages;
    this.failedMessages = failedMessages;
    this.pendingMessages = pendingMessages;
    this.sentMessages = sentMessages;
  }

  @Override
  public long getAckedMessages() {
    return ackedMessages;
  }

  @Override
  public long getFailedMessages() {
    return failedMessages;
  }

  @Override
  public long getPendingMessages() {
    return pendingMessages;
  }

  @Override
  public long getSentMessages() {
    return sentMessages;
  }

  @Override
  public String toString() {
    return "PublisherStats{"
        + "ackedMessages=" + ackedMessages + ", "
        + "failedMessages=" + failedMessages + ", "
        + "pendingMessages=" + pendingMessages + ", "
        + "sentMessages=" + sentMessages
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof PublisherStats) {
      PublisherStats that = (PublisherStats) o;
      return (this.ackedMessages == that.getAckedMessages())
           && (this.failedMessages == that.getFailedMessages())
           && (this.pendingMessages == that.getPendingMessages())
           && (this.sentMessages == that.getSentMessages());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= (this.ackedMessages >>> 32) ^ this.ackedMessages;
    h *= 1000003;
    h ^= (this.failedMessages >>> 32) ^ this.failedMessages;
    h *= 1000003;
    h ^= (this.pendingMessages >>> 32) ^ this.pendingMessages;
    h *= 1000003;
    h ^= (this.sentMessages >>> 32) ^ this.sentMessages;
    return h;
  }

  static final class Builder extends PublisherStats.Builder {
    private Long ackedMessages;
    private Long failedMessages;
    private Long pendingMessages;
    private Long sentMessages;
    Builder() {
    }
    Builder(PublisherStats source) {
      this.ackedMessages = source.getAckedMessages();
      this.failedMessages = source.getFailedMessages();
      this.pendingMessages = source.getPendingMessages();
      this.sentMessages = source.getSentMessages();
    }
    @Override
    public PublisherStats.Builder setAckedMessages(long ackedMessages) {
      this.ackedMessages = ackedMessages;
      return this;
    }
    @Override
    public PublisherStats.Builder setFailedMessages(long failedMessages) {
      this.failedMessages = failedMessages;
      return this;
    }
    @Override
    public PublisherStats.Builder setPendingMessages(long pendingMessages) {
      this.pendingMessages = pendingMessages;
      return this;
    }
    @Override
    public PublisherStats.Builder setSentMessages(long sentMessages) {
      this.sentMessages = sentMessages;
      return this;
    }
    @Override
    public PublisherStats build() {
      String missing = "";
      if (ackedMessages == null) {
        missing += " ackedMessages";
      }
      if (failedMessages == null) {
        missing += " failedMessages";
      }
      if (pendingMessages == null) {
        missing += " pendingMessages";
      }
      if (sentMessages == null) {
        missing += " sentMessages";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_PublisherStats(
          this.ackedMessages,
          this.failedMessages,
          this.pendingMessages,
          this.sentMessages);
    }
  }

}
