
package com.google.cloud.pubsub.v1;

import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_SubscriberStats extends SubscriberStats {

  private final long receivedMessages;
  private final long ackedMessages;
  private final long totalReceivedMessages;
  private final long totalAckedMessages;
  private final SubscriberStats.Stats endToEndLatency;
  private final SubscriberStats.Stats ackLatency;
  private final long numberOfAutoExtendedAckDeadlines;

  private AutoValue_SubscriberStats(
      long receivedMessages,
      long ackedMessages,
      long totalReceivedMessages,
      long totalAckedMessages,
      SubscriberStats.Stats endToEndLatency,
      SubscriberStats.Stats ackLatency,
      long numberOfAutoExtendedAckDeadlines) {
    this.receivedMessages = receivedMessages;
    this.ackedMessages = ackedMessages;
    this.totalReceivedMessages = totalReceivedMessages;
    this.totalAckedMessages = totalAckedMessages;
    if (endToEndLatency == null) {
      throw new NullPointerException("Null endToEndLatency");
    }
    this.endToEndLatency = endToEndLatency;
    if (ackLatency == null) {
      throw new NullPointerException("Null ackLatency");
    }
    this.ackLatency = ackLatency;
    this.numberOfAutoExtendedAckDeadlines = numberOfAutoExtendedAckDeadlines;
  }

  @Override
  public long getReceivedMessages() {
    return receivedMessages;
  }

  @Override
  public long getAckedMessages() {
    return ackedMessages;
  }

  @Override
  public long getTotalReceivedMessages() {
    return totalReceivedMessages;
  }

  @Override
  public long getTotalAckedMessages() {
    return totalAckedMessages;
  }

  @Override
  public SubscriberStats.Stats getEndToEndLatency() {
    return endToEndLatency;
  }

  @Override
  public SubscriberStats.Stats getAckLatency() {
    return ackLatency;
  }

  @Override
  public long getNumberOfAutoExtendedAckDeadlines() {
    return numberOfAutoExtendedAckDeadlines;
  }

  @Override
  public String toString() {
    return "SubscriberStats{"
        + "receivedMessages=" + receivedMessages + ", "
        + "ackedMessages=" + ackedMessages + ", "
        + "totalReceivedMessages=" + totalReceivedMessages + ", "
        + "totalAckedMessages=" + totalAckedMessages + ", "
        + "endToEndLatency=" + endToEndLatency + ", "
        + "ackLatency=" + ackLatency + ", "
        + "numberOfAutoExtendedAckDeadlines=" + numberOfAutoExtendedAckDeadlines
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SubscriberStats) {
      SubscriberStats that = (SubscriberStats) o;
      return (this.receivedMessages == that.getReceivedMessages())
           && (this.ackedMessages == that.getAckedMessages())
           && (this.totalReceivedMessages == that.getTotalReceivedMessages())
           && (this.totalAckedMessages == that.getTotalAckedMessages())
           && (this.endToEndLatency.equals(that.getEndToEndLatency()))
           && (this.ackLatency.equals(that.getAckLatency()))
           && (this.numberOfAutoExtendedAckDeadlines == that.getNumberOfAutoExtendedAckDeadlines());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= (this.receivedMessages >>> 32) ^ this.receivedMessages;
    h *= 1000003;
    h ^= (this.ackedMessages >>> 32) ^ this.ackedMessages;
    h *= 1000003;
    h ^= (this.totalReceivedMessages >>> 32) ^ this.totalReceivedMessages;
    h *= 1000003;
    h ^= (this.totalAckedMessages >>> 32) ^ this.totalAckedMessages;
    h *= 1000003;
    h ^= this.endToEndLatency.hashCode();
    h *= 1000003;
    h ^= this.ackLatency.hashCode();
    h *= 1000003;
    h ^= (this.numberOfAutoExtendedAckDeadlines >>> 32) ^ this.numberOfAutoExtendedAckDeadlines;
    return h;
  }

  static final class Builder extends SubscriberStats.Builder {
    private Long receivedMessages;
    private Long ackedMessages;
    private Long totalReceivedMessages;
    private Long totalAckedMessages;
    private SubscriberStats.Stats endToEndLatency;
    private SubscriberStats.Stats ackLatency;
    private Long numberOfAutoExtendedAckDeadlines;
    Builder() {
    }
    Builder(SubscriberStats source) {
      this.receivedMessages = source.getReceivedMessages();
      this.ackedMessages = source.getAckedMessages();
      this.totalReceivedMessages = source.getTotalReceivedMessages();
      this.totalAckedMessages = source.getTotalAckedMessages();
      this.endToEndLatency = source.getEndToEndLatency();
      this.ackLatency = source.getAckLatency();
      this.numberOfAutoExtendedAckDeadlines = source.getNumberOfAutoExtendedAckDeadlines();
    }
    @Override
    public SubscriberStats.Builder setReceivedMessages(long receivedMessages) {
      this.receivedMessages = receivedMessages;
      return this;
    }
    @Override
    public SubscriberStats.Builder setAckedMessages(long ackedMessages) {
      this.ackedMessages = ackedMessages;
      return this;
    }
    @Override
    public SubscriberStats.Builder setTotalReceivedMessages(long totalReceivedMessages) {
      this.totalReceivedMessages = totalReceivedMessages;
      return this;
    }
    @Override
    public SubscriberStats.Builder setTotalAckedMessages(long totalAckedMessages) {
      this.totalAckedMessages = totalAckedMessages;
      return this;
    }
    @Override
    public SubscriberStats.Builder setEndToEndLatency(SubscriberStats.Stats endToEndLatency) {
      this.endToEndLatency = endToEndLatency;
      return this;
    }
    @Override
    public SubscriberStats.Builder setAckLatency(SubscriberStats.Stats ackLatency) {
      this.ackLatency = ackLatency;
      return this;
    }
    @Override
    public SubscriberStats.Builder setNumberOfAutoExtendedAckDeadlines(long numberOfAutoExtendedAckDeadlines) {
      this.numberOfAutoExtendedAckDeadlines = numberOfAutoExtendedAckDeadlines;
      return this;
    }
    @Override
    public SubscriberStats build() {
      String missing = "";
      if (receivedMessages == null) {
        missing += " receivedMessages";
      }
      if (ackedMessages == null) {
        missing += " ackedMessages";
      }
      if (totalReceivedMessages == null) {
        missing += " totalReceivedMessages";
      }
      if (totalAckedMessages == null) {
        missing += " totalAckedMessages";
      }
      if (endToEndLatency == null) {
        missing += " endToEndLatency";
      }
      if (ackLatency == null) {
        missing += " ackLatency";
      }
      if (numberOfAutoExtendedAckDeadlines == null) {
        missing += " numberOfAutoExtendedAckDeadlines";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SubscriberStats(
          this.receivedMessages,
          this.ackedMessages,
          this.totalReceivedMessages,
          this.totalAckedMessages,
          this.endToEndLatency,
          this.ackLatency,
          this.numberOfAutoExtendedAckDeadlines);
    }
  }

}
