/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.javapoet;

import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.shaded.auto.common.MoreTypes;
import javax.lang.model.type.TypeMirror;

public final class Expression {
    private final TypeMirror type;
    private final CodeBlock codeBlock;

    private Expression(TypeMirror type, CodeBlock codeBlock) {
        this.type = type;
        this.codeBlock = codeBlock;
    }

    public static Expression create(TypeMirror type, CodeBlock expression) {
        return new Expression(type, expression);
    }

    public static Expression create(TypeMirror type, String format, Object ... args) {
        return Expression.create(type, CodeBlock.of((String)format, (Object[])args));
    }

    public Expression castTo(TypeMirror newType) {
        return Expression.create(newType, "($T) $L", newType, this.codeBlock);
    }

    public Expression box(DaggerTypes types) {
        return this.type.getKind().isPrimitive() ? this.castTo(types.boxedClass(MoreTypes.asPrimitiveType(this.type)).asType()) : this;
    }

    public TypeMirror type() {
        return this.type;
    }

    public CodeBlock codeBlock() {
        return this.codeBlock;
    }

    public String toString() {
        return String.format("[%s] %s", this.type, this.codeBlock);
    }
}

