/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ResolvedBindings;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.model.RequestKind;
import java.util.Map;

final class LegacyBindingGraph {
    private final ComponentDescriptor componentDescriptor;
    private final ImmutableMap<Key, ResolvedBindings> contributionBindings;
    private final ImmutableMap<Key, ResolvedBindings> membersInjectionBindings;
    private final ImmutableList<LegacyBindingGraph> subgraphs;

    LegacyBindingGraph(ComponentDescriptor componentDescriptor, ImmutableMap<Key, ResolvedBindings> contributionBindings, ImmutableMap<Key, ResolvedBindings> membersInjectionBindings, ImmutableList<LegacyBindingGraph> subgraphs) {
        this.componentDescriptor = componentDescriptor;
        this.contributionBindings = contributionBindings;
        this.membersInjectionBindings = membersInjectionBindings;
        this.subgraphs = LegacyBindingGraph.checkForDuplicates(subgraphs);
    }

    ComponentDescriptor componentDescriptor() {
        return this.componentDescriptor;
    }

    ResolvedBindings resolvedBindings(BindingRequest request) {
        return request.isRequestKind(RequestKind.MEMBERS_INJECTION) ? (ResolvedBindings)this.membersInjectionBindings.get((Object)request.key()) : (ResolvedBindings)this.contributionBindings.get((Object)request.key());
    }

    Iterable<ResolvedBindings> resolvedBindings() {
        return Iterables.concat((Iterable)this.membersInjectionBindings.values(), (Iterable)this.contributionBindings.values());
    }

    ImmutableList<LegacyBindingGraph> subgraphs() {
        return this.subgraphs;
    }

    private static ImmutableList<LegacyBindingGraph> checkForDuplicates(ImmutableList<LegacyBindingGraph> graphs) {
        Map duplicateGraphs = Maps.filterValues((Map)Multimaps.index(graphs, graph -> graph.componentDescriptor().typeElement()).asMap(), overlapping -> overlapping.size() > 1);
        if (!duplicateGraphs.isEmpty()) {
            throw new IllegalArgumentException("Expected no duplicates: " + duplicateGraphs);
        }
        return graphs;
    }
}

