/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.Preconditions;
import dagger.internal.codegen.base.ComponentCreatorKind;
import dagger.internal.codegen.base.UniqueNameSet;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingNode;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ComponentCreatorDescriptor;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.KeyVariableNamer;
import dagger.internal.codegen.binding.MethodSignature;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.AnnotationSpecs;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.javapoet.TypeSpecs;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.model.RequestKind;
import dagger.internal.codegen.writing.ComponentCreatorImplementation;
import dagger.internal.codegen.writing.ComponentCreatorImplementationFactory;
import dagger.internal.codegen.writing.ComponentNames;
import dagger.internal.codegen.writing.ComponentRequestRepresentations;
import dagger.internal.codegen.writing.ExperimentalSwitchingProviders;
import dagger.internal.codegen.writing.GeneratedImplementation;
import dagger.internal.codegen.writing.ParentComponent;
import dagger.internal.codegen.writing.PerComponentImplementation;
import dagger.internal.codegen.writing.SwitchingProviders;
import dagger.internal.codegen.writing.TopLevel;
import dagger.internal.codegen.xprocessing.MethodSpecs;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMessager;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XVariableElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.lang.model.element.Modifier;
import javax.tools.Diagnostic;

@PerComponentImplementation
public final class ComponentImplementation {
    public static final ParameterSpec MAY_INTERRUPT_IF_RUNNING_PARAM = ParameterSpec.builder(Boolean.TYPE, (String)"mayInterruptIfRunning", (Modifier[])new Modifier[0]).build();
    private static final String CANCELLATION_LISTENER_METHOD_NAME = "onProducerFutureCancelled";
    private static final int STATEMENTS_PER_METHOD = 100;
    private final ShardImplementation componentShard;
    private final Supplier<ImmutableMap<Binding, ShardImplementation>> shardsByBinding;
    private final Map<ShardImplementation, FieldSpec> shardFieldsByImplementation = new HashMap<ShardImplementation, FieldSpec>();
    private final List<CodeBlock> shardInitializations = new ArrayList<CodeBlock>();
    private final List<CodeBlock> shardCancellations = new ArrayList<CodeBlock>();
    private final Optional<ComponentImplementation> parent;
    private final ChildComponentImplementationFactory childComponentImplementationFactory;
    private final Provider<GeneratedImplementation> topLevelImplementationProvider;
    private final Provider<ComponentRequestRepresentations> componentRequestRepresentationsProvider;
    private final Provider<ComponentCreatorImplementationFactory> componentCreatorImplementationFactoryProvider;
    private final BindingGraph graph;
    private final ComponentNames componentNames;
    private final CompilerOptions compilerOptions;
    private final ImmutableMap<ComponentImplementation, FieldSpec> componentFieldsByImplementation;
    private final XMessager messager;
    private final CompilerMode compilerMode;
    private final XProcessingEnv processingEnv;

    private static ImmutableMap<Binding, ShardImplementation> createShardsByBinding(ShardImplementation componentShard, BindingGraph graph, CompilerOptions compilerOptions) {
        ImmutableList<ImmutableList<Binding>> partitions = ComponentImplementation.bindingPartitions(graph, compilerOptions);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < partitions.size(); ++i) {
            ShardImplementation shard = i == 0 ? componentShard : componentShard.createShard();
            ((ImmutableList)partitions.get(i)).forEach(binding -> builder.put(binding, (Object)shard));
        }
        return builder.build();
    }

    private static ImmutableList<ImmutableList<Binding>> bindingPartitions(BindingGraph graph, CompilerOptions compilerOptions) {
        int bindingsPerShard = compilerOptions.keysPerComponentShard(graph.componentTypeElement());
        int maxPartitions = graph.localBindingNodes().size() / bindingsPerShard + 1;
        if (maxPartitions <= 1) {
            return ImmutableList.of((Object)((ImmutableList)graph.localBindingNodes().stream().map(BindingNode::delegate).collect(DaggerStreams.toImmutableList())));
        }
        ArrayList currPartition = new ArrayList(bindingsPerShard);
        ImmutableList.Builder partitions = ImmutableList.builderWithExpectedSize((int)maxPartitions);
        for (ImmutableSet nodes : graph.topLevelBindingGraph().stronglyConnectedNodes()) {
            nodes.stream().flatMap(DaggerStreams.instancesOf(BindingNode.class)).filter(bindingNode -> bindingNode.componentPath().equals(graph.componentPath())).map(BindingNode::delegate).forEach(currPartition::add);
            if (currPartition.size() < bindingsPerShard) continue;
            partitions.add((Object)ImmutableList.copyOf(currPartition));
            currPartition = new ArrayList(bindingsPerShard);
        }
        if (!currPartition.isEmpty()) {
            partitions.add((Object)ImmutableList.copyOf(currPartition));
        }
        return partitions.build();
    }

    @Inject
    ComponentImplementation(@ParentComponent Optional<ComponentImplementation> parent, ChildComponentImplementationFactory childComponentImplementationFactory, @TopLevel Provider<GeneratedImplementation> topLevelImplementationProvider, Provider<ComponentRequestRepresentations> componentRequestRepresentationsProvider, Provider<ComponentCreatorImplementationFactory> componentCreatorImplementationFactoryProvider, BindingGraph graph, ComponentNames componentNames, CompilerOptions compilerOptions, XMessager messager, XProcessingEnv processingEnv) {
        this.parent = parent;
        this.childComponentImplementationFactory = childComponentImplementationFactory;
        this.topLevelImplementationProvider = topLevelImplementationProvider;
        this.componentRequestRepresentationsProvider = componentRequestRepresentationsProvider;
        this.componentCreatorImplementationFactoryProvider = componentCreatorImplementationFactoryProvider;
        this.graph = graph;
        this.componentNames = componentNames;
        this.compilerOptions = compilerOptions;
        this.processingEnv = processingEnv;
        this.componentShard = new ShardImplementation(componentNames.get(graph.componentPath()));
        XTypeElements.getAllNonPrivateInstanceMethods(graph.componentTypeElement()).stream().forEach(method -> this.componentShard.componentMethodNames.claim(XElements.getSimpleName((XElement)method)));
        this.shardsByBinding = Suppliers.memoize(() -> ComponentImplementation.createShardsByBinding(this.componentShard, graph, compilerOptions));
        this.componentFieldsByImplementation = ComponentImplementation.createComponentFieldsByImplementation(this, compilerOptions);
        this.messager = messager;
        XTypeElement typeElement = this.rootComponentImplementation().componentDescriptor().typeElement();
        this.compilerMode = compilerOptions.fastInit(typeElement) ? CompilerMode.FAST_INIT : (compilerOptions.experimentalMergedMode(typeElement) ? CompilerMode.EXPERIMENTAL_MERGED_MODE : CompilerMode.DEFAULT);
    }

    public ShardImplementation shardImplementation(Binding binding) {
        com.google.common.base.Preconditions.checkState((boolean)((ImmutableMap)this.shardsByBinding.get()).containsKey((Object)binding), (String)"No shard in %s for: %s", (Object)this.name(), (Object)binding);
        return (ShardImplementation)((ImmutableMap)this.shardsByBinding.get()).get((Object)binding);
    }

    private GeneratedImplementation topLevelImplementation() {
        return (GeneratedImplementation)this.topLevelImplementationProvider.get();
    }

    public ComponentImplementation rootComponentImplementation() {
        return this.parent.map(ComponentImplementation::rootComponentImplementation).orElse(this);
    }

    public CodeBlock componentFieldReference() {
        return CodeBlock.of((String)"$N", (Object[])new Object[]{this.componentFieldsByImplementation.get((Object)this)});
    }

    public ImmutableList<FieldSpec> componentFields() {
        return ImmutableList.copyOf((Collection)this.componentFieldsByImplementation.values());
    }

    public ImmutableList<FieldSpec> creatorComponentFields() {
        return (ImmutableList)this.componentFieldsByImplementation.entrySet().stream().filter(entry -> !this.equals(entry.getKey())).map(Map.Entry::getValue).collect(DaggerStreams.toImmutableList());
    }

    private static ImmutableMap<ComponentImplementation, FieldSpec> createComponentFieldsByImplementation(ComponentImplementation componentImplementation, CompilerOptions compilerOptions) {
        com.google.common.base.Preconditions.checkArgument((componentImplementation.componentShard != null ? 1 : 0) != 0, (Object)"The component shard must be set before computing the component fields.");
        ImmutableList.Builder builder = ImmutableList.builder();
        ComponentImplementation curr = componentImplementation;
        while (curr != null) {
            builder.add((Object)curr);
            curr = curr.parent.orElse(null);
        }
        return (ImmutableMap)builder.build().reverse().stream().collect(DaggerStreams.toImmutableMap(componentImpl -> componentImpl, componentImpl -> {
            ClassName component = componentImpl.graph.componentPath().currentComponent().className();
            ClassName fieldType = componentImpl.name();
            String fieldName = componentImpl.isNested() ? SourceFiles.simpleVariableName(componentImpl.name()) : SourceFiles.simpleVariableName(component);
            FieldSpec.Builder field = FieldSpec.builder((TypeName)fieldType, (String)(fieldName.equals(componentImpl.name().simpleName()) ? "_" + fieldName : fieldName), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            componentImplementation.componentShard.componentFieldNames.claim(fieldName);
            return field.build();
        }));
    }

    public ShardImplementation getComponentShard() {
        return this.componentShard;
    }

    public BindingGraph graph() {
        return this.componentShard.graph();
    }

    public ComponentDescriptor componentDescriptor() {
        return this.componentShard.componentDescriptor();
    }

    public ClassName name() {
        return this.componentShard.name;
    }

    public CompilerMode compilerMode() {
        return this.compilerMode;
    }

    private boolean isNested() {
        return this.name().enclosingClassName() != null;
    }

    public ClassName getCreatorName() {
        return this.componentNames.getCreatorName(this.graph.componentPath());
    }

    public TypeSpec generate() {
        return this.componentShard.generate();
    }

    private static ImmutableList<ComponentRequirement> constructorRequirements(BindingGraph graph) {
        if (graph.componentDescriptor().hasCreator()) {
            return graph.componentRequirements().asList();
        }
        if (graph.factoryMethod().isPresent()) {
            return graph.factoryMethodParameters().keySet().asList();
        }
        throw new AssertionError((Object)"Expected either a component creator or factory method but found neither.");
    }

    private static ImmutableList<ParameterSpec> makeFinal(List<ParameterSpec> parameters) {
        return (ImmutableList)parameters.stream().map(param -> param.toBuilder().addModifiers(new Modifier[]{Modifier.FINAL}).build()).collect(DaggerStreams.toImmutableList());
    }

    public final class ShardImplementation
    implements GeneratedImplementation {
        private final ClassName name;
        private final UniqueNameSet componentFieldNames = new UniqueNameSet();
        private final UniqueNameSet componentMethodNames = new UniqueNameSet();
        private final UniqueNameSet componentClassNames = new UniqueNameSet();
        private final UniqueNameSet assistedParamNames = new UniqueNameSet();
        private final List<CodeBlock> initializations = new ArrayList<CodeBlock>();
        private final SwitchingProviders switchingProviders;
        private final ExperimentalSwitchingProviders experimentalSwitchingProviders;
        private final Map<Key, CodeBlock> cancellations = new LinkedHashMap<Key, CodeBlock>();
        private final Map<XVariableElement, String> uniqueAssistedName = new LinkedHashMap<XVariableElement, String>();
        private final List<CodeBlock> componentRequirementInitializations = new ArrayList<CodeBlock>();
        private final ImmutableMap<ComponentRequirement, ParameterSpec> constructorParameters;
        private final ListMultimap<FieldSpecKind, FieldSpec> fieldSpecsMap = MultimapBuilder.enumKeys(FieldSpecKind.class).arrayListValues().build();
        private final ListMultimap<MethodSpecKind, MethodSpec> methodSpecsMap = MultimapBuilder.enumKeys(MethodSpecKind.class).arrayListValues().build();
        private final ListMultimap<TypeSpecKind, TypeSpec> typeSpecsMap = MultimapBuilder.enumKeys(TypeSpecKind.class).arrayListValues().build();
        private final List<Supplier<TypeSpec>> typeSuppliers = new ArrayList<Supplier<TypeSpec>>();
        private boolean initialized = false;

        private ShardImplementation(ClassName name) {
            this.name = name;
            this.switchingProviders = new SwitchingProviders(this, ComponentImplementation.this.processingEnv);
            this.experimentalSwitchingProviders = new ExperimentalSwitchingProviders(this, (Provider<ComponentRequestRepresentations>)ComponentImplementation.this.componentRequestRepresentationsProvider);
            if (ComponentImplementation.this.graph.componentDescriptor().isProduction()) {
                this.claimMethodName(ComponentImplementation.CANCELLATION_LISTENER_METHOD_NAME);
            }
            this.constructorParameters = (ImmutableMap)ComponentImplementation.constructorRequirements(ComponentImplementation.this.graph).stream().collect(DaggerStreams.toImmutableMap(requirement -> requirement, requirement -> ParameterSpec.builder((TypeName)requirement.type().getTypeName(), (String)this.getUniqueFieldName(requirement.variableName() + "Param"), (Modifier[])new Modifier[0]).build()));
        }

        private ShardImplementation createShard() {
            com.google.common.base.Preconditions.checkState((boolean)this.isComponentShard(), (Object)"Only the componentShard can create other shards.");
            return new ShardImplementation(ComponentImplementation.this.topLevelImplementation().name().nestedClass(ComponentImplementation.this.topLevelImplementation().getUniqueClassName(ComponentImplementation.this.getComponentShard().name().simpleName() + "Shard")));
        }

        public SwitchingProviders getSwitchingProviders() {
            return this.switchingProviders;
        }

        public ExperimentalSwitchingProviders getExperimentalSwitchingProviders() {
            return this.experimentalSwitchingProviders;
        }

        public ComponentImplementation getComponentImplementation() {
            return ComponentImplementation.this;
        }

        public boolean isComponentShard() {
            return this == ComponentImplementation.this.componentShard;
        }

        public ImmutableMap<ComponentImplementation, FieldSpec> componentFieldsByImplementation() {
            return ComponentImplementation.this.componentFieldsByImplementation;
        }

        public CodeBlock shardFieldReference() {
            if (!this.isComponentShard() && !ComponentImplementation.this.shardFieldsByImplementation.containsKey(this)) {
                String shardFieldName = ComponentImplementation.this.componentShard.getUniqueFieldName(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, this.name.simpleName()));
                FieldSpec shardField = FieldSpec.builder((TypeName)this.name, (String)shardFieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
                ComponentImplementation.this.shardFieldsByImplementation.put(this, shardField);
            }
            return this.isComponentShard() ? ComponentImplementation.this.componentFieldReference() : CodeBlock.of((String)"$L.$N", (Object[])new Object[]{ComponentImplementation.this.componentFieldReference(), ComponentImplementation.this.shardFieldsByImplementation.get(this)});
        }

        public BindingGraph graph() {
            return ComponentImplementation.this.graph;
        }

        public ComponentDescriptor componentDescriptor() {
            return ComponentImplementation.this.graph.componentDescriptor();
        }

        @Override
        public ClassName name() {
            return this.name;
        }

        ClassName getSubcomponentCreatorSimpleName(Key creatorKey) {
            return ComponentImplementation.this.componentNames.getSubcomponentCreatorName(ComponentImplementation.this.graph.componentPath(), creatorKey);
        }

        TypeName accessibleTypeName(XType type) {
            return Accessibility.accessibleTypeName(type, this.name(), ComponentImplementation.this.processingEnv);
        }

        boolean isTypeAccessible(XType type) {
            return Accessibility.isTypeAccessibleFrom(type, this.name.packageName());
        }

        @Override
        public void addField(FieldSpecKind fieldKind, FieldSpec fieldSpec) {
            this.fieldSpecsMap.put((Object)fieldKind, (Object)fieldSpec);
        }

        @Override
        public void addMethod(MethodSpecKind methodKind, MethodSpec methodSpec) {
            this.methodSpecsMap.put((Object)methodKind, (Object)methodSpec);
        }

        @Override
        public void addType(TypeSpecKind typeKind, TypeSpec typeSpec) {
            this.typeSpecsMap.put((Object)typeKind, (Object)typeSpec);
        }

        void addTypeSupplier(Supplier<TypeSpec> typeSpecSupplier) {
            this.typeSuppliers.add(typeSpecSupplier);
        }

        void addInitialization(CodeBlock codeBlock) {
            this.initializations.add(codeBlock);
        }

        void addComponentRequirementInitialization(CodeBlock codeBlock) {
            this.componentRequirementInitializations.add(codeBlock);
        }

        void addCancellation(Key key, CodeBlock codeBlock) {
            this.cancellations.putIfAbsent(key, codeBlock);
        }

        String getUniqueFieldName(String name) {
            return this.componentFieldNames.getUniqueName(name);
        }

        String getUniqueAssistedParamName(String name) {
            if (!this.initialized) {
                this.componentFieldsByImplementation().values().forEach(fieldSpec -> this.assistedParamNames.getUniqueName(fieldSpec.name));
                this.initialized = true;
            }
            return this.assistedParamNames.getUniqueName(name);
        }

        public String getUniqueFieldNameForAssistedParam(XVariableElement element) {
            if (this.uniqueAssistedName.containsKey(element)) {
                return this.uniqueAssistedName.get(element);
            }
            String name = this.getUniqueAssistedParamName(XElements.getSimpleName((XElement)element));
            this.uniqueAssistedName.put(element, name);
            return name;
        }

        public String getUniqueMethodName(String name) {
            return this.componentMethodNames.getUniqueName(name);
        }

        String getUniqueMethodName(BindingRequest request) {
            return this.uniqueMethodName(request, KeyVariableNamer.name(request.key()));
        }

        @Override
        public String getUniqueClassName(String name) {
            return this.componentClassNames.getUniqueName(name);
        }

        private String uniqueMethodName(BindingRequest request, String bindingName) {
            String baseMethodName = bindingName + (request.isRequestKind(RequestKind.INSTANCE) ? "" : CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, request.kindName()));
            return this.getUniqueMethodName(baseMethodName);
        }

        public String getParameterName(ComponentRequirement requirement) {
            return ((ParameterSpec)this.constructorParameters.get((Object)requirement)).name;
        }

        public void claimMethodName(CharSequence name) {
            this.componentMethodNames.claim(name);
        }

        @Override
        public TypeSpec generate() {
            TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)this.name);
            if (this.isComponentShard()) {
                TypeSpecs.addSupertype(builder, ComponentImplementation.this.graph.componentTypeElement());
                this.addCreator();
                this.addFactoryMethods();
                this.addInterfaceMethods();
                this.addChildComponents();
                this.addShards();
            }
            this.addConstructorAndInitializationMethods();
            if (ComponentImplementation.this.graph.componentDescriptor().isProduction() && (this.isComponentShard() || !this.cancellations.isEmpty())) {
                TypeSpecs.addSupertype(builder, ComponentImplementation.this.processingEnv.requireTypeElement((TypeName)TypeNames.CANCELLATION_LISTENER));
                this.addCancellationListenerImplementation();
            }
            this.modifiers().forEach(xva$0 -> builder.addModifiers(new Modifier[]{xva$0}));
            this.fieldSpecsMap.asMap().values().forEach(arg_0 -> ((TypeSpec.Builder)builder).addFields(arg_0));
            this.methodSpecsMap.asMap().values().forEach(arg_0 -> ((TypeSpec.Builder)builder).addMethods(arg_0));
            this.typeSpecsMap.asMap().values().forEach(arg_0 -> ((TypeSpec.Builder)builder).addTypes(arg_0));
            this.typeSuppliers.stream().map(Supplier::get).forEach(arg_0 -> ((TypeSpec.Builder)builder).addType(arg_0));
            if (!ComponentImplementation.this.compilerOptions.generatedClassExtendsComponent() && this.isComponentShard() && ComponentImplementation.this.graph.componentPath().atRoot()) {
                ComponentImplementation.this.topLevelImplementation().addType(TypeSpecKind.COMPONENT_IMPL, builder.build());
                return ComponentImplementation.this.topLevelImplementation().generate();
            }
            return builder.build();
        }

        private ImmutableSet<Modifier> modifiers() {
            return ComponentImplementation.this.isNested() || !this.isComponentShard() ? ImmutableSet.of((Object)((Object)Modifier.PRIVATE), (Object)((Object)Modifier.STATIC), (Object)((Object)Modifier.FINAL)) : (ComponentImplementation.this.graph.componentTypeElement().isPublic() ? ImmutableSet.of((Object)((Object)Modifier.PUBLIC), (Object)((Object)Modifier.FINAL)) : ImmutableSet.of((Object)((Object)Modifier.FINAL)));
        }

        private void addCreator() {
            ((ComponentCreatorImplementationFactory)ComponentImplementation.this.componentCreatorImplementationFactoryProvider.get()).create().map(ComponentCreatorImplementation::spec).ifPresent(creator -> ComponentImplementation.this.topLevelImplementation().addType(TypeSpecKind.COMPONENT_CREATOR, (TypeSpec)creator));
        }

        private void addFactoryMethods() {
            if (ComponentImplementation.this.parent.isPresent()) {
                ComponentImplementation.this.graph.factoryMethod().ifPresent(this::createSubcomponentFactoryMethod);
            } else {
                this.createRootComponentFactoryMethod();
            }
        }

        private void createRootComponentFactoryMethod() {
            boolean noArgFactoryMethod;
            String factoryMethodName;
            ClassName creatorType;
            ComponentCreatorKind creatorKind;
            com.google.common.base.Preconditions.checkState((!ComponentImplementation.this.parent.isPresent() ? 1 : 0) != 0);
            Optional<ComponentCreatorDescriptor> creatorDescriptor = ComponentImplementation.this.graph.componentDescriptor().creatorDescriptor();
            if (creatorDescriptor.isPresent()) {
                ComponentCreatorDescriptor descriptor = creatorDescriptor.get();
                creatorKind = descriptor.kind();
                creatorType = descriptor.typeElement().getClassName();
                factoryMethodName = XElements.getSimpleName((XElement)descriptor.factoryMethod());
                noArgFactoryMethod = descriptor.factoryParameters().isEmpty();
            } else {
                creatorKind = ComponentCreatorKind.BUILDER;
                creatorType = ComponentImplementation.this.getCreatorName();
                factoryMethodName = "build";
                noArgFactoryMethod = true;
            }
            this.validateMethodNameDoesNotOverrideGeneratedCreator(creatorKind.methodName());
            this.claimMethodName(creatorKind.methodName());
            ComponentImplementation.this.topLevelImplementation().addMethod(MethodSpecKind.BUILDER_METHOD, MethodSpec.methodBuilder((String)creatorKind.methodName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)creatorType).addStatement("return new $T()", new Object[]{ComponentImplementation.this.getCreatorName()}).build());
            if (noArgFactoryMethod && this.canInstantiateAllRequirements()) {
                this.validateMethodNameDoesNotOverrideGeneratedCreator("create");
                this.claimMethodName("create");
                ComponentImplementation.this.topLevelImplementation().addMethod(MethodSpecKind.BUILDER_METHOD, MethodSpec.methodBuilder((String)"create").returns((TypeName)ComponentImplementation.this.graph.componentTypeElement().getClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addStatement("return new $L().$L()", new Object[]{creatorKind.typeName(), factoryMethodName}).build());
            }
        }

        private void validateMethodNameDoesNotOverrideGeneratedCreator(String creatorName) {
            XTypeElements.getAllMethods(ComponentImplementation.this.graph.componentTypeElement()).stream().filter(method -> XElements.getSimpleName((XElement)method).contentEquals(creatorName)).filter(method -> method.getParameters().isEmpty()).filter(method -> !method.isStatic()).forEach(method -> ComponentImplementation.this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("The method %s.%s() conflicts with a method of the same name Dagger is trying to generate as a way to instantiate the component. Please choose a different name for your method.", method.getEnclosingElement().getClassName().canonicalName(), XElements.getSimpleName((XElement)method))));
        }

        private boolean canInstantiateAllRequirements() {
            return !Iterables.any(ComponentImplementation.this.graph.componentRequirements(), ComponentRequirement::requiresAPassedInstance);
        }

        private void createSubcomponentFactoryMethod(XMethodElement factoryMethod) {
            com.google.common.base.Preconditions.checkState((boolean)ComponentImplementation.this.parent.isPresent());
            XType parentType = ((ComponentImplementation)ComponentImplementation.this.parent.get()).graph().componentTypeElement().getType();
            MethodSpec.Builder method = MethodSpecs.overriding(factoryMethod, parentType);
            method.parameters.forEach(param -> method.addStatement("$T.checkNotNull($N)", new Object[]{Preconditions.class, param}));
            method.addStatement("return new $T($L)", new Object[]{this.name(), CodeBlocks.parameterNames((Iterable<ParameterSpec>)ImmutableList.builder().addAll((Iterable)ComponentImplementation.this.creatorComponentFields().stream().map(field -> ParameterSpec.builder((TypeName)field.type, (String)field.name, (Modifier[])new Modifier[0]).build()).collect(DaggerStreams.toImmutableList())).addAll((Iterable)method.parameters).build())});
            ((ComponentImplementation)ComponentImplementation.this.parent.get()).getComponentShard().addMethod(MethodSpecKind.COMPONENT_METHOD, method.build());
        }

        private void addInterfaceMethods() {
            XType componentType = ComponentImplementation.this.graph.componentTypeElement().getType();
            HashSet signatures = Sets.newHashSet();
            for (ComponentDescriptor.ComponentMethodDescriptor method : ComponentImplementation.this.graph.componentDescriptor().entryPointMethods()) {
                if (!signatures.add(MethodSignature.forComponentMethod(method, componentType, ComponentImplementation.this.processingEnv))) continue;
                this.addMethod(MethodSpecKind.COMPONENT_METHOD, ((ComponentRequestRepresentations)ComponentImplementation.this.componentRequestRepresentationsProvider.get()).getComponentMethod(method));
            }
        }

        private void addChildComponents() {
            for (BindingGraph subgraph : ComponentImplementation.this.graph.subgraphs()) {
                ComponentImplementation.this.topLevelImplementation().addType(TypeSpecKind.COMPONENT_IMPL, ComponentImplementation.this.childComponentImplementationFactory.create(subgraph).generate());
            }
        }

        private void addShards() {
            for (ShardImplementation shard : ImmutableSet.copyOf((Collection)((ImmutableMap)ComponentImplementation.this.shardsByBinding.get()).values())) {
                if (!ComponentImplementation.this.shardFieldsByImplementation.containsKey(shard)) continue;
                this.addField(FieldSpecKind.COMPONENT_SHARD_FIELD, (FieldSpec)ComponentImplementation.this.shardFieldsByImplementation.get(shard));
                TypeSpec shardTypeSpec = shard.generate();
                ComponentImplementation.this.topLevelImplementation().addType(TypeSpecKind.COMPONENT_SHARD_TYPE, shardTypeSpec);
            }
        }

        private void addConstructorAndInitializationMethods() {
            MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE});
            ImmutableList parameters = this.constructorParameters.values().asList();
            this.componentFieldsByImplementation().forEach((componentImplementation, field) -> {
                if (this.isComponentShard() && componentImplementation.equals(ComponentImplementation.this)) {
                    this.addField(FieldSpecKind.COMPONENT_REQUIREMENT_FIELD, field.toBuilder().initializer("this", new Object[0]).build());
                } else {
                    this.addField(FieldSpecKind.COMPONENT_REQUIREMENT_FIELD, (FieldSpec)field);
                    constructor.addStatement("this.$1N = $1N", new Object[]{field});
                    constructor.addParameter(field.type, field.name, new Modifier[0]);
                }
            });
            if (this.isComponentShard()) {
                constructor.addCode(CodeBlocks.concat(this.componentRequirementInitializations));
            }
            constructor.addParameters((Iterable)parameters);
            CodeBlock args = CodeBlocks.parameterNames((Iterable<ParameterSpec>)parameters);
            ImmutableList<MethodSpec> initializationMethods = this.createPartitionedMethods("initialize", (Iterable<ParameterSpec>)ComponentImplementation.makeFinal((List)parameters), this.initializations, (Function<String, MethodSpec.Builder>)((Function)methodName -> MethodSpec.methodBuilder((String)methodName).addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.UNCHECKED, new AnnotationSpecs.Suppression[0]))));
            for (MethodSpec initializationMethod : initializationMethods) {
                constructor.addStatement("$N($L)", new Object[]{initializationMethod, args});
                this.addMethod(MethodSpecKind.INITIALIZE_METHOD, initializationMethod);
            }
            if (this.isComponentShard()) {
                constructor.addCode(CodeBlocks.concat(ComponentImplementation.this.shardInitializations));
            } else {
                CodeBlock componentArgs = CodeBlocks.parameterNames((Iterable<ParameterSpec>)((ComponentImplementation)ComponentImplementation.this).componentShard.constructorParameters.values().asList());
                CodeBlock componentFields = this.componentFieldsByImplementation().values().stream().map(field -> CodeBlock.of((String)"$N", (Object[])new Object[]{field})).collect(CodeBlocks.toParametersCodeBlock());
                ComponentImplementation.this.shardInitializations.add(CodeBlock.of((String)"$N = new $T($L);", (Object[])new Object[]{ComponentImplementation.this.shardFieldsByImplementation.get(this), this.name, componentArgs.isEmpty() ? componentFields : CodeBlocks.makeParametersCodeBlock((Iterable<CodeBlock>)ImmutableList.of((Object)componentFields, (Object)componentArgs))}));
            }
            this.addMethod(MethodSpecKind.CONSTRUCTOR, constructor.build());
        }

        private void addCancellationListenerImplementation() {
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)ComponentImplementation.CANCELLATION_LISTENER_METHOD_NAME).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(MAY_INTERRUPT_IF_RUNNING_PARAM);
            if (this.isComponentShard()) {
                methodBuilder.addCode(CodeBlocks.concat((Iterable<CodeBlock>)ImmutableList.copyOf((Collection)ComponentImplementation.this.shardCancellations).reverse()));
            } else if (!this.cancellations.isEmpty()) {
                ComponentImplementation.this.shardCancellations.add(CodeBlock.of((String)"$N.$N($N);", (Object[])new Object[]{ComponentImplementation.this.shardFieldsByImplementation.get(this), ComponentImplementation.CANCELLATION_LISTENER_METHOD_NAME, MAY_INTERRUPT_IF_RUNNING_PARAM}));
            }
            ImmutableList cancellationStatements = ImmutableList.copyOf(this.cancellations.values()).reverse();
            if (cancellationStatements.size() < 100) {
                methodBuilder.addCode(CodeBlocks.concat((Iterable<CodeBlock>)cancellationStatements)).build();
            } else {
                ImmutableList<MethodSpec> cancelProducersMethods = this.createPartitionedMethods("cancelProducers", (Iterable<ParameterSpec>)ImmutableList.of((Object)MAY_INTERRUPT_IF_RUNNING_PARAM), (List<CodeBlock>)cancellationStatements, (Function<String, MethodSpec.Builder>)((Function)methodName -> MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PRIVATE})));
                for (MethodSpec cancelProducersMethod : cancelProducersMethods) {
                    methodBuilder.addStatement("$N($N)", new Object[]{cancelProducersMethod, MAY_INTERRUPT_IF_RUNNING_PARAM});
                    this.addMethod(MethodSpecKind.CANCELLATION_LISTENER_METHOD, cancelProducersMethod);
                }
            }
            if (this.isComponentShard()) {
                this.cancelParentStatement().ifPresent(arg_0 -> ((MethodSpec.Builder)methodBuilder).addCode(arg_0));
            }
            this.addMethod(MethodSpecKind.CANCELLATION_LISTENER_METHOD, methodBuilder.build());
        }

        private Optional<CodeBlock> cancelParentStatement() {
            if (!this.shouldPropagateCancellationToParent()) {
                return Optional.empty();
            }
            return Optional.of(CodeBlock.builder().addStatement("$L.$N($N)", new Object[]{((ComponentImplementation)ComponentImplementation.this.parent.get()).componentFieldReference(), ComponentImplementation.CANCELLATION_LISTENER_METHOD_NAME, MAY_INTERRUPT_IF_RUNNING_PARAM}).build());
        }

        private boolean shouldPropagateCancellationToParent() {
            return ComponentImplementation.this.parent.isPresent() && ((ComponentImplementation)ComponentImplementation.this.parent.get()).componentDescriptor().cancellationPolicy().map(policy -> policy.equals((Object)ComponentDescriptor.CancellationPolicy.PROPAGATE)).orElse(false) != false;
        }

        private ImmutableList<MethodSpec> createPartitionedMethods(String methodName, Iterable<ParameterSpec> parameters, List<CodeBlock> statements, Function<String, MethodSpec.Builder> methodBuilderCreator) {
            return (ImmutableList)Lists.partition(statements, (int)100).stream().map(partition -> ((MethodSpec.Builder)methodBuilderCreator.apply((Object)this.getUniqueMethodName(methodName))).addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameters(parameters).addCode(CodeBlocks.concat(partition)).build()).collect(DaggerStreams.toImmutableList());
        }
    }

    public static enum TypeSpecKind {
        PRESENT_FACTORY,
        COMPONENT_CREATOR,
        COMPONENT_PROVISION_FACTORY,
        COMPONENT_IMPL,
        COMPONENT_SHARD_TYPE;

    }

    public static enum MethodSpecKind {
        CONSTRUCTOR,
        BUILDER_METHOD,
        PRIVATE_METHOD,
        INITIALIZE_METHOD,
        COMPONENT_METHOD,
        MEMBERS_INJECTION_METHOD,
        ABSENT_OPTIONAL_METHOD,
        CANCELLATION_LISTENER_METHOD;

    }

    public static enum FieldSpecKind {
        COMPONENT_SHARD_FIELD,
        COMPONENT_REQUIREMENT_FIELD,
        FRAMEWORK_FIELD,
        ABSENT_OPTIONAL_FIELD;

    }

    public static enum CompilerMode {
        DEFAULT,
        FAST_INIT,
        EXPERIMENTAL_MERGED_MODE;


        public boolean isFastInit() {
            return this == FAST_INIT;
        }

        public boolean isExperimentalMergedMode() {
            return this == EXPERIMENTAL_MERGED_MODE;
        }
    }

    public static interface ChildComponentImplementationFactory {
        public ComponentImplementation create(BindingGraph var1);
    }
}

