/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.base.ComponentCreatorKind;
import dagger.internal.codegen.base.UniqueNameSet;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.ComponentCreatorDescriptor;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.KeyFactory;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.model.ComponentPath;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.writing.TopLevel;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.inject.Inject;

public final class ComponentNames {
    private static final Splitter QUALIFIED_NAME_SPLITTER = Splitter.on((char)'.');
    private final CompilerOptions compilerOptions;
    private final ClassName topLevelClassName;
    private final ImmutableMap<ComponentPath, String> namesByPath;
    private final ImmutableMap<ComponentPath, String> creatorNamesByPath;
    private final ImmutableMultimap<Key, ComponentPath> pathsByCreatorKey;

    public static ClassName getTopLevelClassName(ComponentDescriptor componentDescriptor) {
        Preconditions.checkState((!componentDescriptor.isSubcomponent() ? 1 : 0) != 0);
        ClassName componentName = componentDescriptor.typeElement().getClassName();
        return ClassName.get((String)componentName.packageName(), (String)("Dagger" + SourceFiles.classFileName(componentName)), (String[])new String[0]);
    }

    @Inject
    ComponentNames(CompilerOptions compilerOptions, @TopLevel BindingGraph graph, KeyFactory keyFactory) {
        this.compilerOptions = compilerOptions;
        this.topLevelClassName = ComponentNames.getTopLevelClassName(graph.componentDescriptor());
        this.namesByPath = ComponentNames.namesByPath(graph);
        this.creatorNamesByPath = ComponentNames.creatorNamesByPath(this.namesByPath, graph);
        this.pathsByCreatorKey = ComponentNames.pathsByCreatorKey(keyFactory, graph);
    }

    ClassName get(ComponentPath componentPath) {
        return this.compilerOptions.generatedClassExtendsComponent() && componentPath.atRoot() ? this.topLevelClassName : this.topLevelClassName.nestedClass((String)this.namesByPath.get((Object)componentPath) + "Impl");
    }

    ClassName getSubcomponentCreatorName(ComponentPath componentPath, Key creatorKey) {
        Preconditions.checkArgument((boolean)this.pathsByCreatorKey.containsKey((Object)creatorKey));
        ComponentPath subcomponentPath = (ComponentPath)this.pathsByCreatorKey.get((Object)creatorKey).stream().filter(path -> path.parent().equals(componentPath)).collect(DaggerCollectors.onlyElement());
        return this.getCreatorName(subcomponentPath);
    }

    ClassName getCreatorName(ComponentPath componentPath) {
        Preconditions.checkArgument((boolean)this.creatorNamesByPath.containsKey((Object)componentPath));
        return this.topLevelClassName.nestedClass((String)this.creatorNamesByPath.get((Object)componentPath));
    }

    private static ImmutableMap<ComponentPath, String> creatorNamesByPath(ImmutableMap<ComponentPath, String> namesByPath, BindingGraph graph) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        graph.componentDescriptorsByPath().forEach((componentPath, componentDescriptor) -> {
            if (componentPath.atRoot()) {
                ComponentCreatorKind creatorKind = componentDescriptor.creatorDescriptor().map(ComponentCreatorDescriptor::kind).orElse(ComponentCreatorKind.BUILDER);
                builder.put(componentPath, (Object)creatorKind.typeName());
            } else if (componentDescriptor.creatorDescriptor().isPresent()) {
                ComponentCreatorDescriptor creatorDescriptor = componentDescriptor.creatorDescriptor().get();
                String componentName = (String)namesByPath.get(componentPath);
                builder.put(componentPath, (Object)(componentName + creatorDescriptor.kind().typeName()));
            }
        });
        return builder.build();
    }

    private static ImmutableMap<ComponentPath, String> namesByPath(BindingGraph graph) {
        LinkedHashMap componentPathsBySimpleName = new LinkedHashMap();
        Multimaps.index((Iterable)graph.componentDescriptorsByPath().keySet(), ComponentNames::simpleName).asMap().values().stream().map(ComponentNames::disambiguateConflictingSimpleNames).forEach(componentPathsBySimpleName::putAll);
        return ImmutableMap.copyOf(componentPathsBySimpleName);
    }

    private static ImmutableMultimap<Key, ComponentPath> pathsByCreatorKey(KeyFactory keyFactory, BindingGraph graph) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        graph.componentDescriptorsByPath().forEach((componentPath, componentDescriptor) -> {
            if (componentDescriptor.creatorDescriptor().isPresent()) {
                Key creatorKey = keyFactory.forSubcomponentCreator(componentDescriptor.creatorDescriptor().get().typeElement().getType());
                builder.put((Object)creatorKey, componentPath);
            }
        });
        return builder.build();
    }

    private static ImmutableMap<ComponentPath, String> disambiguateConflictingSimpleNames(Collection<ComponentPath> componentsWithConflictingNames) {
        if (componentsWithConflictingNames.size() == 1) {
            ComponentPath componentPath = (ComponentPath)Iterables.getOnlyElement(componentsWithConflictingNames);
            return ImmutableMap.of((Object)componentPath, (Object)ComponentNames.simpleName(componentPath));
        }
        UniqueNameSet nameSet = new UniqueNameSet();
        ImmutableMap.Builder uniqueNames = ImmutableMap.builder();
        for (ComponentPath componentPath : componentsWithConflictingNames) {
            String simpleName = ComponentNames.simpleName(componentPath);
            String basePrefix = ComponentNames.uniquingPrefix(componentPath);
            uniqueNames.put((Object)componentPath, (Object)String.format("%s_%s", nameSet.getUniqueName(basePrefix), simpleName));
        }
        return uniqueNames.build();
    }

    private static String simpleName(ComponentPath componentPath) {
        return componentPath.currentComponent().className().simpleName();
    }

    private static String uniquingPrefix(ComponentPath componentPath) {
        ClassName component = componentPath.currentComponent().className();
        if (component.enclosingClassName() != null) {
            return CharMatcher.javaLowerCase().removeFrom((CharSequence)component.enclosingClassName().simpleName());
        }
        Iterator pieces = QUALIFIED_NAME_SPLITTER.split((CharSequence)component.canonicalName()).iterator();
        StringBuilder b = new StringBuilder();
        while (pieces.hasNext()) {
            String next = (String)pieces.next();
            if (!pieces.hasNext()) continue;
            b.append(next.charAt(0));
        }
        return b.length() > 0 ? b.toString() : "$";
    }
}

