/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.xprocessing.XAnnotationValues;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotationValue;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMemberContainer;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeKt;

public final class AnnotationExpression {
    private final XAnnotation annotation;
    private final ClassName creatorClass;

    AnnotationExpression(XAnnotation annotation) {
        this.annotation = annotation;
        this.creatorClass = AnnotationExpression.getAnnotationCreatorClassName(annotation.getType().getTypeElement());
    }

    CodeBlock getAnnotationInstanceExpression() {
        return this.getAnnotationInstanceExpression(this.annotation);
    }

    private CodeBlock getAnnotationInstanceExpression(XAnnotation annotation) {
        return CodeBlock.of((String)"$T.$L($L)", (Object[])new Object[]{this.creatorClass, AnnotationExpression.createMethodName(annotation.getType().getTypeElement()), CodeBlocks.makeParametersCodeBlock((Iterable)annotation.getAnnotationValues().stream().map(this::getValueExpression).collect(DaggerStreams.toImmutableList()))});
    }

    public static ClassName getAnnotationCreatorClassName(XTypeElement annotationType) {
        ClassName annotationTypeName = annotationType.getClassName();
        return annotationTypeName.topLevelClassName().peerClass(SourceFiles.classFileName(annotationTypeName) + "Creator");
    }

    public static String createMethodName(XTypeElement annotationType) {
        return "create" + XElements.getSimpleName((XMemberContainer)annotationType);
    }

    CodeBlock getValueExpression(XAnnotationValue value) {
        if (XTypeKt.isArray((XType)value.getValueType())) {
            XType componentType = XTypes.asArray(value.getValueType()).getComponentType();
            return CodeBlock.of((String)"new $T[] {$L}", (Object[])new Object[]{XTypes.isTypeOf(componentType, TypeNames.KCLASS) ? TypeNames.CLASS : componentType.getRawType().getTypeName(), value.asAnnotationValueList().stream().map(this::getValueExpression).collect(CodeBlocks.toParametersCodeBlock())});
        }
        if (value.hasEnumValue()) {
            return CodeBlock.of((String)"$T.$L", (Object[])new Object[]{value.asEnum().getEnclosingElement().getClassName(), XElements.getSimpleName((XElement)value.asEnum())});
        }
        if (value.hasAnnotationValue()) {
            return this.getAnnotationInstanceExpression(value.asAnnotation());
        }
        if (value.hasTypeValue()) {
            return CodeBlock.of((String)"$T.class", (Object[])new Object[]{value.asType().getTypeElement().getClassName()});
        }
        if (value.hasStringValue()) {
            return CodeBlock.of((String)"$S", (Object[])new Object[]{value.asString()});
        }
        if (value.hasByteValue()) {
            return CodeBlock.of((String)"(byte) $L", (Object[])new Object[]{value.asByte()});
        }
        if (value.hasCharValue()) {
            return CodeBlock.of((String)"$L", (Object[])new Object[]{XAnnotationValues.characterLiteralWithSingleQuotes(value.asChar())});
        }
        if (value.hasDoubleValue()) {
            return CodeBlock.of((String)"$LD", (Object[])new Object[]{value.asDouble()});
        }
        if (value.hasFloatValue()) {
            return CodeBlock.of((String)"$LF", (Object[])new Object[]{Float.valueOf(value.asFloat())});
        }
        if (value.hasLongValue()) {
            return CodeBlock.of((String)"$LL", (Object[])new Object[]{value.asLong()});
        }
        if (value.hasShortValue()) {
            return CodeBlock.of((String)"(short) $L", (Object[])new Object[]{value.asShort()});
        }
        return CodeBlock.of((String)"$L", (Object[])new Object[]{value.getValue()});
    }
}

