/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.javapoet.ExpressionType;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.model.RequestKind;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.MethodRequestRepresentation;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import javax.lang.model.element.Modifier;

final class PrivateMethodRequestRepresentation
extends MethodRequestRepresentation {
    private final ComponentImplementation.ShardImplementation shardImplementation;
    private final ContributionBinding binding;
    private final BindingRequest request;
    private final RequestRepresentation wrappedRequestRepresentation;
    private final CompilerOptions compilerOptions;
    private final XProcessingEnv processingEnv;
    private String methodName;

    @AssistedInject
    PrivateMethodRequestRepresentation(@Assisted BindingRequest request, @Assisted ContributionBinding binding, @Assisted RequestRepresentation wrappedRequestRepresentation, ComponentImplementation componentImplementation, XProcessingEnv processingEnv, CompilerOptions compilerOptions) {
        super(componentImplementation.shardImplementation(binding), processingEnv);
        this.binding = (ContributionBinding)Preconditions.checkNotNull((Object)binding);
        this.request = (BindingRequest)Preconditions.checkNotNull((Object)request);
        this.wrappedRequestRepresentation = (RequestRepresentation)Preconditions.checkNotNull((Object)wrappedRequestRepresentation);
        this.shardImplementation = componentImplementation.shardImplementation(binding);
        this.compilerOptions = compilerOptions;
        this.processingEnv = processingEnv;
    }

    @Override
    protected CodeBlock methodCall() {
        return CodeBlock.of((String)"$N()", (Object[])new Object[]{this.methodName()});
    }

    @Override
    protected ExpressionType returnType() {
        String requestingPackage;
        XType type = this.request.isRequestKind(RequestKind.INSTANCE) && this.binding.contributedPrimitiveType().isPresent() ? this.binding.contributedPrimitiveType().get() : this.request.requestedType(this.binding.contributedType(), this.processingEnv);
        if (Accessibility.isTypeAccessibleFrom(type, requestingPackage = this.shardImplementation.name().packageName())) {
            return ExpressionType.create(type);
        }
        if (XTypes.isDeclared(type) && Accessibility.isRawTypeAccessible(type, requestingPackage)) {
            return ExpressionType.createRawType(type);
        }
        return ExpressionType.create(this.processingEnv.requireType((TypeName)TypeName.OBJECT));
    }

    private String methodName() {
        if (this.methodName == null) {
            this.methodName = this.shardImplementation.getUniqueMethodName(this.request);
            this.shardImplementation.addMethod(ComponentImplementation.MethodSpecKind.PRIVATE_METHOD, MethodSpec.methodBuilder((String)this.methodName).addModifiers(new Modifier[]{Modifier.PRIVATE}).returns(this.returnType().getTypeName()).addStatement("return $L", new Object[]{this.wrappedRequestRepresentation.getDependencyExpression(this.shardImplementation.name()).codeBlock()}).build());
        }
        return this.methodName;
    }

    @AssistedFactory
    static interface Factory {
        public PrivateMethodRequestRepresentation create(BindingRequest var1, ContributionBinding var2, RequestRepresentation var3);
    }
}

