/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.DependencyVariableNamer;
import dagger.internal.codegen.binding.FrameworkField;
import dagger.internal.codegen.binding.FrameworkTypeMapper;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.RequestKind;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFieldElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import javax.inject.Inject;
import javax.lang.model.SourceVersion;

public final class SourceFiles {
    private static final Joiner CLASS_FILE_NAME_JOINER = Joiner.on((char)'_');

    @Inject
    SourceFiles() {
    }

    public static ImmutableMap<DependencyRequest, FrameworkField> generateBindingFieldsForDependencies(Binding binding) {
        Preconditions.checkArgument((!binding.unresolved().isPresent() ? 1 : 0) != 0, (String)"binding must be unresolved: %s", (Object)binding);
        FrameworkTypeMapper frameworkTypeMapper = FrameworkTypeMapper.forBindingType(binding.bindingType());
        return Maps.toMap(binding.dependencies(), dependency -> {
            ClassName frameworkClassName = frameworkTypeMapper.getFrameworkType(dependency.kind()).frameworkClassName();
            if (frameworkClassName.equals((Object)TypeNames.DAGGER_PROVIDER)) {
                frameworkClassName = TypeNames.PROVIDER;
            }
            return FrameworkField.create((TypeName)ParameterizedTypeName.get((ClassName)frameworkClassName, (TypeName[])new TypeName[]{dependency.key().type().xprocessing().getTypeName()}), DependencyVariableNamer.name(dependency));
        });
    }

    public CodeBlock frameworkTypeUsageStatement(CodeBlock frameworkTypeMemberSelect, RequestKind dependencyKind) {
        switch (dependencyKind) {
            case LAZY: {
                return CodeBlock.of((String)"$T.lazy($L)", (Object[])new Object[]{TypeNames.DOUBLE_CHECK, frameworkTypeMemberSelect});
            }
            case INSTANCE: 
            case FUTURE: {
                return CodeBlock.of((String)"$L.get()", (Object[])new Object[]{frameworkTypeMemberSelect});
            }
            case PROVIDER: 
            case PRODUCER: {
                return frameworkTypeMemberSelect;
            }
            case PROVIDER_OF_LAZY: {
                return CodeBlock.of((String)"$T.create($L)", (Object[])new Object[]{TypeNames.PROVIDER_OF_LAZY, frameworkTypeMemberSelect});
            }
        }
        throw new AssertionError((Object)dependencyKind);
    }

    public ImmutableMap<DependencyRequest, CodeBlock> frameworkFieldUsages(ImmutableSet<DependencyRequest> dependencies, ImmutableMap<DependencyRequest, FieldSpec> fields) {
        return Maps.toMap(dependencies, dep -> this.frameworkTypeUsageStatement(CodeBlock.of((String)"$N", (Object[])new Object[]{fields.get(dep)}), dep.kind()));
    }

    public static ClassName generatedClassNameForBinding(Binding binding) {
        switch (binding.bindingType()) {
            case PROVISION: 
            case PRODUCTION: {
                ContributionBinding contribution = (ContributionBinding)binding;
                switch (contribution.kind()) {
                    case ASSISTED_INJECTION: 
                    case INJECTION: 
                    case PROVISION: 
                    case PRODUCTION: {
                        return SourceFiles.factoryNameForElement(XElements.asExecutable(binding.bindingElement().get()));
                    }
                    case ASSISTED_FACTORY: {
                        return SourceFiles.siblingClassName(XElements.asTypeElement(binding.bindingElement().get()), "_Impl");
                    }
                }
                throw new AssertionError();
            }
            case MEMBERS_INJECTION: {
                return SourceFiles.membersInjectorNameForType(((MembersInjectionBinding)binding).membersInjectedType());
            }
        }
        throw new AssertionError();
    }

    public static ClassName factoryNameForElement(XExecutableElement element) {
        return SourceFiles.elementBasedClassName(element, "Factory");
    }

    public static ClassName elementBasedClassName(XExecutableElement element, String suffix) {
        ClassName enclosingClassName = element.getEnclosingElement().getClassName();
        String methodName = XElementKt.isConstructor((XElement)element) ? "" : CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, XElements.getSimpleName((XElement)element));
        return ClassName.get((String)enclosingClassName.packageName(), (String)(SourceFiles.classFileName(enclosingClassName) + "_" + methodName + suffix), (String[])new String[0]);
    }

    public static TypeName parameterizedGeneratedTypeNameForBinding(Binding binding) {
        ClassName className = SourceFiles.generatedClassNameForBinding(binding);
        ImmutableList<TypeVariableName> typeParameters = SourceFiles.bindingTypeElementTypeVariableNames(binding);
        return typeParameters.isEmpty() ? className : ParameterizedTypeName.get((ClassName)className, (TypeName[])((TypeName[])Iterables.toArray(typeParameters, TypeName.class)));
    }

    public static ClassName membersInjectorNameForType(XTypeElement typeElement) {
        return SourceFiles.siblingClassName(typeElement, "_MembersInjector");
    }

    public static String memberInjectedFieldSignatureForVariable(XFieldElement field) {
        return field.getEnclosingElement().getClassName().canonicalName() + "." + XElements.getSimpleName((XElement)field);
    }

    public static String classFileName(ClassName className) {
        return CLASS_FILE_NAME_JOINER.join((Iterable)className.simpleNames());
    }

    public static ClassName generatedMonitoringModuleName(XTypeElement componentElement) {
        return SourceFiles.siblingClassName(componentElement, "_MonitoringModule");
    }

    private static ClassName siblingClassName(XTypeElement typeElement, String suffix) {
        ClassName className = typeElement.getClassName();
        return className.topLevelClassName().peerClass(SourceFiles.classFileName(className) + suffix);
    }

    public static ClassName setFactoryClassName(ContributionBinding binding) {
        Preconditions.checkArgument((boolean)binding.kind().equals((Object)BindingKind.MULTIBOUND_SET));
        if (binding.bindingType().equals((Object)BindingType.PROVISION)) {
            return TypeNames.SET_FACTORY;
        }
        SetType setType = SetType.from(binding.key());
        return setType.elementsAreTypeOf(TypeNames.PRODUCED) ? TypeNames.SET_OF_PRODUCED_PRODUCER : TypeNames.SET_PRODUCER;
    }

    public static ClassName mapFactoryClassName(ContributionBinding binding) {
        Preconditions.checkState((boolean)binding.kind().equals((Object)BindingKind.MULTIBOUND_MAP), (Object)((Object)binding.kind()));
        MapType mapType = MapType.from(binding.key());
        switch (binding.bindingType()) {
            case PROVISION: {
                return mapType.valuesAreTypeOf(TypeNames.PROVIDER) ? TypeNames.MAP_PROVIDER_FACTORY : TypeNames.MAP_FACTORY;
            }
            case PRODUCTION: {
                return mapType.valuesAreFrameworkType() ? (mapType.valuesAreTypeOf(TypeNames.PRODUCER) ? TypeNames.MAP_OF_PRODUCER_PRODUCER : TypeNames.MAP_OF_PRODUCED_PRODUCER) : TypeNames.MAP_PRODUCER;
            }
        }
        throw new IllegalArgumentException(binding.bindingType().toString());
    }

    public static ImmutableList<TypeVariableName> bindingTypeElementTypeVariableNames(Binding binding) {
        ContributionBinding contributionBinding;
        if (binding instanceof ContributionBinding && (contributionBinding = (ContributionBinding)binding).kind() != BindingKind.INJECTION && contributionBinding.kind() != BindingKind.ASSISTED_INJECTION && !contributionBinding.requiresModuleInstance()) {
            return ImmutableList.of();
        }
        return XTypeElements.typeVariableNames(binding.bindingTypeElement().get());
    }

    public static String simpleVariableName(XTypeElement typeElement) {
        return SourceFiles.simpleVariableName(typeElement.getClassName());
    }

    public static String simpleVariableName(ClassName className) {
        String candidateName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, className.simpleName());
        String variableName = SourceFiles.protectAgainstKeywords(candidateName);
        Verify.verify((boolean)SourceVersion.isName(variableName), (String)"'%s' was expected to be a valid variable name", (Object)variableName);
        return variableName;
    }

    public static String protectAgainstKeywords(String candidateName) {
        switch (candidateName) {
            case "package": {
                return "pkg";
            }
            case "boolean": {
                return "b";
            }
            case "double": {
                return "d";
            }
            case "byte": {
                return "b";
            }
            case "int": {
                return "i";
            }
            case "short": {
                return "s";
            }
            case "char": {
                return "c";
            }
            case "void": {
                return "v";
            }
            case "class": {
                return "clazz";
            }
            case "float": {
                return "f";
            }
            case "long": {
                return "l";
            }
        }
        return SourceVersion.isKeyword(candidateName) ? candidateName + '_' : candidateName;
    }
}

