/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.bindinggraphvalidation;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graphs;
import com.google.common.graph.ImmutableNetwork;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.base.OptionalType;
import dagger.internal.codegen.base.RequestKinds;
import dagger.internal.codegen.binding.DependencyRequestFormatter;
import dagger.internal.codegen.bindinggraphvalidation.AutoValue_DependencyCycleValidator_Cycle;
import dagger.internal.codegen.extension.DaggerGraphs;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.model.Binding;
import dagger.internal.codegen.model.BindingGraph;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.DiagnosticReporter;
import dagger.internal.codegen.model.RequestKind;
import dagger.internal.codegen.validation.ValidationBindingGraphPlugin;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.tools.Diagnostic;

final class DependencyCycleValidator
extends ValidationBindingGraphPlugin {
    private final DependencyRequestFormatter dependencyRequestFormatter;

    @Inject
    DependencyCycleValidator(DependencyRequestFormatter dependencyRequestFormatter) {
        this.dependencyRequestFormatter = dependencyRequestFormatter;
    }

    @Override
    public String pluginName() {
        return "Dagger/DependencyCycle";
    }

    @Override
    public void visitGraph(BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        ImmutableNetwork<BindingGraph.Node, BindingGraph.DependencyEdge> dependencyGraph = this.nonCycleBreakingDependencyGraph(bindingGraph);
        if (!Graphs.hasCycle(dependencyGraph)) {
            return;
        }
        Set dependencyEndpointPairs = dependencyGraph.asGraph().edges();
        HashSet visited = Sets.newHashSetWithExpectedSize((int)dependencyEndpointPairs.size());
        for (EndpointPair endpointPair : dependencyEndpointPairs) {
            this.cycleContainingEndpointPair((EndpointPair<BindingGraph.Node>)endpointPair, dependencyGraph, visited).ifPresent(cycle -> this.reportCycle((Cycle<BindingGraph.Node>)cycle, bindingGraph, diagnosticReporter));
        }
    }

    private Optional<Cycle<BindingGraph.Node>> cycleContainingEndpointPair(EndpointPair<BindingGraph.Node> endpoints, ImmutableNetwork<BindingGraph.Node, BindingGraph.DependencyEdge> dependencyGraph, Set<EndpointPair<BindingGraph.Node>> visited) {
        if (!visited.add(endpoints)) {
            return Optional.empty();
        }
        ImmutableList cycleNodes = DaggerGraphs.shortestPath(dependencyGraph, (Object)((BindingGraph.Node)endpoints.target()), (Object)((BindingGraph.Node)endpoints.source()));
        if (cycleNodes.isEmpty()) {
            return Optional.empty();
        }
        Cycle cycle = Cycle.fromPath(cycleNodes);
        visited.addAll((Collection<EndpointPair<BindingGraph.Node>>)cycle.endpointPairs());
        return Optional.of(cycle);
    }

    private void reportCycle(Cycle<BindingGraph.Node> cycle, BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        if (bindingGraph.isFullBindingGraph()) {
            diagnosticReporter.reportComponent(Diagnostic.Kind.ERROR, bindingGraph.componentNode(((BindingGraph.Node)cycle.nodes().asList().get(0)).componentPath()).get(), this.errorMessage(cycle, bindingGraph));
            return;
        }
        ImmutableList<BindingGraph.Node> path = this.shortestPathToCycleFromAnEntryPoint(cycle, bindingGraph);
        BindingGraph.Node cycleStartNode = (BindingGraph.Node)path.get(path.size() - 1);
        BindingGraph.Node previousNode = (BindingGraph.Node)path.get(path.size() - 2);
        BindingGraph.DependencyEdge dependencyToReport = this.chooseDependencyEdgeConnecting(previousNode, cycleStartNode, bindingGraph);
        diagnosticReporter.reportDependency(Diagnostic.Kind.ERROR, dependencyToReport, this.errorMessage(cycle.shift(cycleStartNode), bindingGraph) + "\n\nThe cycle is requested via:");
    }

    private ImmutableList<BindingGraph.Node> shortestPathToCycleFromAnEntryPoint(Cycle<BindingGraph.Node> cycle, BindingGraph bindingGraph) {
        BindingGraph.Node someCycleNode = (BindingGraph.Node)cycle.nodes().asList().get(0);
        BindingGraph.ComponentNode componentContainingCycle = bindingGraph.componentNode(someCycleNode.componentPath()).get();
        ImmutableList pathToCycle = DaggerGraphs.shortestPath(bindingGraph.network(), (Object)componentContainingCycle, (Object)someCycleNode);
        return this.subpathToCycle((ImmutableList<BindingGraph.Node>)pathToCycle, cycle);
    }

    private ImmutableList<BindingGraph.Node> subpathToCycle(ImmutableList<BindingGraph.Node> path, Cycle<BindingGraph.Node> cycle) {
        ImmutableList.Builder subpath = ImmutableList.builder();
        for (BindingGraph.Node node : path) {
            subpath.add((Object)node);
            if (!cycle.nodes().contains((Object)node)) continue;
            return subpath.build();
        }
        throw new IllegalArgumentException("path " + path + " doesn't contain any nodes in cycle " + cycle);
    }

    private String errorMessage(Cycle<BindingGraph.Node> cycle, BindingGraph graph) {
        StringBuilder message = new StringBuilder("Found a dependency cycle:");
        ImmutableList cycleRequests = ((ImmutableList)cycle.endpointPairs().stream().map(endpointPair -> this.nonCycleBreakingEdge((EndpointPair<BindingGraph.Node>)endpointPair, graph)).map(BindingGraph.DependencyEdge::dependencyRequest).collect(DaggerStreams.toImmutableList())).reverse();
        this.dependencyRequestFormatter.formatIndentedList(message, cycleRequests, 0);
        message.append("\n").append(this.dependencyRequestFormatter.format((DependencyRequest)cycleRequests.get(0))).append("\n").append("    ").append("...");
        return message.toString();
    }

    private BindingGraph.DependencyEdge nonCycleBreakingEdge(EndpointPair<BindingGraph.Node> endpointPair, BindingGraph graph) {
        return graph.network().edgesConnecting((Object)((BindingGraph.Node)endpointPair.source()), (Object)((BindingGraph.Node)endpointPair.target())).stream().flatMap(DaggerStreams.instancesOf(BindingGraph.DependencyEdge.class)).filter(edge -> !this.breaksCycle((BindingGraph.DependencyEdge)edge, graph)).findFirst().get();
    }

    private boolean breaksCycle(BindingGraph.DependencyEdge edge, BindingGraph graph) {
        if (edge.dependencyRequest().key().multibindingContributionIdentifier().isPresent()) {
            return false;
        }
        if (this.breaksCycle(edge.dependencyRequest().key().type().xprocessing(), edge.dependencyRequest().kind())) {
            return true;
        }
        BindingGraph.Node target = (BindingGraph.Node)graph.network().incidentNodes((Object)edge).target();
        if (target instanceof Binding && ((Binding)target).kind().equals((Object)BindingKind.OPTIONAL)) {
            XType optionalValueType = OptionalType.from(edge.dependencyRequest().key()).valueType();
            RequestKind requestKind = RequestKinds.getRequestKind(optionalValueType);
            return this.breaksCycle(RequestKinds.extractKeyType(optionalValueType), requestKind);
        }
        return false;
    }

    private boolean breaksCycle(XType requestedType, RequestKind requestKind) {
        switch (requestKind) {
            case PROVIDER: 
            case LAZY: 
            case PROVIDER_OF_LAZY: {
                return true;
            }
            case INSTANCE: {
                if (!MapType.isMap(requestedType)) break;
                return MapType.from(requestedType).valuesAreTypeOf(TypeNames.PROVIDER);
            }
        }
        return false;
    }

    private BindingGraph.DependencyEdge chooseDependencyEdgeConnecting(BindingGraph.Node source, BindingGraph.Node target, BindingGraph bindingGraph) {
        return (BindingGraph.DependencyEdge)bindingGraph.network().edgesConnecting((Object)source, (Object)target).stream().flatMap(DaggerStreams.instancesOf(BindingGraph.DependencyEdge.class)).findFirst().get();
    }

    private ImmutableNetwork<BindingGraph.Node, BindingGraph.DependencyEdge> nonCycleBreakingDependencyGraph(BindingGraph bindingGraph) {
        MutableNetwork dependencyNetwork = NetworkBuilder.from(bindingGraph.network()).expectedNodeCount(bindingGraph.network().nodes().size()).expectedEdgeCount(bindingGraph.dependencyEdges().size()).build();
        bindingGraph.dependencyEdges().stream().filter(edge -> !this.breaksCycle((BindingGraph.DependencyEdge)edge, bindingGraph)).forEach(edge -> {
            EndpointPair endpoints = bindingGraph.network().incidentNodes(edge);
            dependencyNetwork.addEdge((Object)((BindingGraph.Node)endpoints.source()), (Object)((BindingGraph.Node)endpoints.target()), edge);
        });
        return ImmutableNetwork.copyOf((Network)dependencyNetwork);
    }

    @AutoValue
    static abstract class Cycle<N> {
        Cycle() {
        }

        abstract ImmutableSet<EndpointPair<N>> endpointPairs();

        ImmutableSet<N> nodes() {
            return (ImmutableSet)this.endpointPairs().stream().flatMap(pair -> Stream.of(pair.source(), pair.target())).collect(DaggerStreams.toImmutableSet());
        }

        int size() {
            return this.endpointPairs().size();
        }

        Cycle<N> shift(N startNode) {
            int startIndex = Iterables.indexOf(this.endpointPairs(), pair -> pair.source().equals(startNode));
            Preconditions.checkArgument((startIndex >= 0 ? 1 : 0) != 0, (String)"startNode (%s) is not part of this cycle: %s", startNode, (Object)this);
            if (startIndex == 0) {
                return this;
            }
            ImmutableSet.Builder shifted = ImmutableSet.builder();
            shifted.addAll(Iterables.skip(this.endpointPairs(), (int)startIndex));
            shifted.addAll(Iterables.limit(this.endpointPairs(), (int)(this.size() - startIndex)));
            return new AutoValue_DependencyCycleValidator_Cycle(shifted.build());
        }

        public final String toString() {
            return this.endpointPairs().toString();
        }

        static <N> Cycle<N> fromPath(List<N> nodes) {
            Preconditions.checkArgument((!nodes.isEmpty() ? 1 : 0) != 0);
            ImmutableSet.Builder cycle = ImmutableSet.builder();
            cycle.add((Object)EndpointPair.ordered((Object)Iterables.getLast(nodes), nodes.get(0)));
            for (int i = 0; i < nodes.size() - 1; ++i) {
                cycle.add((Object)EndpointPair.ordered(nodes.get(i), nodes.get(i + 1)));
            }
            return new AutoValue_DependencyCycleValidator_Cycle(cycle.build());
        }
    }
}

