/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.bindinggraphvalidation;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.WildcardTypeName;
import dagger.internal.codegen.base.ElementFormatter;
import dagger.internal.codegen.base.Keys;
import dagger.internal.codegen.base.RequestKinds;
import dagger.internal.codegen.binding.ComponentNodeImpl;
import dagger.internal.codegen.binding.DependencyRequestFormatter;
import dagger.internal.codegen.binding.InjectBindingRegistry;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.model.Binding;
import dagger.internal.codegen.model.BindingGraph;
import dagger.internal.codegen.model.DaggerAnnotation;
import dagger.internal.codegen.model.DiagnosticReporter;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.validation.DiagnosticMessageGenerator;
import dagger.internal.codegen.validation.ValidationBindingGraphPlugin;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.tools.Diagnostic;

final class MissingBindingValidator
extends ValidationBindingGraphPlugin {
    private final InjectBindingRegistry injectBindingRegistry;
    private final DependencyRequestFormatter dependencyRequestFormatter;
    private final DiagnosticMessageGenerator.Factory diagnosticMessageGeneratorFactory;

    @Inject
    MissingBindingValidator(InjectBindingRegistry injectBindingRegistry, DependencyRequestFormatter dependencyRequestFormatter, DiagnosticMessageGenerator.Factory diagnosticMessageGeneratorFactory) {
        this.injectBindingRegistry = injectBindingRegistry;
        this.dependencyRequestFormatter = dependencyRequestFormatter;
        this.diagnosticMessageGeneratorFactory = diagnosticMessageGeneratorFactory;
    }

    @Override
    public String pluginName() {
        return "Dagger/MissingBinding";
    }

    @Override
    public void visitGraph(BindingGraph graph, DiagnosticReporter diagnosticReporter) {
        if (graph.isFullBindingGraph() || graph.rootComponentNode().isSubcomponent()) {
            return;
        }
        if (!graph.missingBindings().isEmpty()) {
            this.requestVisitFullGraph(graph);
        }
    }

    @Override
    public void revisitFullGraph(BindingGraph prunedGraph, BindingGraph fullGraph, DiagnosticReporter diagnosticReporter) {
        prunedGraph.missingBindings().forEach(missingBinding -> this.reportMissingBinding((BindingGraph.MissingBinding)missingBinding, fullGraph, diagnosticReporter));
    }

    private void reportMissingBinding(BindingGraph.MissingBinding missingBinding, BindingGraph graph, DiagnosticReporter diagnosticReporter) {
        diagnosticReporter.reportComponent(Diagnostic.Kind.ERROR, graph.componentNode(missingBinding.componentPath()).get(), this.missingBindingErrorMessage(missingBinding, graph) + this.missingBindingDependencyTraceMessage(missingBinding, graph) + this.alternativeBindingsMessage(missingBinding, graph) + this.similarBindingsMessage(missingBinding, graph));
    }

    private static ImmutableSet<Binding> getSimilarTypeBindings(BindingGraph graph, Key missingBindingKey) {
        XType missingBindingType = missingBindingKey.type().xprocessing();
        Optional<DaggerAnnotation> missingBindingQualifier = missingBindingKey.qualifier();
        ImmutableList<TypeName> flatMissingBindingType = MissingBindingValidator.flattenBindingType(missingBindingType);
        if (flatMissingBindingType.size() <= 1) {
            return ImmutableSet.of();
        }
        return (ImmutableSet)graph.bindings().stream().filter(binding -> binding.key().qualifier().equals(missingBindingQualifier) && MissingBindingValidator.isSimilarType(binding.key().type().xprocessing(), (List<TypeName>)flatMissingBindingType)).collect(DaggerStreams.toImmutableSet());
    }

    private static ImmutableList<TypeName> flattenBindingType(XType type) {
        return ImmutableList.copyOf((Iterator)new TypeDfsIterator(type));
    }

    private static boolean isSimilarType(XType type, List<TypeName> flatTypeNames) {
        return Iterators.elementsEqual(flatTypeNames.iterator(), (Iterator)new TypeDfsIterator(type));
    }

    private static TypeName getBound(WildcardTypeName wildcardType) {
        return !wildcardType.lowerBounds.isEmpty() ? (TypeName)Iterables.getOnlyElement((Iterable)wildcardType.lowerBounds) : (TypeName)Iterables.getOnlyElement((Iterable)wildcardType.upperBounds);
    }

    private String missingBindingErrorMessage(BindingGraph.MissingBinding missingBinding, BindingGraph graph) {
        Key key = missingBinding.key();
        StringBuilder errorMessage = new StringBuilder();
        Verify.verify((!XTypes.isWildcard(key.type().xprocessing()) ? 1 : 0) != 0, (String)"unexpected wildcard request: %s", (Object)key);
        errorMessage.append(key).append(" cannot be provided without ");
        if (Keys.isValidImplicitProvisionKey(key)) {
            errorMessage.append("an @Inject constructor or ");
        }
        errorMessage.append("an @Provides-");
        if (this.allIncomingDependenciesCanUseProduction(missingBinding, graph)) {
            errorMessage.append(" or @Produces-");
        }
        errorMessage.append("annotated method.");
        if (Keys.isValidMembersInjectionKey(key) && this.typeHasInjectionSites(key)) {
            errorMessage.append(" This type supports members injection but cannot be implicitly provided.");
        }
        return errorMessage.toString();
    }

    private String missingBindingDependencyTraceMessage(BindingGraph.MissingBinding missingBinding, BindingGraph graph) {
        ImmutableSet<BindingGraph.DependencyEdge> entryPoints = graph.entryPointEdgesDependingOnBinding(missingBinding);
        DiagnosticMessageGenerator generator = this.diagnosticMessageGeneratorFactory.create(graph);
        ImmutableList<BindingGraph.DependencyEdge> dependencyTrace = generator.dependencyTrace(missingBinding, entryPoints);
        StringBuilder message = new StringBuilder(dependencyTrace.size() * 100).append("\n");
        for (BindingGraph.DependencyEdge edge : dependencyTrace) {
            String line = this.dependencyRequestFormatter.format(edge.dependencyRequest());
            if (line.isEmpty()) continue;
            String componentName = String.format("[%s] ", MissingBindingValidator.getComponentFromDependencyEdge(edge, graph));
            message.append("\n").append(line.replace("        ", "        " + componentName));
        }
        if (!dependencyTrace.isEmpty()) {
            generator.appendComponentPathUnlessAtRoot(message, MissingBindingValidator.source((BindingGraph.Edge)Iterables.getLast(dependencyTrace), graph));
        }
        message.append(generator.getRequestsNotInTrace(dependencyTrace, generator.requests(missingBinding), entryPoints));
        return message.toString();
    }

    private String alternativeBindingsMessage(BindingGraph.MissingBinding missingBinding, BindingGraph graph) {
        ImmutableSet<Binding> alternativeBindings = graph.bindings(missingBinding.key());
        if (alternativeBindings.isEmpty()) {
            return "";
        }
        StringBuilder message = new StringBuilder();
        message.append("\n\nNote: ").append(missingBinding.key()).append(" is provided in the following other components:");
        for (Binding alternativeBinding : alternativeBindings) {
            if (alternativeBinding.contributingModule().isPresent() && !((ComponentNodeImpl)graph.componentNode(alternativeBinding.componentPath()).get()).componentDescriptor().moduleTypes().contains((Object)alternativeBinding.contributingModule().get().xprocessing())) continue;
            message.append("\n").append("    ").append(this.asString(alternativeBinding));
        }
        return message.toString();
    }

    private String similarBindingsMessage(BindingGraph.MissingBinding missingBinding, BindingGraph graph) {
        ImmutableSet<Binding> similarBindings = MissingBindingValidator.getSimilarTypeBindings(graph, missingBinding.key());
        if (similarBindings.isEmpty()) {
            return "";
        }
        StringBuilder message = new StringBuilder("\n\nNote: A similar binding is provided in the following other components:");
        for (Binding similarBinding : similarBindings) {
            message.append("\n").append("    ").append(similarBinding.key()).append(" is provided at:").append("\n").append("        ").append(this.asString(similarBinding));
        }
        message.append("\n").append("(For Kotlin sources, you may need to use '@JvmSuppressWildcards' or '@JvmWildcard' if you need to explicitly control the wildcards at a particular usage site.)");
        return message.toString();
    }

    private String asString(Binding binding) {
        return String.format("[%s] %s", binding.componentPath().currentComponent().xprocessing().getQualifiedName(), binding.bindingElement().isPresent() ? ElementFormatter.elementToString(binding.bindingElement().get().xprocessing(), true) : binding);
    }

    private boolean allIncomingDependenciesCanUseProduction(BindingGraph.MissingBinding missingBinding, BindingGraph graph) {
        return graph.network().inEdges((Object)missingBinding).stream().flatMap(DaggerStreams.instancesOf(BindingGraph.DependencyEdge.class)).allMatch(edge -> this.dependencyCanBeProduction((BindingGraph.DependencyEdge)edge, graph));
    }

    private boolean dependencyCanBeProduction(BindingGraph.DependencyEdge edge, BindingGraph graph) {
        BindingGraph.Node source = (BindingGraph.Node)graph.network().incidentNodes((Object)edge).source();
        if (source instanceof BindingGraph.ComponentNode) {
            return RequestKinds.canBeSatisfiedByProductionBinding(edge.dependencyRequest().kind());
        }
        if (source instanceof Binding) {
            return ((Binding)source).isProduction();
        }
        throw new IllegalArgumentException("expected a dagger.internal.codegen.model.Binding or ComponentNode: " + source);
    }

    private boolean typeHasInjectionSites(Key key) {
        return this.injectBindingRegistry.getOrFindMembersInjectionBinding(key).map(binding -> !binding.injectionSites().isEmpty()).orElse(false);
    }

    private static String getComponentFromDependencyEdge(BindingGraph.DependencyEdge edge, BindingGraph graph) {
        return MissingBindingValidator.source(edge, graph).componentPath().currentComponent().className().canonicalName();
    }

    private static BindingGraph.Node source(BindingGraph.Edge edge, BindingGraph graph) {
        return (BindingGraph.Node)graph.network().incidentNodes((Object)edge).source();
    }

    private static class TypeDfsIterator
    implements Iterator<TypeName> {
        final Deque<XType> stack = new ArrayDeque<XType>();

        TypeDfsIterator(XType root) {
            this.stack.push(root);
        }

        @Override
        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        @Override
        public TypeName next() {
            XType next;
            block4: {
                next = this.stack.pop();
                if (!XTypes.isDeclared(next)) break block4;
                if (XTypes.isRawParameterizedType(next)) {
                    XType obj = XConverters.getProcessingEnv((XType)next).requireType((TypeName)TypeName.OBJECT);
                    for (int i = 0; i < next.getTypeElement().getType().getTypeArguments().size(); ++i) {
                        this.stack.push(obj);
                    }
                } else {
                    for (XType arg : Lists.reverse((List)next.getTypeArguments())) {
                        this.stack.push(arg);
                    }
                }
            }
            return TypeDfsIterator.getBaseTypeName(next);
        }

        private static TypeName getBaseTypeName(XType type) {
            if (XTypes.isDeclared(type)) {
                return type.getRawType().getTypeName();
            }
            TypeName typeName = type.getTypeName();
            if (typeName instanceof WildcardTypeName) {
                return MissingBindingValidator.getBound((WildcardTypeName)typeName);
            }
            return typeName;
        }
    }
}

