/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.internal.managers;

import android.content.Context;
import android.content.ContextWrapper;
import android.view.LayoutInflater;
import android.view.View;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import dagger.hilt.EntryPoint;
import dagger.hilt.EntryPoints;
import dagger.hilt.InstallIn;
import dagger.hilt.android.components.ActivityComponent;
import dagger.hilt.android.components.FragmentComponent;
import dagger.hilt.android.internal.Contexts;
import dagger.hilt.android.internal.builders.ViewComponentBuilder;
import dagger.hilt.android.internal.builders.ViewWithFragmentComponentBuilder;
import dagger.hilt.internal.GeneratedComponentManager;
import dagger.hilt.internal.Preconditions;

public final class ViewComponentManager
implements GeneratedComponentManager<Object> {
    private volatile Object component;
    private final Object componentLock = new Object();
    private final boolean hasFragmentBindings;
    private final View view;

    public ViewComponentManager(View view, boolean hasFragmentBindings) {
        this.view = view;
        this.hasFragmentBindings = hasFragmentBindings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object generatedComponent() {
        if (this.component == null) {
            Object object = this.componentLock;
            synchronized (object) {
                if (this.component == null) {
                    this.component = this.createComponent();
                }
            }
        }
        return this.component;
    }

    private Object createComponent() {
        GeneratedComponentManager<?> componentManager = this.getParentComponentManager(false);
        if (this.hasFragmentBindings) {
            return ((ViewWithFragmentComponentBuilderEntryPoint)EntryPoints.get(componentManager, ViewWithFragmentComponentBuilderEntryPoint.class)).viewWithFragmentComponentBuilder().view(this.view).build();
        }
        return ((ViewComponentBuilderEntryPoint)EntryPoints.get(componentManager, ViewComponentBuilderEntryPoint.class)).viewComponentBuilder().view(this.view).build();
    }

    public GeneratedComponentManager<?> maybeGetParentComponentManager() {
        return this.getParentComponentManager(true);
    }

    private GeneratedComponentManager<?> getParentComponentManager(boolean allowMissing) {
        if (this.hasFragmentBindings) {
            Context context = this.getParentContext(FragmentContextWrapper.class, allowMissing);
            if (context instanceof FragmentContextWrapper) {
                FragmentContextWrapper fragmentContextWrapper = (FragmentContextWrapper)context;
                return (GeneratedComponentManager)fragmentContextWrapper.getFragment();
            }
            if (allowMissing) {
                return null;
            }
            Context parent = this.getParentContext(GeneratedComponentManager.class, allowMissing);
            Preconditions.checkState((!(parent instanceof GeneratedComponentManager) ? 1 : 0) != 0, (String)"%s, @WithFragmentBindings Hilt view must be attached to an @AndroidEntryPoint Fragment. Was attached to context %s", (Object[])new Object[]{this.view.getClass(), parent.getClass().getName()});
        } else {
            Context context = this.getParentContext(GeneratedComponentManager.class, allowMissing);
            if (context instanceof GeneratedComponentManager) {
                return (GeneratedComponentManager)context;
            }
            if (allowMissing) {
                return null;
            }
        }
        throw new IllegalStateException(String.format("%s, Hilt view must be attached to an @AndroidEntryPoint Fragment or Activity.", this.view.getClass()));
    }

    private Context getParentContext(Class<?> parentType, boolean allowMissing) {
        Context context = ViewComponentManager.unwrap(this.view.getContext(), parentType);
        if (context == Contexts.getApplication(context.getApplicationContext())) {
            Preconditions.checkState((boolean)allowMissing, (String)"%s, Hilt view cannot be created using the application context. Use a Hilt Fragment or Activity context.", (Object[])new Object[]{this.view.getClass()});
            return null;
        }
        return context;
    }

    private static Context unwrap(Context context, Class<?> target) {
        while (context instanceof ContextWrapper && !target.isInstance(context)) {
            context = ((ContextWrapper)context).getBaseContext();
        }
        return context;
    }

    public static final class FragmentContextWrapper
    extends ContextWrapper {
        private Fragment fragment;
        private LayoutInflater baseInflater;
        private LayoutInflater inflater;
        private final LifecycleEventObserver fragmentLifecycleObserver = new LifecycleEventObserver(this){
            final /* synthetic */ FragmentContextWrapper this$0;
            {
                this.this$0 = this$0;
            }

            public void onStateChanged(LifecycleOwner source, Lifecycle.Event event) {
                if (event == Lifecycle.Event.ON_DESTROY) {
                    this.this$0.fragment = null;
                    this.this$0.baseInflater = null;
                    this.this$0.inflater = null;
                }
            }
        };

        FragmentContextWrapper(Context base, Fragment fragment) {
            super((Context)Preconditions.checkNotNull((Object)base));
            this.baseInflater = null;
            this.fragment = (Fragment)Preconditions.checkNotNull((Object)fragment);
            this.fragment.getLifecycle().addObserver((LifecycleObserver)this.fragmentLifecycleObserver);
        }

        FragmentContextWrapper(LayoutInflater baseInflater, Fragment fragment) {
            super((Context)Preconditions.checkNotNull((Object)((LayoutInflater)Preconditions.checkNotNull((Object)baseInflater)).getContext()));
            this.baseInflater = baseInflater;
            this.fragment = (Fragment)Preconditions.checkNotNull((Object)fragment);
            this.fragment.getLifecycle().addObserver((LifecycleObserver)this.fragmentLifecycleObserver);
        }

        Fragment getFragment() {
            Preconditions.checkNotNull((Object)this.fragment, (String)"The fragment has already been destroyed.");
            return this.fragment;
        }

        public Object getSystemService(String name) {
            if (!"layout_inflater".equals(name)) {
                return this.getBaseContext().getSystemService(name);
            }
            if (this.inflater == null) {
                if (this.baseInflater == null) {
                    this.baseInflater = (LayoutInflater)this.getBaseContext().getSystemService("layout_inflater");
                }
                this.inflater = this.baseInflater.cloneInContext((Context)this);
            }
            return this.inflater;
        }
    }

    @EntryPoint
    @InstallIn(value={ActivityComponent.class})
    public static interface ViewComponentBuilderEntryPoint {
        public ViewComponentBuilder viewComponentBuilder();
    }

    @EntryPoint
    @InstallIn(value={FragmentComponent.class})
    public static interface ViewWithFragmentComponentBuilderEntryPoint {
        public ViewWithFragmentComponentBuilder viewWithFragmentComponentBuilder();
    }
}

