/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.internal.lifecycle;

import android.app.Activity;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.AbstractSavedStateViewModelFactory;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.viewmodel.CreationExtras;
import androidx.savedstate.SavedStateRegistryOwner;
import dagger.Module;
import dagger.hilt.EntryPoint;
import dagger.hilt.EntryPoints;
import dagger.hilt.InstallIn;
import dagger.hilt.android.components.ActivityComponent;
import dagger.hilt.android.components.ViewModelComponent;
import dagger.hilt.android.internal.builders.ViewModelComponentBuilder;
import dagger.hilt.android.internal.lifecycle.HiltViewModelMap;
import dagger.hilt.android.internal.lifecycle.RetainedLifecycleImpl;
import dagger.multibindings.Multibinds;
import java.util.Map;
import java.util.Set;
import javax.inject.Provider;

public final class HiltViewModelFactory
implements ViewModelProvider.Factory {
    private final Set<String> hiltViewModelKeys;
    private final ViewModelProvider.Factory delegateFactory;
    private final AbstractSavedStateViewModelFactory hiltViewModelFactory;

    public HiltViewModelFactory(@NonNull Set<String> hiltViewModelKeys, @NonNull ViewModelProvider.Factory delegateFactory, final @NonNull ViewModelComponentBuilder viewModelComponentBuilder) {
        this.hiltViewModelKeys = hiltViewModelKeys;
        this.delegateFactory = delegateFactory;
        this.hiltViewModelFactory = new AbstractSavedStateViewModelFactory(){

            @NonNull
            protected <T extends ViewModel> T create(@NonNull String key, @NonNull Class<T> modelClass, @NonNull SavedStateHandle handle) {
                RetainedLifecycleImpl lifecycle = new RetainedLifecycleImpl();
                ViewModelComponent component = viewModelComponentBuilder.savedStateHandle(handle).viewModelLifecycle(lifecycle).build();
                Provider<ViewModel> provider = ((ViewModelFactoriesEntryPoint)EntryPoints.get((Object)component, ViewModelFactoriesEntryPoint.class)).getHiltViewModelMap().get(modelClass.getName());
                if (provider == null) {
                    throw new IllegalStateException("Expected the @HiltViewModel-annotated class '" + modelClass.getName() + "' to be available in the multi-binding of @HiltViewModelMap but none was found.");
                }
                ViewModel viewModel = (ViewModel)provider.get();
                viewModel.addCloseable(lifecycle::dispatchOnCleared);
                return (T)viewModel;
            }
        };
    }

    @NonNull
    public <T extends ViewModel> T create(@NonNull Class<T> modelClass, @NonNull CreationExtras extras) {
        if (this.hiltViewModelKeys.contains(modelClass.getName())) {
            return (T)this.hiltViewModelFactory.create(modelClass, extras);
        }
        return (T)this.delegateFactory.create(modelClass, extras);
    }

    @NonNull
    public <T extends ViewModel> T create(@NonNull Class<T> modelClass) {
        if (this.hiltViewModelKeys.contains(modelClass.getName())) {
            return (T)this.hiltViewModelFactory.create(modelClass);
        }
        return (T)this.delegateFactory.create(modelClass);
    }

    public static ViewModelProvider.Factory createInternal(@NonNull Activity activity, @NonNull SavedStateRegistryOwner owner, @Nullable Bundle defaultArgs, @NonNull ViewModelProvider.Factory delegateFactory) {
        return HiltViewModelFactory.createInternal(activity, delegateFactory);
    }

    public static ViewModelProvider.Factory createInternal(@NonNull Activity activity, @NonNull ViewModelProvider.Factory delegateFactory) {
        ActivityCreatorEntryPoint entryPoint = (ActivityCreatorEntryPoint)EntryPoints.get((Object)activity, ActivityCreatorEntryPoint.class);
        return new HiltViewModelFactory(entryPoint.getViewModelKeys(), delegateFactory, entryPoint.getViewModelComponentBuilder());
    }

    @EntryPoint
    @InstallIn(value={ActivityComponent.class})
    static interface ActivityCreatorEntryPoint {
        @HiltViewModelMap.KeySet
        public Set<String> getViewModelKeys();

        public ViewModelComponentBuilder getViewModelComponentBuilder();
    }

    @Module
    @InstallIn(value={ViewModelComponent.class})
    static interface ViewModelModule {
        @Multibinds
        @HiltViewModelMap
        public Map<String, ViewModel> hiltViewModelMap();
    }

    @EntryPoint
    @InstallIn(value={ViewModelComponent.class})
    public static interface ViewModelFactoriesEntryPoint {
        @HiltViewModelMap
        public Map<String, Provider<ViewModel>> getHiltViewModelMap();
    }
}

