/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "mua" locale.
 */
public class LocalizedNamesImpl_mua extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AF",
        "ZA",
        "AL",
        "DZ",
        "US",
        "AD",
        "IO",
        "AO",
        "AI",
        "AG",
        "AQ",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AX",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BY",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BL",
        "BO",
        "BA",
        "BW",
        "BQ",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "BT",
        "BV",
        "CC",
        "CF",
        "CP",
        "CW",
        "CX",
        "DK",
        "DG",
        "DJ",
        "DM",
        "EA",
        "EH",
        "EC",
        "ES",
        "EE",
        "ET",
        "EU",
        "PH",
        "FO",
        "FR",
        "GA",
        "GM",
        "GH",
        "GE",
        "DE",
        "GG",
        "GD",
        "GS",
        "GN",
        "GW",
        "GY",
        "GU",
        "GT",
        "HK",
        "HM",
        "HU",
        "IC",
        "IM",
        "ID",
        "IQ",
        "IR",
        "IT",
        "JM",
        "JP",
        "JE",
        "JO",
        "NC",
        "KH",
        "CM",
        "CA",
        "CV",
        "QA",
        "KY",
        "KZ",
        "KG",
        "CO",
        "KM",
        "CG",
        "CK",
        "CR",
        "HR",
        "CU",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "MK",
        "MG",
        "MY",
        "MV",
        "MA",
        "MQ",
        "MR",
        "YT",
        "ME",
        "MX",
        "MF",
        "FM",
        "MO",
        "MD",
        "MC",
        "MN",
        "MZ",
        "NA",
        "NG",
        "NI",
        "NU",
        "NF",
        "NO",
        "OM",
        "PK",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PR",
        "QO",
        "RO",
        "RS",
        "RU",
        "RW",
        "SC",
        "AS",
        "ST",
        "SN",
        "VG",
        "CI",
        "SL",
        "SG",
        "SJ",
        "SK",
        "SI",
        "SO",
        "SS",
        "SD",
        "SX",
        "TD",
        "CL",
        "CY",
        "CN",
        "SY",
        "VI",
        "GB",
        "SA",
        "AE",
        "DO",
        "EG",
        "ER",
        "FJ",
        "FI",
        "GI",
        "GR",
        "GL",
        "GQ",
        "GF",
        "GP",
        "HT",
        "SH",
        "HN",
        "IN",
        "IE",
        "IS",
        "IL",
        "KE",
        "KI",
        "CD",
        "KP",
        "KR",
        "KW",
        "KN",
        "LK",
        "LA",
        "LS",
        "LC",
        "LU",
        "NL",
        "AN",
        "MW",
        "ML",
        "FK",
        "MT",
        "MP",
        "SM",
        "MH",
        "MU",
        "MS",
        "MM",
        "NR",
        "NP",
        "NE",
        "PW",
        "PS",
        "PA",
        "PF",
        "PT",
        "PM",
        "RE",
        "SB",
        "SV",
        "WS",
        "SE",
        "SR",
        "SZ",
        "CH",
        "CZ",
        "TG",
        "TK",
        "TO",
        "TV",
        "VU",
        "VE",
        "VN",
        "VC",
        "TA",
        "TH",
        "TW",
        "TJ",
        "TZ",
        "TF",
        "TL",
        "TT",
        "TN",
        "TR",
        "TC",
        "TM",
        "UG",
        "UA",
        "UM",
        "UY",
        "UZ",
        "VA",
        "WF",
        "XK",
        "YE",
        "ZM",
        "NZ",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AD", "andorra");
    namesMap.put("AE", "Sǝr Arabiya ma taini");
    namesMap.put("AF", "afghanistaŋ");
    namesMap.put("AG", "antiguan ne Barbuda");
    namesMap.put("AI", "anguiya");
    namesMap.put("AL", "albaniya");
    namesMap.put("AM", "armeniya");
    namesMap.put("AN", "Sǝr ma kasǝŋ ma laŋne");
    namesMap.put("AO", "angola");
    namesMap.put("AR", "argentiniya");
    namesMap.put("AS", "samoa Amerika");
    namesMap.put("AT", "austriya");
    namesMap.put("AU", "australiya");
    namesMap.put("AW", "aruba");
    namesMap.put("AZ", "azerbaijaŋ");
    namesMap.put("BA", "bosniya ne Herzegovina");
    namesMap.put("BB", "barbadiya");
    namesMap.put("BD", "bangladeshiya");
    namesMap.put("BE", "belgika");
    namesMap.put("BF", "burkina Faso");
    namesMap.put("BG", "bulgariya");
    namesMap.put("BH", "bahraiŋ");
    namesMap.put("BI", "burundi");
    namesMap.put("BJ", "beniŋ");
    namesMap.put("BM", "bermudiya");
    namesMap.put("BN", "bruniya");
    namesMap.put("BO", "boliviya");
    namesMap.put("BR", "brazilya");
    namesMap.put("BS", "bahamas");
    namesMap.put("BT", "butaŋ");
    namesMap.put("BW", "botswana");
    namesMap.put("BY", "belarussiya");
    namesMap.put("BZ", "beliziya");
    namesMap.put("CA", "kanada");
    namesMap.put("CD", "Sǝr Kongo ma dii ne zair");
    namesMap.put("CF", "centrafrika");
    namesMap.put("CG", "kongo");
    namesMap.put("CH", "Sǝr Swiss");
    namesMap.put("CI", "ser Ivoiriya");
    namesMap.put("CK", "kook ma laŋne");
    namesMap.put("CL", "syili");
    namesMap.put("CM", "kameruŋ");
    namesMap.put("CN", "syiŋ");
    namesMap.put("CO", "kolombiya");
    namesMap.put("CR", "kosta Rika");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "kap ma laŋne");
    namesMap.put("CY", "Syipriya");
    namesMap.put("CZ", "Sǝr Syek");
    namesMap.put("DE", "Germaniya");
    namesMap.put("DK", "Daŋmark");
    namesMap.put("DM", "Dominik");
    namesMap.put("DO", "Sǝr Dominik ma lii");
    namesMap.put("DZ", "algeriya");
    namesMap.put("EC", "Ekwatǝr");
    namesMap.put("EE", "Estoniya");
    namesMap.put("EG", "Sǝr Egypt");
    namesMap.put("ER", "Sǝr Eritre");
    namesMap.put("ES", "Espaŋiya");
    namesMap.put("ET", "Etiopia");
    namesMap.put("FI", "Sǝr Finland");
    namesMap.put("FJ", "Sǝr Fiji");
    namesMap.put("FK", "Sǝr malouniya ma laŋne");
    namesMap.put("FM", "Micronesiya");
    namesMap.put("FR", "Franssǝ");
    namesMap.put("GA", "Gaboŋ");
    namesMap.put("GB", "Sǝr Anglofoŋ");
    namesMap.put("GD", "Grenadǝ");
    namesMap.put("GE", "Georgiya");
    namesMap.put("GF", "Sǝr Guyana ma Franssǝ");
    namesMap.put("GH", "Gana");
    namesMap.put("GI", "Sǝr Gibraltar");
    namesMap.put("GL", "Sǝr Groenland");
    namesMap.put("GM", "Gambiya");
    namesMap.put("GN", "Guine");
    namesMap.put("GP", "Sǝr Gwadeloupǝ");
    namesMap.put("GQ", "Sǝr Guine");
    namesMap.put("GR", "Sǝr Grek");
    namesMap.put("GT", "Gwatemala");
    namesMap.put("GU", "Gwam");
    namesMap.put("GW", "Guine ma Bissao");
    namesMap.put("HN", "Sǝr Honduras");
    namesMap.put("HR", "kroatiya");
    namesMap.put("HT", "Sǝr Haiti");
    namesMap.put("HU", "Hungriya");
    namesMap.put("ID", "Indonesiya");
    namesMap.put("IE", "Sǝr Ireland");
    namesMap.put("IL", "Sǝr Israel");
    namesMap.put("IN", "Sǝr Indǝ");
    namesMap.put("IO", "anglofoŋ ma Indiya");
    namesMap.put("IQ", "Irak");
    namesMap.put("IR", "Iraŋ");
    namesMap.put("IS", "Sǝr Island");
    namesMap.put("IT", "Italiya");
    namesMap.put("JM", "Jamaika");
    namesMap.put("JO", "Jordaniya");
    namesMap.put("JP", "Japaŋ");
    namesMap.put("KE", "Sǝr Kenya");
    namesMap.put("KG", "Kirgizstaŋ");
    namesMap.put("KH", "kambodiya");
    namesMap.put("KI", "Sǝr Kiribati");
    namesMap.put("KM", "komora");
    namesMap.put("KN", "Sǝr Kristof ne Nievǝ");
    namesMap.put("KP", "Sǝr Kore fah sǝŋ");
    namesMap.put("KR", "Sǝr Kore nekǝsǝŋ");
    namesMap.put("KW", "Sǝr Kowait");
    namesMap.put("KY", "kayman ma laŋne");
    namesMap.put("KZ", "Kazakstaŋ");
    namesMap.put("LA", "Sǝr Laos");
    namesMap.put("LB", "Libaŋ");
    namesMap.put("LC", "Sǝr Lucia");
    namesMap.put("LI", "Lichtǝnsteiŋ");
    namesMap.put("LK", "Sǝr Lanka");
    namesMap.put("LR", "Liberiya");
    namesMap.put("LS", "Sǝr Lesotho");
    namesMap.put("LT", "Lituaniya");
    namesMap.put("LU", "Sǝr Luxemburg");
    namesMap.put("LV", "Letoniya");
    namesMap.put("LY", "Libiya");
    namesMap.put("MA", "Marok");
    namesMap.put("MC", "Monako");
    namesMap.put("MD", "Moldoviya");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Sǝr Marshall ma laŋne");
    namesMap.put("MK", "Macedoniya");
    namesMap.put("ML", "Sǝr Mali");
    namesMap.put("MM", "Sǝr Myanmar");
    namesMap.put("MN", "Mongoliya");
    namesMap.put("MP", "Sǝr Maria ma laŋne");
    namesMap.put("MQ", "Martinika");
    namesMap.put("MR", "Mauritaniya");
    namesMap.put("MS", "Sǝr Montserrat");
    namesMap.put("MT", "Sǝr Malta");
    namesMap.put("MU", "Sǝr Mauricǝ");
    namesMap.put("MV", "Maldivǝ");
    namesMap.put("MW", "Sǝr Malawi");
    namesMap.put("MX", "Mexiko");
    namesMap.put("MY", "Malaysiya");
    namesMap.put("MZ", "Mozambika");
    namesMap.put("NA", "Namibiya");
    namesMap.put("NC", "Kaledoniya mafuu");
    namesMap.put("NE", "Sǝr Niger");
    namesMap.put("NF", "Norfolk ma laŋne");
    namesMap.put("NG", "Nigeriya");
    namesMap.put("NI", "Nikaragwa");
    namesMap.put("NL", "Sǝr ma kasǝŋ");
    namesMap.put("NO", "Norvegǝ");
    namesMap.put("NP", "Sǝr Nepal");
    namesMap.put("NR", "Sǝr Nauru");
    namesMap.put("NU", "Niwe");
    namesMap.put("NZ", "Zeland mafuu");
    namesMap.put("OM", "Omaŋ");
    namesMap.put("PA", "Sǝr Panama");
    namesMap.put("PF", "Sǝr Polynesiya ma Franssǝ");
    namesMap.put("PG", "Papuasiya Guine mafuu");
    namesMap.put("PH", "Filipiŋ");
    namesMap.put("PK", "Pakistaŋ");
    namesMap.put("PL", "Pologŋ");
    namesMap.put("PM", "Sǝr Pǝtar ne Mikǝlon");
    namesMap.put("PN", "Pitkairn");
    namesMap.put("PR", "Porto Riko");
    namesMap.put("PS", "Sǝr Palestiniya");
    namesMap.put("PT", "Sǝr Portugal");
    namesMap.put("PW", "Sǝr Palau");
    namesMap.put("PY", "Paragwai");
    namesMap.put("QA", "Katar");
    namesMap.put("RE", "Sǝr Reunion");
    namesMap.put("RO", "Romaniya");
    namesMap.put("RU", "Russiya");
    namesMap.put("SA", "Sǝr Arabiya");
    namesMap.put("SB", "Sǝr Salomon ma laŋne");
    namesMap.put("SC", "Saichel");
    namesMap.put("SD", "Sudaŋ");
    namesMap.put("SE", "Sǝr Sued");
    namesMap.put("SG", "Singapur");
    namesMap.put("SH", "Sǝr Helena");
    namesMap.put("SI", "Sloveniya");
    namesMap.put("SK", "Slovakiya");
    namesMap.put("SL", "Sierra Leonǝ");
    namesMap.put("SM", "Sǝr Marino");
    namesMap.put("SO", "Somaliya");
    namesMap.put("SR", "Sǝr Surinam");
    namesMap.put("ST", "Sao Tome ne Principe");
    namesMap.put("SV", "Sǝr Salvador");
    namesMap.put("SZ", "Sǝr Swaziland");
    namesMap.put("TC", "Turkiya ne kaicos ma laŋne");
    namesMap.put("TD", "syad");
    namesMap.put("TG", "Sǝr Togo");
    namesMap.put("TH", "Tailand");
    namesMap.put("TJ", "Tajikistaŋ");
    namesMap.put("TK", "Sǝr Tokelau");
    namesMap.put("TL", "Timoriya");
    namesMap.put("TM", "Turkmenistaŋ");
    namesMap.put("TN", "Tunisiya");
    namesMap.put("TO", "Sǝr Tonga");
    namesMap.put("TR", "Turkiya");
    namesMap.put("TT", "Trinite ne Tobago");
    namesMap.put("TV", "Sǝr Tuvalu");
    namesMap.put("TW", "Taiwaŋ");
    namesMap.put("TZ", "Tanzaniya");
    namesMap.put("UA", "Ukraiŋ");
    namesMap.put("US", "Amerika");
    namesMap.put("UY", "Urugwai");
    namesMap.put("UZ", "Uzbekistaŋ");
    namesMap.put("VA", "Vaticaŋ");
    namesMap.put("VC", "Sǝr Vinceŋ ne Grenadiŋ");
    namesMap.put("VE", "Sǝr Venezuela");
    namesMap.put("VG", "ser Anglofon ma laŋne");
    namesMap.put("VI", "Sǝr amerika ma laŋne");
    namesMap.put("VN", "Sǝr Vietnam");
    namesMap.put("VU", "Sǝr Vanuatu");
    namesMap.put("WF", "Wallis ne Futuna");
    namesMap.put("WS", "Sǝr Samoa");
    namesMap.put("YE", "Yemeŋ");
    namesMap.put("YT", "Mayot");
    namesMap.put("ZA", "Afrika nekǝsǝŋ");
    namesMap.put("ZM", "Zambiya");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AD": "andorra",
        "AE": "Sǝr Arabiya ma taini",
        "AF": "afghanistaŋ",
        "AG": "antiguan ne Barbuda",
        "AI": "anguiya",
        "AL": "albaniya",
        "AM": "armeniya",
        "AN": "Sǝr ma kasǝŋ ma laŋne",
        "AO": "angola",
        "AR": "argentiniya",
        "AS": "samoa Amerika",
        "AT": "austriya",
        "AU": "australiya",
        "AW": "aruba",
        "AZ": "azerbaijaŋ",
        "BA": "bosniya ne Herzegovina",
        "BB": "barbadiya",
        "BD": "bangladeshiya",
        "BE": "belgika",
        "BF": "burkina Faso",
        "BG": "bulgariya",
        "BH": "bahraiŋ",
        "BI": "burundi",
        "BJ": "beniŋ",
        "BM": "bermudiya",
        "BN": "bruniya",
        "BO": "boliviya",
        "BR": "brazilya",
        "BS": "bahamas",
        "BT": "butaŋ",
        "BW": "botswana",
        "BY": "belarussiya",
        "BZ": "beliziya",
        "CA": "kanada",
        "CD": "Sǝr Kongo ma dii ne zair",
        "CF": "centrafrika",
        "CG": "kongo",
        "CH": "Sǝr Swiss",
        "CI": "ser Ivoiriya",
        "CK": "kook ma laŋne",
        "CL": "syili",
        "CM": "kameruŋ",
        "CN": "syiŋ",
        "CO": "kolombiya",
        "CR": "kosta Rika",
        "CU": "Kuba",
        "CV": "kap ma laŋne",
        "CY": "Syipriya",
        "CZ": "Sǝr Syek",
        "DE": "Germaniya",
        "DK": "Daŋmark",
        "DM": "Dominik",
        "DO": "Sǝr Dominik ma lii",
        "DZ": "algeriya",
        "EC": "Ekwatǝr",
        "EE": "Estoniya",
        "EG": "Sǝr Egypt",
        "ER": "Sǝr Eritre",
        "ES": "Espaŋiya",
        "ET": "Etiopia",
        "FI": "Sǝr Finland",
        "FJ": "Sǝr Fiji",
        "FK": "Sǝr malouniya ma laŋne",
        "FM": "Micronesiya",
        "FR": "Franssǝ",
        "GA": "Gaboŋ",
        "GB": "Sǝr Anglofoŋ",
        "GD": "Grenadǝ",
        "GE": "Georgiya",
        "GF": "Sǝr Guyana ma Franssǝ",
        "GH": "Gana",
        "GI": "Sǝr Gibraltar",
        "GL": "Sǝr Groenland",
        "GM": "Gambiya",
        "GN": "Guine",
        "GP": "Sǝr Gwadeloupǝ",
        "GQ": "Sǝr Guine",
        "GR": "Sǝr Grek",
        "GT": "Gwatemala",
        "GU": "Gwam",
        "GW": "Guine ma Bissao",
        "HN": "Sǝr Honduras",
        "HR": "kroatiya",
        "HT": "Sǝr Haiti",
        "HU": "Hungriya",
        "ID": "Indonesiya",
        "IE": "Sǝr Ireland",
        "IL": "Sǝr Israel",
        "IN": "Sǝr Indǝ",
        "IO": "anglofoŋ ma Indiya",
        "IQ": "Irak",
        "IR": "Iraŋ",
        "IS": "Sǝr Island",
        "IT": "Italiya",
        "JM": "Jamaika",
        "JO": "Jordaniya",
        "JP": "Japaŋ",
        "KE": "Sǝr Kenya",
        "KG": "Kirgizstaŋ",
        "KH": "kambodiya",
        "KI": "Sǝr Kiribati",
        "KM": "komora",
        "KN": "Sǝr Kristof ne Nievǝ",
        "KP": "Sǝr Kore fah sǝŋ",
        "KR": "Sǝr Kore nekǝsǝŋ",
        "KW": "Sǝr Kowait",
        "KY": "kayman ma laŋne",
        "KZ": "Kazakstaŋ",
        "LA": "Sǝr Laos",
        "LB": "Libaŋ",
        "LC": "Sǝr Lucia",
        "LI": "Lichtǝnsteiŋ",
        "LK": "Sǝr Lanka",
        "LR": "Liberiya",
        "LS": "Sǝr Lesotho",
        "LT": "Lituaniya",
        "LU": "Sǝr Luxemburg",
        "LV": "Letoniya",
        "LY": "Libiya",
        "MA": "Marok",
        "MC": "Monako",
        "MD": "Moldoviya",
        "MG": "Madagaskar",
        "MH": "Sǝr Marshall ma laŋne",
        "MK": "Macedoniya",
        "ML": "Sǝr Mali",
        "MM": "Sǝr Myanmar",
        "MN": "Mongoliya",
        "MP": "Sǝr Maria ma laŋne",
        "MQ": "Martinika",
        "MR": "Mauritaniya",
        "MS": "Sǝr Montserrat",
        "MT": "Sǝr Malta",
        "MU": "Sǝr Mauricǝ",
        "MV": "Maldivǝ",
        "MW": "Sǝr Malawi",
        "MX": "Mexiko",
        "MY": "Malaysiya",
        "MZ": "Mozambika",
        "NA": "Namibiya",
        "NC": "Kaledoniya mafuu",
        "NE": "Sǝr Niger",
        "NF": "Norfolk ma laŋne",
        "NG": "Nigeriya",
        "NI": "Nikaragwa",
        "NL": "Sǝr ma kasǝŋ",
        "NO": "Norvegǝ",
        "NP": "Sǝr Nepal",
        "NR": "Sǝr Nauru",
        "NU": "Niwe",
        "NZ": "Zeland mafuu",
        "OM": "Omaŋ",
        "PA": "Sǝr Panama",
        "PF": "Sǝr Polynesiya ma Franssǝ",
        "PG": "Papuasiya Guine mafuu",
        "PH": "Filipiŋ",
        "PK": "Pakistaŋ",
        "PL": "Pologŋ",
        "PM": "Sǝr Pǝtar ne Mikǝlon",
        "PN": "Pitkairn",
        "PR": "Porto Riko",
        "PS": "Sǝr Palestiniya",
        "PT": "Sǝr Portugal",
        "PW": "Sǝr Palau",
        "PY": "Paragwai",
        "QA": "Katar",
        "RE": "Sǝr Reunion",
        "RO": "Romaniya",
        "RU": "Russiya",
        "SA": "Sǝr Arabiya",
        "SB": "Sǝr Salomon ma laŋne",
        "SC": "Saichel",
        "SD": "Sudaŋ",
        "SE": "Sǝr Sued",
        "SG": "Singapur",
        "SH": "Sǝr Helena",
        "SI": "Sloveniya",
        "SK": "Slovakiya",
        "SL": "Sierra Leonǝ",
        "SM": "Sǝr Marino",
        "SO": "Somaliya",
        "SR": "Sǝr Surinam",
        "ST": "Sao Tome ne Principe",
        "SV": "Sǝr Salvador",
        "SZ": "Sǝr Swaziland",
        "TC": "Turkiya ne kaicos ma laŋne",
        "TD": "syad",
        "TG": "Sǝr Togo",
        "TH": "Tailand",
        "TJ": "Tajikistaŋ",
        "TK": "Sǝr Tokelau",
        "TL": "Timoriya",
        "TM": "Turkmenistaŋ",
        "TN": "Tunisiya",
        "TO": "Sǝr Tonga",
        "TR": "Turkiya",
        "TT": "Trinite ne Tobago",
        "TV": "Sǝr Tuvalu",
        "TW": "Taiwaŋ",
        "TZ": "Tanzaniya",
        "UA": "Ukraiŋ",
        "US": "Amerika",
        "UY": "Urugwai",
        "UZ": "Uzbekistaŋ",
        "VA": "Vaticaŋ",
        "VC": "Sǝr Vinceŋ ne Grenadiŋ",
        "VE": "Sǝr Venezuela",
        "VG": "ser Anglofon ma laŋne",
        "VI": "Sǝr amerika ma laŋne",
        "VN": "Sǝr Vietnam",
        "VU": "Sǝr Vanuatu",
        "WF": "Wallis ne Futuna",
        "WS": "Sǝr Samoa",
        "YE": "Yemeŋ",
        "YT": "Mayot",
        "ZA": "Afrika nekǝsǝŋ",
        "ZM": "Zambiya"
    };
  }-*/;
}
