/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.message.DbException;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.StreamStore;
import org.h2.mvstore.db.MVTableEngine;
import org.h2.store.CountingReaderInputStream;
import org.h2.store.LobStorageInterface;
import org.h2.util.IOUtils;
import org.h2.util.New;
import org.h2.value.Value;
import org.h2.value.ValueLobDb;

public class LobStorageMap
implements LobStorageInterface {
    private static final boolean TRACE = false;
    private final Database database;
    private boolean init;
    private Object nextLobIdSync = new Object();
    private long nextLobId;
    private MVMap<Long, Object[]> lobMap;
    private MVMap<Object[], Boolean> refMap;
    private MVMap<Long, byte[]> dataMap;
    private StreamStore streamStore;

    public LobStorageMap(Database database) {
        this.database = database;
    }

    @Override
    public void init() {
        if (this.init) {
            return;
        }
        this.init = true;
        MVTableEngine.Store store = this.database.getMvStore();
        MVStore mVStore = store == null ? MVStore.open(null) : store.getStore();
        this.lobMap = mVStore.openMap("lobMap");
        this.refMap = mVStore.openMap("lobRef");
        this.dataMap = mVStore.openMap("lobData");
        this.streamStore = new StreamStore(this.dataMap);
    }

    @Override
    public Value createBlob(InputStream inputStream, long l) {
        this.init();
        int n = 15;
        if (l < 0L) {
            l = Long.MAX_VALUE;
        }
        int n2 = (int)Math.min(l, (long)this.database.getMaxLengthInplaceLob());
        try {
            if (n2 != 0 && n2 < Integer.MAX_VALUE) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, n2);
                bufferedInputStream.mark(n2);
                byte[] byArray = new byte[n2];
                int n3 = IOUtils.readFully(bufferedInputStream, byArray, n2);
                if (n3 < n2) {
                    if (n3 < byArray.length) {
                        byArray = Arrays.copyOf(byArray, n3);
                    }
                    return ValueLobDb.createSmallLob(n, byArray);
                }
                bufferedInputStream.reset();
                inputStream = bufferedInputStream;
            }
            return this.createLob(inputStream, n);
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90007, illegalStateException, new String[0]);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    @Override
    public Value createClob(Reader closeable, long l) {
        this.init();
        int n = 16;
        if (l < 0L) {
            l = Long.MAX_VALUE;
        }
        int n2 = (int)Math.min(l, (long)this.database.getMaxLengthInplaceLob());
        try {
            Object object;
            Closeable closeable2;
            if (n2 != 0 && n2 < Integer.MAX_VALUE) {
                closeable2 = new BufferedReader((Reader)closeable, n2);
                ((BufferedReader)closeable2).mark(n2);
                object = new char[n2];
                int n3 = IOUtils.readFully((Reader)closeable2, (char[])object, n2);
                if (n3 < n2) {
                    if (n3 < ((Object)object).length) {
                        object = Arrays.copyOf((char[])object, n3);
                    }
                    byte[] byArray = new String((char[])object, 0, n3).getBytes(Constants.UTF8);
                    return ValueLobDb.createSmallLob(n, byArray);
                }
                ((BufferedReader)closeable2).reset();
                closeable = closeable2;
            }
            closeable2 = new CountingReaderInputStream((Reader)closeable, l);
            object = this.createLob((InputStream)closeable2, n);
            object = ValueLobDb.create(n, this.database, ((ValueLobDb)object).getTableId(), ((ValueLobDb)object).getLobId(), null, ((CountingReaderInputStream)closeable2).getLength());
            return object;
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90007, illegalStateException, new String[0]);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    private ValueLobDb createLob(InputStream inputStream, int n) throws IOException {
        byte[] byArray;
        try {
            byArray = this.streamStore.put(inputStream);
        }
        catch (Exception exception) {
            throw DbException.convertToIOException(exception);
        }
        long l = this.generateLobId();
        long l2 = this.streamStore.length(byArray);
        int n2 = -2;
        Object[] objectArray = new Object[]{byArray, n2, l2, 0};
        this.lobMap.put(l, objectArray);
        Object[] objectArray2 = new Object[]{byArray, l};
        this.refMap.put(objectArray2, Boolean.TRUE);
        ValueLobDb valueLobDb = ValueLobDb.create(n, this.database, n2, l, null, l2);
        return valueLobDb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long generateLobId() {
        Object object = this.nextLobIdSync;
        synchronized (object) {
            if (this.nextLobId == 0L) {
                Long l = this.lobMap.lastKey();
                this.nextLobId = l == null ? 1L : l + 1L;
            }
            return this.nextLobId++;
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.database.isReadOnly();
    }

    @Override
    public ValueLobDb copyLob(ValueLobDb valueLobDb, int n, long l) {
        this.init();
        int n2 = valueLobDb.getType();
        long l2 = valueLobDb.getLobId();
        long l3 = valueLobDb.getPrecision();
        if (l3 != l) {
            throw DbException.throwInternalError("Length is different");
        }
        Object[] objectArray = this.lobMap.get(l2);
        objectArray = Arrays.copyOf(objectArray, objectArray.length);
        byte[] byArray = (byte[])objectArray[0];
        long l4 = this.generateLobId();
        objectArray[1] = n;
        this.lobMap.put(l4, objectArray);
        Object[] objectArray2 = new Object[]{byArray, l4};
        this.refMap.put(objectArray2, Boolean.TRUE);
        ValueLobDb valueLobDb2 = ValueLobDb.create(n2, this.database, n, l4, null, l);
        return valueLobDb2;
    }

    @Override
    public InputStream getInputStream(ValueLobDb valueLobDb, byte[] byArray, long l) throws IOException {
        this.init();
        Object[] objectArray = this.lobMap.get(valueLobDb.getLobId());
        if (objectArray == null) {
            throw DbException.throwInternalError("Lob not found: " + valueLobDb.getLobId());
        }
        byte[] byArray2 = (byte[])objectArray[0];
        return this.streamStore.get(byArray2);
    }

    @Override
    public void setTable(ValueLobDb valueLobDb, int n) {
        this.init();
        long l = valueLobDb.getLobId();
        Object[] objectArray = this.lobMap.remove(l);
        objectArray[1] = n;
        this.lobMap.put(l, objectArray);
    }

    @Override
    public void removeAllForTable(int n) {
        this.init();
        ArrayList arrayList = New.arrayList();
        for (Map.Entry<Long, Object[]> entry : this.lobMap.entrySet()) {
            Object[] objectArray = entry.getValue();
            int n2 = (Integer)objectArray[1];
            if (n2 != n) continue;
            arrayList.add(entry.getKey());
        }
        Iterator<Map.Entry<Long, Object>> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            long l = (Long)((Object)iterator.next());
            this.removeLob(n, l);
        }
    }

    @Override
    public void removeLob(ValueLobDb valueLobDb) {
        this.init();
        int n = valueLobDb.getTableId();
        long l = valueLobDb.getLobId();
        this.removeLob(n, l);
    }

    private void removeLob(int n, long l) {
        byte[] byArray;
        Object[] objectArray = this.lobMap.remove(l);
        if (objectArray == null) {
            return;
        }
        byte[] byArray2 = (byte[])objectArray[0];
        Object[] objectArray2 = new Object[]{byArray2, l};
        this.refMap.remove(objectArray2);
        objectArray2 = new Object[]{byArray2, 0L};
        objectArray = this.refMap.ceilingKey(objectArray2);
        boolean bl = false;
        if (objectArray != null && Arrays.equals(byArray2, byArray = (byte[])objectArray[0])) {
            bl = true;
        }
        if (!bl) {
            this.streamStore.remove(byArray2);
        }
    }

    private static void trace(String string) {
        System.out.println(Thread.currentThread().getName() + " LOB " + string);
    }
}

