/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import org.h2.util.StringUtils;

public class ParserUtil {
    public static final int KEYWORD = 1;
    public static final int IDENTIFIER = 2;
    public static final int ALL = 3;
    public static final int AND = 4;
    public static final int ANY = 5;
    public static final int ARRAY = 6;
    public static final int AS = 7;
    public static final int ASYMMETRIC = 8;
    public static final int AUTHORIZATION = 9;
    public static final int BETWEEN = 10;
    public static final int CASE = 11;
    public static final int CAST = 12;
    public static final int CHECK = 13;
    public static final int CONSTRAINT = 14;
    public static final int CROSS = 15;
    public static final int CURRENT_CATALOG = 16;
    public static final int CURRENT_DATE = 17;
    public static final int CURRENT_PATH = 18;
    public static final int CURRENT_ROLE = 19;
    public static final int CURRENT_SCHEMA = 20;
    public static final int CURRENT_TIME = 21;
    public static final int CURRENT_TIMESTAMP = 22;
    public static final int CURRENT_USER = 23;
    public static final int DAY = 24;
    public static final int DEFAULT = 25;
    public static final int DISTINCT = 26;
    public static final int ELSE = 27;
    public static final int END = 28;
    public static final int EXCEPT = 29;
    public static final int EXISTS = 30;
    public static final int FALSE = 31;
    public static final int FETCH = 32;
    public static final int FOR = 33;
    public static final int FOREIGN = 34;
    public static final int FROM = 35;
    public static final int FULL = 36;
    public static final int GROUP = 37;
    public static final int HAVING = 38;
    public static final int HOUR = 39;
    public static final int IF = 40;
    public static final int IN = 41;
    public static final int INNER = 42;
    public static final int INTERSECT = 43;
    public static final int INTERSECTS = 44;
    public static final int INTERVAL = 45;
    public static final int IS = 46;
    public static final int JOIN = 47;
    public static final int KEY = 48;
    public static final int LEFT = 49;
    public static final int LIKE = 50;
    public static final int LIMIT = 51;
    public static final int LOCALTIME = 52;
    public static final int LOCALTIMESTAMP = 53;
    public static final int MINUS = 54;
    public static final int MINUTE = 55;
    public static final int MONTH = 56;
    public static final int NATURAL = 57;
    public static final int NOT = 58;
    public static final int NULL = 59;
    public static final int OFFSET = 60;
    public static final int ON = 61;
    public static final int OR = 62;
    public static final int ORDER = 63;
    public static final int PRIMARY = 64;
    public static final int QUALIFY = 65;
    public static final int RIGHT = 66;
    public static final int ROW = 67;
    public static final int ROWNUM = 68;
    public static final int SECOND = 69;
    public static final int SELECT = 70;
    public static final int SESSION_USER = 71;
    public static final int SET = 72;
    public static final int SOME = 73;
    public static final int SYMMETRIC = 74;
    public static final int SYSTEM_USER = 75;
    public static final int TABLE = 76;
    public static final int TO = 77;
    public static final int TRUE = 78;
    public static final int UESCAPE = 79;
    public static final int UNION = 80;
    public static final int UNIQUE = 81;
    public static final int UNKNOWN = 82;
    public static final int USER = 83;
    public static final int USING = 84;
    public static final int VALUE = 85;
    public static final int VALUES = 86;
    public static final int WHEN = 87;
    public static final int WHERE = 88;
    public static final int WINDOW = 89;
    public static final int WITH = 90;
    public static final int YEAR = 91;
    public static final int _ROWID_ = 92;
    public static final int FIRST_KEYWORD = 3;
    public static final int LAST_KEYWORD = 92;

    private ParserUtil() {
    }

    public static StringBuilder quoteIdentifier(StringBuilder stringBuilder, String string, int n) {
        if (string == null) {
            return stringBuilder.append("\"\"");
        }
        if ((n & 1) != 0 && ParserUtil.isSimpleIdentifier(string, false, false)) {
            return stringBuilder.append(string);
        }
        return StringUtils.quoteIdentifier(stringBuilder, string);
    }

    public static boolean isKeyword(String string, boolean bl) {
        return ParserUtil.getTokenType(string, bl, 0, string.length(), false) != 2;
    }

    public static boolean isSimpleIdentifier(String string, boolean bl, boolean bl2) {
        if (bl && bl2) {
            throw new IllegalArgumentException("databaseToUpper && databaseToLower");
        }
        int n = string.length();
        if (n == 0 || !ParserUtil.checkLetter(bl, bl2, string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '_' || c >= '0' && c <= '9' || ParserUtil.checkLetter(bl, bl2, c)) continue;
            return false;
        }
        return ParserUtil.getTokenType(string, !bl, 0, n, true) == 2;
    }

    private static boolean checkLetter(boolean bl, boolean bl2, char c) {
        return !(bl ? c < 'A' || c > 'Z' : (bl2 ? c < 'a' || c > 'z' : !(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')));
    }

    public static int getTokenType(String string, boolean bl, int n, int n2, boolean bl2) {
        if (n2 <= 1 || n2 > 17) {
            return 2;
        }
        char c = string.charAt(n);
        if (bl) {
            c = (char)(c & 0xFFDF);
        }
        if (n2 == 2) {
            char c2 = string.charAt(n + 1);
            if (bl) {
                c2 = (char)(c2 & 0xFFDF);
            }
            switch (c) {
                case 'A': {
                    if (c2 == 'S') {
                        return 7;
                    }
                    return 2;
                }
                case 'I': {
                    if (c2 == 'F') {
                        return 40;
                    }
                    if (c2 == 'N') {
                        return 41;
                    }
                    if (c2 == 'S') {
                        return 46;
                    }
                    return 2;
                }
                case 'O': {
                    if (c2 == 'N') {
                        return 61;
                    }
                    if (c2 == 'R') {
                        return 62;
                    }
                    return 2;
                }
                case 'T': {
                    if (c2 != 'O') break;
                    return 77;
                }
            }
            return 2;
        }
        switch (c) {
            case 'A': {
                if (ParserUtil.eq("ALL", string, bl, n, n2)) {
                    return 3;
                }
                if (ParserUtil.eq("AND", string, bl, n, n2)) {
                    return 4;
                }
                if (ParserUtil.eq("ANY", string, bl, n, n2)) {
                    return 5;
                }
                if (ParserUtil.eq("ARRAY", string, bl, n, n2)) {
                    return 6;
                }
                if (ParserUtil.eq("ASYMMETRIC", string, bl, n, n2)) {
                    return 8;
                }
                if (ParserUtil.eq("AUTHORIZATION", string, bl, n, n2)) {
                    return 9;
                }
                return 2;
            }
            case 'B': {
                if (ParserUtil.eq("BETWEEN", string, bl, n, n2)) {
                    return 10;
                }
                if (bl2 && ParserUtil.eq("BOTH", string, bl, n, n2)) {
                    return 1;
                }
                return 2;
            }
            case 'C': {
                if (ParserUtil.eq("CASE", string, bl, n, n2)) {
                    return 11;
                }
                if (ParserUtil.eq("CAST", string, bl, n, n2)) {
                    return 12;
                }
                if (ParserUtil.eq("CHECK", string, bl, n, n2)) {
                    return 13;
                }
                if (ParserUtil.eq("CONSTRAINT", string, bl, n, n2)) {
                    return 14;
                }
                if (ParserUtil.eq("CROSS", string, bl, n, n2)) {
                    return 15;
                }
                if (n2 >= 12 && "CURRENT_".regionMatches(bl, 1, string, n + 1, 7)) {
                    return ParserUtil.getTokenTypeCurrent(string, bl, n, n2);
                }
                return 2;
            }
            case 'D': {
                if (ParserUtil.eq("DAY", string, bl, n, n2)) {
                    return 24;
                }
                if (ParserUtil.eq("DEFAULT", string, bl, n, n2)) {
                    return 25;
                }
                if (ParserUtil.eq("DISTINCT", string, bl, n, n2)) {
                    return 26;
                }
                return 2;
            }
            case 'E': {
                if (ParserUtil.eq("ELSE", string, bl, n, n2)) {
                    return 27;
                }
                if (ParserUtil.eq("END", string, bl, n, n2)) {
                    return 28;
                }
                if (ParserUtil.eq("EXCEPT", string, bl, n, n2)) {
                    return 29;
                }
                if (ParserUtil.eq("EXISTS", string, bl, n, n2)) {
                    return 30;
                }
                return 2;
            }
            case 'F': {
                if (ParserUtil.eq("FETCH", string, bl, n, n2)) {
                    return 32;
                }
                if (ParserUtil.eq("FROM", string, bl, n, n2)) {
                    return 35;
                }
                if (ParserUtil.eq("FOR", string, bl, n, n2)) {
                    return 33;
                }
                if (ParserUtil.eq("FOREIGN", string, bl, n, n2)) {
                    return 34;
                }
                if (ParserUtil.eq("FULL", string, bl, n, n2)) {
                    return 36;
                }
                if (ParserUtil.eq("FALSE", string, bl, n, n2)) {
                    return 31;
                }
                if (bl2 && ParserUtil.eq("FILTER", string, bl, n, n2)) {
                    return 1;
                }
                return 2;
            }
            case 'G': {
                if (ParserUtil.eq("GROUP", string, bl, n, n2)) {
                    return 37;
                }
                if (bl2 && ParserUtil.eq("GROUPS", string, bl, n, n2)) {
                    return 1;
                }
                return 2;
            }
            case 'H': {
                if (ParserUtil.eq("HAVING", string, bl, n, n2)) {
                    return 38;
                }
                if (ParserUtil.eq("HOUR", string, bl, n, n2)) {
                    return 39;
                }
                return 2;
            }
            case 'I': {
                if (ParserUtil.eq("INNER", string, bl, n, n2)) {
                    return 42;
                }
                if (ParserUtil.eq("INTERSECT", string, bl, n, n2)) {
                    return 43;
                }
                if (ParserUtil.eq("INTERSECTS", string, bl, n, n2)) {
                    return 44;
                }
                if (ParserUtil.eq("INTERVAL", string, bl, n, n2)) {
                    return 45;
                }
                if (bl2 && ParserUtil.eq("ILIKE", string, bl, n, n2)) {
                    return 1;
                }
                return 2;
            }
            case 'J': {
                if (ParserUtil.eq("JOIN", string, bl, n, n2)) {
                    return 47;
                }
                return 2;
            }
            case 'K': {
                if (ParserUtil.eq("KEY", string, bl, n, n2)) {
                    return 48;
                }
                return 2;
            }
            case 'L': {
                if (ParserUtil.eq("LEFT", string, bl, n, n2)) {
                    return 49;
                }
                if (ParserUtil.eq("LIMIT", string, bl, n, n2)) {
                    return 51;
                }
                if (ParserUtil.eq("LIKE", string, bl, n, n2)) {
                    return 50;
                }
                if (ParserUtil.eq("LOCALTIME", string, bl, n, n2)) {
                    return 52;
                }
                if (ParserUtil.eq("LOCALTIMESTAMP", string, bl, n, n2)) {
                    return 53;
                }
                if (bl2 && ParserUtil.eq("LEADING", string, bl, n, n2)) {
                    return 1;
                }
                return 2;
            }
            case 'M': {
                if (ParserUtil.eq("MINUS", string, bl, n, n2)) {
                    return 54;
                }
                if (ParserUtil.eq("MINUTE", string, bl, n, n2)) {
                    return 55;
                }
                if (ParserUtil.eq("MONTH", string, bl, n, n2)) {
                    return 56;
                }
                return 2;
            }
            case 'N': {
                if (ParserUtil.eq("NOT", string, bl, n, n2)) {
                    return 58;
                }
                if (ParserUtil.eq("NATURAL", string, bl, n, n2)) {
                    return 57;
                }
                if (ParserUtil.eq("NULL", string, bl, n, n2)) {
                    return 59;
                }
                return 2;
            }
            case 'O': {
                if (ParserUtil.eq("OFFSET", string, bl, n, n2)) {
                    return 60;
                }
                if (ParserUtil.eq("ORDER", string, bl, n, n2)) {
                    return 63;
                }
                if (bl2 && ParserUtil.eq("OVER", string, bl, n, n2)) {
                    return 1;
                }
                return 2;
            }
            case 'P': {
                if (ParserUtil.eq("PRIMARY", string, bl, n, n2)) {
                    return 64;
                }
                if (bl2 && ParserUtil.eq("PARTITION", string, bl, n, n2)) {
                    return 1;
                }
                return 2;
            }
            case 'Q': {
                if (ParserUtil.eq("QUALIFY", string, bl, n, n2)) {
                    return 65;
                }
                return 2;
            }
            case 'R': {
                if (ParserUtil.eq("RIGHT", string, bl, n, n2)) {
                    return 66;
                }
                if (ParserUtil.eq("ROW", string, bl, n, n2)) {
                    return 67;
                }
                if (ParserUtil.eq("ROWNUM", string, bl, n, n2)) {
                    return 68;
                }
                if (bl2 && (ParserUtil.eq("RANGE", string, bl, n, n2) || ParserUtil.eq("REGEXP", string, bl, n, n2) || ParserUtil.eq("ROWS", string, bl, n, n2))) {
                    return 1;
                }
                return 2;
            }
            case 'S': {
                if (ParserUtil.eq("SECOND", string, bl, n, n2)) {
                    return 69;
                }
                if (ParserUtil.eq("SELECT", string, bl, n, n2)) {
                    return 70;
                }
                if (ParserUtil.eq("SESSION_USER", string, bl, n, n2)) {
                    return 71;
                }
                if (ParserUtil.eq("SET", string, bl, n, n2)) {
                    return 72;
                }
                if (ParserUtil.eq("SOME", string, bl, n, n2)) {
                    return 73;
                }
                if (ParserUtil.eq("SYMMETRIC", string, bl, n, n2)) {
                    return 74;
                }
                if (ParserUtil.eq("SYSTEM_USER", string, bl, n, n2)) {
                    return 75;
                }
                return 2;
            }
            case 'T': {
                if (ParserUtil.eq("TABLE", string, bl, n, n2)) {
                    return 76;
                }
                if (ParserUtil.eq("TRUE", string, bl, n, n2)) {
                    return 78;
                }
                if (bl2 && (ParserUtil.eq("TOP", string, bl, n, n2) || ParserUtil.eq("TRAILING", string, bl, n, n2))) {
                    return 1;
                }
                return 2;
            }
            case 'U': {
                if (ParserUtil.eq("UESCAPE", string, bl, n, n2)) {
                    return 79;
                }
                if (ParserUtil.eq("UNION", string, bl, n, n2)) {
                    return 80;
                }
                if (ParserUtil.eq("UNIQUE", string, bl, n, n2)) {
                    return 81;
                }
                if (ParserUtil.eq("UNKNOWN", string, bl, n, n2)) {
                    return 82;
                }
                if (ParserUtil.eq("USER", string, bl, n, n2)) {
                    return 83;
                }
                if (ParserUtil.eq("USING", string, bl, n, n2)) {
                    return 84;
                }
                return 2;
            }
            case 'V': {
                if (ParserUtil.eq("VALUE", string, bl, n, n2)) {
                    return 85;
                }
                if (ParserUtil.eq("VALUES", string, bl, n, n2)) {
                    return 86;
                }
                return 2;
            }
            case 'W': {
                if (ParserUtil.eq("WHEN", string, bl, n, n2)) {
                    return 87;
                }
                if (ParserUtil.eq("WHERE", string, bl, n, n2)) {
                    return 88;
                }
                if (ParserUtil.eq("WINDOW", string, bl, n, n2)) {
                    return 89;
                }
                if (ParserUtil.eq("WITH", string, bl, n, n2)) {
                    return 90;
                }
                return 2;
            }
            case 'Y': {
                if (ParserUtil.eq("YEAR", string, bl, n, n2)) {
                    return 91;
                }
                return 2;
            }
            case '_': {
                if (n2 != 7 || !"_ROWID_".regionMatches(bl, 0, string, n, 7)) break;
                return 92;
            }
        }
        return 2;
    }

    private static boolean eq(String string, String string2, boolean bl, int n, int n2) {
        return n2 == string.length() && string.regionMatches(bl, 1, string2, n + 1, n2 - 1);
    }

    private static int getTokenTypeCurrent(String string, boolean bl, int n, int n2) {
        n += 8;
        switch (n2 -= 8) {
            case 4: {
                if ("CURRENT_DATE".regionMatches(bl, 8, string, n, n2)) {
                    return 17;
                }
                if ("CURRENT_PATH".regionMatches(bl, 8, string, n, n2)) {
                    return 18;
                }
                if ("CURRENT_ROLE".regionMatches(bl, 8, string, n, n2)) {
                    return 19;
                }
                if ("CURRENT_TIME".regionMatches(bl, 8, string, n, n2)) {
                    return 21;
                }
                if (!"CURRENT_USER".regionMatches(bl, 8, string, n, n2)) break;
                return 23;
            }
            case 6: {
                if (!"CURRENT_SCHEMA".regionMatches(bl, 8, string, n, n2)) break;
                return 20;
            }
            case 7: {
                if (!"CURRENT_CATALOG".regionMatches(bl, 8, string, n, n2)) break;
                return 16;
            }
            case 9: {
                if (!"CURRENT_TIMESTAMP".regionMatches(bl, 8, string, n, n2)) break;
                return 22;
            }
        }
        return 2;
    }
}

