/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.DynamicConfigAddCacheConfigCodec;
import com.hazelcast.client.impl.protocol.codec.DynamicConfigAddCardinalityEstimatorConfigCodec;
import com.hazelcast.client.impl.protocol.codec.DynamicConfigAddDurableExecutorConfigCodec;
import com.hazelcast.client.impl.protocol.codec.DynamicConfigAddEventJournalConfigCodec;
import com.hazelcast.client.impl.protocol.codec.DynamicConfigAddExecutorConfigCodec;
import com.hazelcast.client.impl.protocol.codec.DynamicConfigAddListConfigCodec;
import com.hazelcast.client.impl.protocol.codec.DynamicConfigAddLockConfigCodec;
import com.hazelcast.client.impl.protocol.codec.DynamicConfigAddMapConfigCodec;
import com.hazelcast.client.impl.protocol.codec.DynamicConfigAddMultiMapConfigCodec;
import com.hazelcast.client.impl.protocol.codec.DynamicConfigAddQueueConfigCodec;
import com.hazelcast.client.impl.protocol.codec.DynamicConfigAddReliableTopicConfigCodec;
import com.hazelcast.client.impl.protocol.codec.DynamicConfigAddReplicatedMapConfigCodec;
import com.hazelcast.client.impl.protocol.codec.DynamicConfigAddRingbufferConfigCodec;
import com.hazelcast.client.impl.protocol.codec.DynamicConfigAddScheduledExecutorConfigCodec;
import com.hazelcast.client.impl.protocol.codec.DynamicConfigAddSemaphoreConfigCodec;
import com.hazelcast.client.impl.protocol.codec.DynamicConfigAddSetConfigCodec;
import com.hazelcast.client.impl.protocol.codec.DynamicConfigAddTopicConfigCodec;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.EvictionConfigHolder;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.ListenerConfigHolder;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.MapStoreConfigHolder;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.NearCacheConfigHolder;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.QueryCacheConfigHolder;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.QueueStoreConfigHolder;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.RingbufferStoreConfigHolder;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.CardinalityEstimatorConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigPatternMatcher;
import com.hazelcast.config.DurableExecutorConfig;
import com.hazelcast.config.EventJournalConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.HotRestartConfig;
import com.hazelcast.config.HotRestartPersistenceConfig;
import com.hazelcast.config.JobTrackerConfig;
import com.hazelcast.config.ListConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.LockConfig;
import com.hazelcast.config.ManagementCenterConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.MemberAttributeConfig;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.PartitionGroupConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.QueueStoreConfig;
import com.hazelcast.config.QuorumConfig;
import com.hazelcast.config.ReliableTopicConfig;
import com.hazelcast.config.ReplicatedMapConfig;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.config.RingbufferStoreConfig;
import com.hazelcast.config.ScheduledExecutorConfig;
import com.hazelcast.config.SecurityConfig;
import com.hazelcast.config.SemaphoreConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.ServicesConfig;
import com.hazelcast.config.SetConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.config.UserCodeDeploymentConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.StringUtil;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;

public class ClientDynamicClusterConfig
extends Config {
    private static final String UNSUPPORTED_ERROR_MESSAGE = "Client config object only supports adding new data structure configurations";
    private final HazelcastClientInstanceImpl instance;
    private final SerializationService serializationService;

    public ClientDynamicClusterConfig(HazelcastClientInstanceImpl instance) {
        this.instance = instance;
        this.serializationService = instance.getSerializationService();
    }

    public Config addMapConfig(MapConfig mapConfig) {
        List<ListenerConfigHolder> listenerConfigs = this.adaptListenerConfigs(mapConfig.getEntryListenerConfigs());
        List<ListenerConfigHolder> partitionLostListenerConfigs = this.adaptListenerConfigs(mapConfig.getPartitionLostListenerConfigs());
        ArrayList<QueryCacheConfigHolder> queryCacheConfigHolders = null;
        if (mapConfig.getQueryCacheConfigs() != null && !mapConfig.getQueryCacheConfigs().isEmpty()) {
            queryCacheConfigHolders = new ArrayList<QueryCacheConfigHolder>(mapConfig.getQueryCacheConfigs().size());
            for (QueryCacheConfig config : mapConfig.getQueryCacheConfigs()) {
                queryCacheConfigHolders.add(QueryCacheConfigHolder.of((QueryCacheConfig)config, (SerializationService)this.serializationService));
            }
        }
        String partitioningStrategyClassName = mapConfig.getPartitioningStrategyConfig() == null ? null : mapConfig.getPartitioningStrategyConfig().getPartitioningStrategyClass();
        Data partitioningStrategy = mapConfig.getPartitioningStrategyConfig() == null ? null : this.serializationService.toData((Object)mapConfig.getPartitioningStrategyConfig().getPartitioningStrategy());
        ClientMessage request = DynamicConfigAddMapConfigCodec.encodeRequest((String)mapConfig.getName(), (int)mapConfig.getBackupCount(), (int)mapConfig.getAsyncBackupCount(), (int)mapConfig.getTimeToLiveSeconds(), (int)mapConfig.getMaxIdleSeconds(), (String)mapConfig.getEvictionPolicy().name(), (boolean)mapConfig.isReadBackupData(), (String)mapConfig.getCacheDeserializedValues().name(), (String)mapConfig.getMergePolicy(), (String)mapConfig.getInMemoryFormat().name(), listenerConfigs, partitionLostListenerConfigs, (boolean)mapConfig.isStatisticsEnabled(), (String)mapConfig.getQuorumName(), (Data)this.serializationService.toData((Object)mapConfig.getMapEvictionPolicy()), (String)mapConfig.getMaxSizeConfig().getMaxSizePolicy().name(), (int)mapConfig.getMaxSizeConfig().getSize(), (MapStoreConfigHolder)MapStoreConfigHolder.of((MapStoreConfig)mapConfig.getMapStoreConfig(), (SerializationService)this.serializationService), (NearCacheConfigHolder)NearCacheConfigHolder.of((NearCacheConfig)mapConfig.getNearCacheConfig(), (SerializationService)this.serializationService), (WanReplicationRef)mapConfig.getWanReplicationRef(), (Collection)mapConfig.getMapIndexConfigs(), (Collection)mapConfig.getMapAttributeConfigs(), queryCacheConfigHolders, (String)partitioningStrategyClassName, (Data)partitioningStrategy, (HotRestartConfig)mapConfig.getHotRestartConfig());
        this.invoke(request);
        return this;
    }

    public Config addCacheConfig(CacheSimpleConfig cacheConfig) {
        List<ListenerConfigHolder> partitionLostListenerConfigs = this.adaptListenerConfigs(cacheConfig.getPartitionLostListenerConfigs());
        ClientMessage request = DynamicConfigAddCacheConfigCodec.encodeRequest((String)cacheConfig.getName(), (String)cacheConfig.getKeyType(), (String)cacheConfig.getValueType(), (boolean)cacheConfig.isStatisticsEnabled(), (boolean)cacheConfig.isManagementEnabled(), (boolean)cacheConfig.isReadThrough(), (boolean)cacheConfig.isWriteThrough(), (String)cacheConfig.getCacheLoaderFactory(), (String)cacheConfig.getCacheWriterFactory(), (String)cacheConfig.getCacheLoader(), (String)cacheConfig.getCacheWriter(), (int)cacheConfig.getBackupCount(), (int)cacheConfig.getAsyncBackupCount(), (String)cacheConfig.getInMemoryFormat().name(), (String)cacheConfig.getQuorumName(), (String)cacheConfig.getMergePolicy(), (boolean)cacheConfig.isDisablePerEntryInvalidationEvents(), partitionLostListenerConfigs, (String)(cacheConfig.getExpiryPolicyFactoryConfig() == null ? null : cacheConfig.getExpiryPolicyFactoryConfig().getClassName()), (CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig)(cacheConfig.getExpiryPolicyFactoryConfig() == null ? null : cacheConfig.getExpiryPolicyFactoryConfig().getTimedExpiryPolicyFactoryConfig()), (Collection)cacheConfig.getCacheEntryListeners(), (EvictionConfigHolder)EvictionConfigHolder.of((EvictionConfig)cacheConfig.getEvictionConfig(), (SerializationService)this.serializationService), (WanReplicationRef)cacheConfig.getWanReplicationRef(), (HotRestartConfig)cacheConfig.getHotRestartConfig());
        this.invoke(request);
        return this;
    }

    public Config addQueueConfig(QueueConfig queueConfig) {
        List<ListenerConfigHolder> listenerConfigs = this.adaptListenerConfigs(queueConfig.getItemListenerConfigs());
        QueueStoreConfigHolder queueStoreConfigHolder = QueueStoreConfigHolder.of((QueueStoreConfig)queueConfig.getQueueStoreConfig(), (SerializationService)this.serializationService);
        ClientMessage request = DynamicConfigAddQueueConfigCodec.encodeRequest((String)queueConfig.getName(), listenerConfigs, (int)queueConfig.getBackupCount(), (int)queueConfig.getAsyncBackupCount(), (int)queueConfig.getMaxSize(), (int)queueConfig.getEmptyQueueTtl(), (boolean)queueConfig.isStatisticsEnabled(), (String)queueConfig.getQuorumName(), (QueueStoreConfigHolder)queueStoreConfigHolder);
        this.invoke(request);
        return this;
    }

    public Config addLockConfig(LockConfig lockConfig) {
        ClientMessage request = DynamicConfigAddLockConfigCodec.encodeRequest((String)lockConfig.getName(), (String)lockConfig.getQuorumName());
        this.invoke(request);
        return this;
    }

    public Config addListConfig(ListConfig listConfig) {
        List<ListenerConfigHolder> listenerConfigs = this.adaptListenerConfigs(listConfig.getItemListenerConfigs());
        ClientMessage request = DynamicConfigAddListConfigCodec.encodeRequest((String)listConfig.getName(), listenerConfigs, (int)listConfig.getBackupCount(), (int)listConfig.getAsyncBackupCount(), (int)listConfig.getMaxSize(), (boolean)listConfig.isStatisticsEnabled());
        this.invoke(request);
        return this;
    }

    public Config addSetConfig(SetConfig setConfig) {
        List<ListenerConfigHolder> listenerConfigs = this.adaptListenerConfigs(setConfig.getItemListenerConfigs());
        ClientMessage request = DynamicConfigAddSetConfigCodec.encodeRequest((String)setConfig.getName(), listenerConfigs, (int)setConfig.getBackupCount(), (int)setConfig.getAsyncBackupCount(), (int)setConfig.getMaxSize(), (boolean)setConfig.isStatisticsEnabled());
        this.invoke(request);
        return this;
    }

    public Config addMultiMapConfig(MultiMapConfig multiMapConfig) {
        List<ListenerConfigHolder> listenerConfigHolders = this.adaptListenerConfigs(multiMapConfig.getEntryListenerConfigs());
        ClientMessage request = DynamicConfigAddMultiMapConfigCodec.encodeRequest((String)multiMapConfig.getName(), (String)multiMapConfig.getValueCollectionType().toString(), listenerConfigHolders, (boolean)multiMapConfig.isBinary(), (int)multiMapConfig.getBackupCount(), (int)multiMapConfig.getAsyncBackupCount(), (boolean)multiMapConfig.isStatisticsEnabled());
        this.invoke(request);
        return this;
    }

    public Config addReplicatedMapConfig(ReplicatedMapConfig replicatedMapConfig) {
        List<ListenerConfigHolder> listenerConfigHolders = this.adaptListenerConfigs(replicatedMapConfig.getListenerConfigs());
        ClientMessage request = DynamicConfigAddReplicatedMapConfigCodec.encodeRequest((String)replicatedMapConfig.getName(), (String)replicatedMapConfig.getInMemoryFormat().name(), (boolean)replicatedMapConfig.isAsyncFillup(), (boolean)replicatedMapConfig.isStatisticsEnabled(), (String)replicatedMapConfig.getMergePolicy(), listenerConfigHolders);
        this.invoke(request);
        return this;
    }

    public Config addRingBufferConfig(RingbufferConfig ringbufferConfig) {
        RingbufferStoreConfigHolder ringbufferStoreConfig = null;
        if (ringbufferConfig.getRingbufferStoreConfig() != null && ringbufferConfig.getRingbufferStoreConfig().isEnabled()) {
            RingbufferStoreConfig storeConfig = ringbufferConfig.getRingbufferStoreConfig();
            ringbufferStoreConfig = RingbufferStoreConfigHolder.of((RingbufferStoreConfig)storeConfig, (SerializationService)this.instance.getSerializationService());
        }
        ClientMessage request = DynamicConfigAddRingbufferConfigCodec.encodeRequest((String)ringbufferConfig.getName(), (int)ringbufferConfig.getCapacity(), (int)ringbufferConfig.getBackupCount(), (int)ringbufferConfig.getAsyncBackupCount(), (int)ringbufferConfig.getTimeToLiveSeconds(), (String)ringbufferConfig.getInMemoryFormat().name(), (RingbufferStoreConfigHolder)ringbufferStoreConfig);
        this.invoke(request);
        return this;
    }

    public Config addTopicConfig(TopicConfig topicConfig) {
        List<ListenerConfigHolder> listenerConfigHolders = this.adaptListenerConfigs(topicConfig.getMessageListenerConfigs());
        ClientMessage request = DynamicConfigAddTopicConfigCodec.encodeRequest((String)topicConfig.getName(), (boolean)topicConfig.isGlobalOrderingEnabled(), (boolean)topicConfig.isStatisticsEnabled(), (boolean)topicConfig.isMultiThreadingEnabled(), listenerConfigHolders);
        this.invoke(request);
        return this;
    }

    public Config addReliableTopicConfig(ReliableTopicConfig config) {
        List<ListenerConfigHolder> listenerConfigHolders = this.adaptListenerConfigs(config.getMessageListenerConfigs());
        Data executorData = this.serializationService.toData((Object)config.getExecutor());
        ClientMessage request = DynamicConfigAddReliableTopicConfigCodec.encodeRequest((String)config.getName(), listenerConfigHolders, (int)config.getReadBatchSize(), (boolean)config.isStatisticsEnabled(), (String)config.getTopicOverloadPolicy().name(), (Data)executorData);
        this.invoke(request);
        return this;
    }

    public Config addExecutorConfig(ExecutorConfig executorConfig) {
        ClientMessage request = DynamicConfigAddExecutorConfigCodec.encodeRequest((String)executorConfig.getName(), (int)executorConfig.getPoolSize(), (int)executorConfig.getQueueCapacity(), (boolean)executorConfig.isStatisticsEnabled());
        this.invoke(request);
        return this;
    }

    public Config addDurableExecutorConfig(DurableExecutorConfig durableExecutorConfig) {
        ClientMessage request = DynamicConfigAddDurableExecutorConfigCodec.encodeRequest((String)durableExecutorConfig.getName(), (int)durableExecutorConfig.getPoolSize(), (int)durableExecutorConfig.getDurability(), (int)durableExecutorConfig.getCapacity());
        this.invoke(request);
        return this;
    }

    public Config addScheduledExecutorConfig(ScheduledExecutorConfig scheduledExecutorConfig) {
        ClientMessage request = DynamicConfigAddScheduledExecutorConfigCodec.encodeRequest((String)scheduledExecutorConfig.getName(), (int)scheduledExecutorConfig.getPoolSize(), (int)scheduledExecutorConfig.getDurability(), (int)scheduledExecutorConfig.getCapacity());
        this.invoke(request);
        return this;
    }

    public Config addCardinalityEstimatorConfig(CardinalityEstimatorConfig cardinalityEstimatorConfig) {
        ClientMessage request = DynamicConfigAddCardinalityEstimatorConfigCodec.encodeRequest((String)cardinalityEstimatorConfig.getName(), (int)cardinalityEstimatorConfig.getBackupCount(), (int)cardinalityEstimatorConfig.getAsyncBackupCount());
        this.invoke(request);
        return this;
    }

    public Config addSemaphoreConfig(SemaphoreConfig semaphoreConfig) {
        ClientMessage request = DynamicConfigAddSemaphoreConfigCodec.encodeRequest((String)semaphoreConfig.getName(), (int)semaphoreConfig.getInitialPermits(), (int)semaphoreConfig.getBackupCount(), (int)semaphoreConfig.getAsyncBackupCount());
        this.invoke(request);
        return this;
    }

    public Config addWanReplicationConfig(WanReplicationConfig wanReplicationConfig) {
        return super.addWanReplicationConfig(wanReplicationConfig);
    }

    public Config addJobTrackerConfig(JobTrackerConfig jobTrackerConfig) {
        throw new UnsupportedOperationException("JobTracker is deprecated and will be removed in Hazelcast 4.0");
    }

    public Config addQuorumConfig(QuorumConfig quorumConfig) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config addListenerConfig(ListenerConfig listenerConfig) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config addEventJournalConfig(EventJournalConfig eventJournalConfig) {
        String mapName = eventJournalConfig.getMapName();
        String cacheName = eventJournalConfig.getCacheName();
        if (StringUtil.isNullOrEmpty((String)mapName) && StringUtil.isNullOrEmpty((String)cacheName)) {
            throw new IllegalArgumentException("Event journal config should have non-empty map name and/or cache name");
        }
        ClientMessage request = DynamicConfigAddEventJournalConfigCodec.encodeRequest((String)eventJournalConfig.getMapName(), (String)eventJournalConfig.getCacheName(), (boolean)eventJournalConfig.isEnabled(), (int)eventJournalConfig.getCapacity(), (int)eventJournalConfig.getTimeToLiveSeconds());
        this.invoke(request);
        return this;
    }

    public ClassLoader getClassLoader() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setClassLoader(ClassLoader classLoader) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public ConfigPatternMatcher getConfigPatternMatcher() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public void setConfigPatternMatcher(ConfigPatternMatcher configPatternMatcher) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public String getProperty(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setProperty(String name, String value) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public MemberAttributeConfig getMemberAttributeConfig() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public void setMemberAttributeConfig(MemberAttributeConfig memberAttributeConfig) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Properties getProperties() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setProperties(Properties properties) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public String getInstanceName() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setInstanceName(String instanceName) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public GroupConfig getGroupConfig() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setGroupConfig(GroupConfig groupConfig) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public NetworkConfig getNetworkConfig() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setNetworkConfig(NetworkConfig networkConfig) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public MapConfig findMapConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public MapConfig getMapConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Map<String, MapConfig> getMapConfigs() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setMapConfigs(Map<String, MapConfig> mapConfigs) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public CacheSimpleConfig findCacheConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public CacheSimpleConfig getCacheConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Map<String, CacheSimpleConfig> getCacheConfigs() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setCacheConfigs(Map<String, CacheSimpleConfig> cacheConfigs) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public QueueConfig findQueueConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public QueueConfig getQueueConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Map<String, QueueConfig> getQueueConfigs() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setQueueConfigs(Map<String, QueueConfig> queueConfigs) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public LockConfig findLockConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public LockConfig getLockConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Map<String, LockConfig> getLockConfigs() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setLockConfigs(Map<String, LockConfig> lockConfigs) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public ListConfig findListConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public ListConfig getListConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Map<String, ListConfig> getListConfigs() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setListConfigs(Map<String, ListConfig> listConfigs) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public SetConfig findSetConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public SetConfig getSetConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Map<String, SetConfig> getSetConfigs() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setSetConfigs(Map<String, SetConfig> setConfigs) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public MultiMapConfig findMultiMapConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public MultiMapConfig getMultiMapConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Map<String, MultiMapConfig> getMultiMapConfigs() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setMultiMapConfigs(Map<String, MultiMapConfig> multiMapConfigs) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public ReplicatedMapConfig findReplicatedMapConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public ReplicatedMapConfig getReplicatedMapConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Map<String, ReplicatedMapConfig> getReplicatedMapConfigs() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setReplicatedMapConfigs(Map<String, ReplicatedMapConfig> replicatedMapConfigs) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public RingbufferConfig findRingbufferConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public RingbufferConfig getRingbufferConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Map<String, RingbufferConfig> getRingbufferConfigs() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setRingbufferConfigs(Map<String, RingbufferConfig> ringbufferConfigs) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public TopicConfig findTopicConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public TopicConfig getTopicConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public ReliableTopicConfig findReliableTopicConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public ReliableTopicConfig getReliableTopicConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Map<String, ReliableTopicConfig> getReliableTopicConfigs() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setReliableTopicConfigs(Map<String, ReliableTopicConfig> reliableTopicConfigs) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Map<String, TopicConfig> getTopicConfigs() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setTopicConfigs(Map<String, TopicConfig> mapTopicConfigs) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public ExecutorConfig findExecutorConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public DurableExecutorConfig findDurableExecutorConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public ScheduledExecutorConfig findScheduledExecutorConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public CardinalityEstimatorConfig findCardinalityEstimatorConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public ExecutorConfig getExecutorConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public DurableExecutorConfig getDurableExecutorConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public ScheduledExecutorConfig getScheduledExecutorConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public CardinalityEstimatorConfig getCardinalityEstimatorConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Map<String, ExecutorConfig> getExecutorConfigs() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setExecutorConfigs(Map<String, ExecutorConfig> executorConfigs) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Map<String, DurableExecutorConfig> getDurableExecutorConfigs() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setDurableExecutorConfigs(Map<String, DurableExecutorConfig> durableExecutorConfigs) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Map<String, ScheduledExecutorConfig> getScheduledExecutorConfigs() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setScheduledExecutorConfigs(Map<String, ScheduledExecutorConfig> scheduledExecutorConfigs) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Map<String, CardinalityEstimatorConfig> getCardinalityEstimatorConfigs() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setCardinalityEstimatorConfigs(Map<String, CardinalityEstimatorConfig> cardinalityEstimatorConfigs) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public SemaphoreConfig findSemaphoreConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public SemaphoreConfig getSemaphoreConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Collection<SemaphoreConfig> getSemaphoreConfigs() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setSemaphoreConfigs(Map<String, SemaphoreConfig> semaphoreConfigs) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public WanReplicationConfig getWanReplicationConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Map<String, WanReplicationConfig> getWanReplicationConfigs() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setWanReplicationConfigs(Map<String, WanReplicationConfig> wanReplicationConfigs) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public JobTrackerConfig findJobTrackerConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public JobTrackerConfig getJobTrackerConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Map<String, JobTrackerConfig> getJobTrackerConfigs() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setJobTrackerConfigs(Map<String, JobTrackerConfig> jobTrackerConfigs) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Map<String, QuorumConfig> getQuorumConfigs() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public QuorumConfig getQuorumConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public QuorumConfig findQuorumConfig(String name) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setQuorumConfigs(Map<String, QuorumConfig> quorumConfigs) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public ManagementCenterConfig getManagementCenterConfig() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setManagementCenterConfig(ManagementCenterConfig managementCenterConfig) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public ServicesConfig getServicesConfig() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setServicesConfig(ServicesConfig servicesConfig) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public SecurityConfig getSecurityConfig() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setSecurityConfig(SecurityConfig securityConfig) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public List<ListenerConfig> getListenerConfigs() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setListenerConfigs(List<ListenerConfig> listenerConfigs) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public SerializationConfig getSerializationConfig() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setSerializationConfig(SerializationConfig serializationConfig) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public PartitionGroupConfig getPartitionGroupConfig() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setPartitionGroupConfig(PartitionGroupConfig partitionGroupConfig) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public HotRestartPersistenceConfig getHotRestartPersistenceConfig() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setHotRestartPersistenceConfig(HotRestartPersistenceConfig hrConfig) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public ManagedContext getManagedContext() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setManagedContext(ManagedContext managedContext) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public ConcurrentMap<String, Object> getUserContext() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setUserContext(ConcurrentMap<String, Object> userContext) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public NativeMemoryConfig getNativeMemoryConfig() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setNativeMemoryConfig(NativeMemoryConfig nativeMemoryConfig) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public URL getConfigurationUrl() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setConfigurationUrl(URL configurationUrl) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public File getConfigurationFile() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setConfigurationFile(File configurationFile) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public String getLicenseKey() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setLicenseKey(String licenseKey) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public boolean isLiteMember() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setLiteMember(boolean liteMember) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public UserCodeDeploymentConfig getUserCodeDeploymentConfig() {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public Config setUserCodeDeploymentConfig(UserCodeDeploymentConfig userCodeDeploymentConfig) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    public String toString() {
        return "DynamicClusterConfig{instance=" + this.instance + "}";
    }

    private void invoke(ClientMessage request) {
        try {
            ClientInvocation invocation = new ClientInvocation(this.instance, request, null);
            ClientInvocationFuture future = invocation.invoke();
            future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private List<ListenerConfigHolder> adaptListenerConfigs(List<? extends ListenerConfig> listenerConfigs) {
        ArrayList<ListenerConfigHolder> listenerConfigHolders = null;
        if (listenerConfigs != null && !listenerConfigs.isEmpty()) {
            listenerConfigHolders = new ArrayList<ListenerConfigHolder>();
            for (ListenerConfig listenerConfig : listenerConfigs) {
                listenerConfigHolders.add(ListenerConfigHolder.of((ListenerConfig)listenerConfig, (SerializationService)this.serializationService));
            }
        }
        return listenerConfigHolders;
    }
}

