/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.codec.impl;

import com.helger.base.codec.IEncoder;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHex;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class RFC5987Codec
implements IEncoder<String, String> {
    public static final char ESCAPE_CHAR = '%';
    private static final byte[] ALLOWED_BYTES = new byte[]{33, 35, 36, 38, 43, 45, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 124, 126};
    private final Charset m_aCharset;

    public RFC5987Codec() {
        this(StandardCharsets.UTF_8);
    }

    public RFC5987Codec(@Nonnull Charset charset) {
        this.m_aCharset = ValueEnforcer.notNull(charset, "Charset");
    }

    @Nonnull
    public static String getRFC5987Encoded(@Nonnull String string, @Nonnull Charset charset) {
        ValueEnforcer.notNull(string, "Src");
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        for (byte by : string.getBytes(charset)) {
            if (Arrays.binarySearch(ALLOWED_BYTES, by) >= 0) {
                stringBuilder.append((char)by);
                continue;
            }
            stringBuilder.append('%').append(StringHex.getHexChar(by >> 4 & 0xF)).append(StringHex.getHexChar(by & 0xF));
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static String getRFC5987EncodedUTF8(@Nonnull String string) {
        return RFC5987Codec.getRFC5987Encoded(string, StandardCharsets.UTF_8);
    }

    @Override
    @Nullable
    public String getEncoded(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return RFC5987Codec.getRFC5987Encoded(string, this.m_aCharset);
    }
}

