/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.string;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import jakarta.annotation.Nonnull;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;

@Immutable
public final class StringEncoding {
    private StringEncoding() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] encodeCharToBytes(@Nonnull char[] cArray, @Nonnull Charset charset) {
        return StringEncoding.encodeCharToBytes(cArray, 0, cArray.length, charset);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] encodeCharToBytes(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull Charset charset) {
        ValueEnforcer.isArrayOfsLen(cArray, n, n2);
        CharsetEncoder charsetEncoder = charset.newEncoder();
        int n3 = (int)((double)n2 * (double)charsetEncoder.maxBytesPerChar());
        byte[] byArray = new byte[n3];
        if (n2 == 0) {
            return byArray;
        }
        charsetEncoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).reset();
        CharBuffer charBuffer = CharBuffer.wrap(cArray, n, n2);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        try {
            CoderResult coderResult = charsetEncoder.encode(charBuffer, byteBuffer, true);
            if (!coderResult.isUnderflow()) {
                coderResult.throwException();
            }
            if (!(coderResult = charsetEncoder.flush(byteBuffer)).isUnderflow()) {
                coderResult.throwException();
            }
        }
        catch (CharacterCodingException characterCodingException) {
            throw new IllegalStateException(characterCodingException);
        }
        int n4 = byteBuffer.position();
        if (n4 == byArray.length) {
            return byArray;
        }
        return Arrays.copyOf(byArray, n4);
    }

    @Nonnull
    public static char[] decodeBytesToChars(@Nonnull byte[] byArray, @Nonnull Charset charset) {
        return StringEncoding.decodeBytesToChars(byArray, 0, byArray.length, charset);
    }

    @Nonnull
    public static char[] decodeBytesToChars(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull Charset charset) {
        CharsetDecoder charsetDecoder = charset.newDecoder();
        int n3 = (int)((double)n2 * (double)charsetDecoder.maxCharsPerByte());
        char[] cArray = new char[n3];
        if (n2 == 0) {
            return cArray;
        }
        charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).reset();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        try {
            CoderResult coderResult = charsetDecoder.decode(byteBuffer, charBuffer, true);
            if (!coderResult.isUnderflow()) {
                coderResult.throwException();
            }
            if (!(coderResult = charsetDecoder.flush(charBuffer)).isUnderflow()) {
                coderResult.throwException();
            }
        }
        catch (CharacterCodingException characterCodingException) {
            throw new IllegalStateException(characterCodingException);
        }
        int n4 = charBuffer.position();
        if (n4 == cArray.length) {
            return cArray;
        }
        return Arrays.copyOf(cArray, n4);
    }
}

