/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.resourcebundle;

import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.classloader.ClassLoaderHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.stream.StreamHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.io.resource.URLResource;
import com.helger.xml.resourcebundle.XMLResourceBundle;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public final class XMLResourceBundleControl
extends ResourceBundle.Control {
    private static final String FORMAT_XML = "xml";
    private static final ICommonsList<String> FORMATS = new CommonsArrayList((Object)"xml");

    @Override
    @ReturnsMutableCopy
    @CodingStyleguideUnaware
    public List<String> getFormats(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"BaseName");
        return (List)FORMATS.getClone();
    }

    @Override
    public ResourceBundle newBundle(@Nonnull String string, @Nonnull Locale locale, @Nonnull String string2, @Nonnull ClassLoader classLoader, boolean bl) throws IOException {
        String string3;
        String string4;
        URL uRL;
        ValueEnforcer.notNull((Object)string, (String)"BaseName");
        ValueEnforcer.notNull((Object)locale, (String)"Locale");
        ValueEnforcer.notNull((Object)string2, (String)"Format");
        ValueEnforcer.notNull((Object)classLoader, (String)"ClassLoader");
        if (string2.equals(FORMAT_XML) && (uRL = ClassLoaderHelper.getResource((ClassLoader)classLoader, (String)(string4 = this.toResourceName(string3 = this.toBundleName(string, locale), string2)))) != null) {
            try (InputStream inputStream = URLResource.getInputStream((URL)uRL);){
                XMLResourceBundle xMLResourceBundle;
                block13: {
                    InputStream inputStream2 = StreamHelper.getBuffered((InputStream)inputStream);
                    try {
                        xMLResourceBundle = new XMLResourceBundle(inputStream2);
                        if (inputStream2 == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (inputStream2 != null) {
                            try {
                                inputStream2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    inputStream2.close();
                }
                return xMLResourceBundle;
            }
        }
        return null;
    }
}

