/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.sax;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.diagnostics.error.level.IErrorLevel;
import com.helger.diagnostics.log.LogHelper;
import com.helger.xml.sax.AbstractSAXErrorHandler;
import jakarta.annotation.Nonnull;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXParseException;

@Immutable
public class LoggingSAXErrorHandler
extends AbstractSAXErrorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingSAXErrorHandler.class);

    @Nonnull
    @Nonempty
    @OverrideOnDemand
    protected String getErrorMessage(@Nonnull IErrorLevel iErrorLevel, SAXParseException sAXParseException) {
        return LoggingSAXErrorHandler.getSaxParseError(iErrorLevel, sAXParseException).getAsString(Locale.ROOT);
    }

    @Override
    protected void internalLog(@Nonnull IErrorLevel iErrorLevel, SAXParseException sAXParseException) {
        LogHelper.log((Logger)LOGGER, (IErrorLevel)iErrorLevel, (String)this.getErrorMessage(iErrorLevel, sAXParseException));
    }
}

