/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.serialize.write;

import com.helger.annotation.WillClose;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.nonblocking.NonBlockingByteArrayOutputStream;
import com.helger.base.io.nonblocking.NonBlockingStringWriter;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.state.ESuccess;
import com.helger.statistics.api.IMutableStatisticsHandlerSize;
import com.helger.statistics.impl.StatisticsManager;
import com.helger.xml.EXMLVersion;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLSerializer;
import com.helger.xml.serialize.write.XMLWriterSettings;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.namespace.NamespaceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

@Immutable
public final class XMLWriter {
    public static final EXMLVersion DEFAULT_XML_VERSION = EXMLVersion.XML_10;
    public static final NamespaceContext DEFAULT_NAMESPACE_CTX = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLWriter.class);
    private static final IMutableStatisticsHandlerSize STATS_SIZE = StatisticsManager.getSizeHandler(XMLWriter.class);
    private static final XMLWriter INSTANCE = new XMLWriter();

    private XMLWriter() {
    }

    @Nonnull
    public static ESuccess writeToStream(@Nonnull Node node, @Nonnull @WillClose OutputStream outputStream) {
        return XMLWriter.writeToStream(node, outputStream, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess writeToStream(@Nonnull Node node, @Nonnull @WillClose OutputStream outputStream, @Nonnull IXMLWriterSettings iXMLWriterSettings) {
        ValueEnforcer.notNull((Object)node, (String)"Node");
        ValueEnforcer.notNull((Object)outputStream, (String)"OutputStream");
        ValueEnforcer.notNull((Object)iXMLWriterSettings, (String)"Settings");
        try {
            XMLSerializer xMLSerializer = new XMLSerializer(iXMLWriterSettings);
            xMLSerializer.write(node, outputStream);
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        catch (RuntimeException runtimeException) {
            LOGGER.error("Error in XML serialization", (Throwable)runtimeException);
            throw runtimeException;
        }
        catch (Exception exception) {
            LOGGER.error("Error in XML serialization", (Throwable)exception);
        }
        finally {
            StreamHelper.close((AutoCloseable)outputStream);
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public static ESuccess writeToWriter(@Nonnull Node node, @Nonnull @WillClose Writer writer) {
        return XMLWriter.writeToWriter(node, writer, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess writeToWriter(@Nonnull Node node, @Nonnull @WillClose Writer writer, @Nonnull IXMLWriterSettings iXMLWriterSettings) {
        ValueEnforcer.notNull((Object)node, (String)"Node");
        ValueEnforcer.notNull((Object)writer, (String)"Writer");
        ValueEnforcer.notNull((Object)iXMLWriterSettings, (String)"Settings");
        try {
            XMLSerializer xMLSerializer = new XMLSerializer(iXMLWriterSettings);
            xMLSerializer.write(node, writer);
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        catch (RuntimeException runtimeException) {
            LOGGER.error("Error in XML serialization", (Throwable)runtimeException);
            throw runtimeException;
        }
        catch (Exception exception) {
            LOGGER.error("Error in XML serialization", (Throwable)exception);
        }
        finally {
            StreamHelper.close((AutoCloseable)writer);
        }
        return ESuccess.FAILURE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String getNodeAsString(@Nonnull Node node, @Nonnull IXMLWriterSettings iXMLWriterSettings) {
        try (NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter(51200);){
            if (!XMLWriter.writeToWriter(node, (Writer)nonBlockingStringWriter, iXMLWriterSettings).isSuccess()) return null;
            STATS_SIZE.addSize((long)nonBlockingStringWriter.size());
            String string = nonBlockingStringWriter.getAsString();
            return string;
        }
        catch (Exception exception) {
            LOGGER.error("Error serializing DOM node with settings " + iXMLWriterSettings.toString(), (Throwable)exception);
        }
        return null;
    }

    @Nullable
    public static String getNodeAsString(@Nonnull Node node) {
        return XMLWriter.getNodeAsString(node, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static byte[] getNodeAsBytes(@Nonnull Node node, @Nonnull IXMLWriterSettings iXMLWriterSettings) {
        ValueEnforcer.notNull((Object)node, (String)"Node");
        ValueEnforcer.notNull((Object)iXMLWriterSettings, (String)"Settings");
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(51200);){
            if (!XMLWriter.writeToStream(node, (OutputStream)nonBlockingByteArrayOutputStream, iXMLWriterSettings).isSuccess()) return null;
            byte[] byArray = nonBlockingByteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception exception) {
            LOGGER.error("Error serializing DOM node with settings " + iXMLWriterSettings.toString(), (Throwable)exception);
        }
        return null;
    }

    @Nullable
    public static byte[] getNodeAsBytes(@Nonnull Node node) {
        return XMLWriter.getNodeAsBytes(node, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }
}

