/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.transform;

import com.helger.annotation.WillNotClose;
import com.helger.annotation.concurrent.Immutable;
import com.helger.io.resource.IWritableResource;
import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.Path;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.w3c.dom.Node;

@Immutable
public final class TransformResultFactory {
    private static final TransformResultFactory INSTANCE = new TransformResultFactory();

    private TransformResultFactory() {
    }

    public static @NonNull StreamResult create(@NonNull File file) {
        return new StreamResult(file);
    }

    public static @NonNull StreamResult create(@NonNull Path path) {
        return new StreamResult(path.toFile());
    }

    public static @NonNull StreamResult create(@NonNull IWritableResource iWritableResource) {
        return new StreamResult(iWritableResource.getAsFile());
    }

    public static @NonNull StreamResult create(@WillNotClose @Nullable OutputStream outputStream) {
        return new StreamResult(outputStream);
    }

    public static @NonNull StreamResult create(@WillNotClose @Nullable Writer writer) {
        return new StreamResult(writer);
    }

    public static @NonNull DOMResult create(@Nullable Node node) {
        return new DOMResult(node);
    }
}

