/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.xpath;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.classloader.ClassLoaderHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.xml.EXMLParserFeature;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public final class XPathHelper {
    private static final XPathFactory XPATH_FACTORY = XPathFactory.newInstance();
    private static final XPathHelper INSTANCE;

    private XPathHelper() {
    }

    public static @NonNull XPathFactory getDefaultXPathFactory() {
        return XPATH_FACTORY;
    }

    public static @NonNull XPathFactory createXPathFactorySaxonFirst() {
        XPathFactory xPathFactory;
        try {
            xPathFactory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom", "net.sf.saxon.xpath.XPathFactoryImpl", ClassLoaderHelper.getContextClassLoader());
        }
        catch (Exception exception) {
            try {
                xPathFactory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
            }
            catch (Exception exception2) {
                throw new IllegalStateException("Failed to create JAXP XPathFactory", exception2);
            }
        }
        EXMLParserFeature.SECURE_PROCESSING.applyTo(xPathFactory, true);
        return xPathFactory;
    }

    public static @NonNull XPath createNewXPath() {
        return XPathHelper.createNewXPath(XPATH_FACTORY, null, null, null);
    }

    public static @NonNull XPath createNewXPath(@NonNull XPathFactory xPathFactory) {
        return XPathHelper.createNewXPath(xPathFactory, null, null, null);
    }

    public static @NonNull XPath createNewXPath(@Nullable XPathVariableResolver xPathVariableResolver) {
        return XPathHelper.createNewXPath(XPATH_FACTORY, xPathVariableResolver, null, null);
    }

    public static @NonNull XPath createNewXPath(@NonNull XPathFactory xPathFactory, @Nullable XPathVariableResolver xPathVariableResolver) {
        return XPathHelper.createNewXPath(xPathFactory, xPathVariableResolver, null, null);
    }

    public static @NonNull XPath createNewXPath(@Nullable XPathFunctionResolver xPathFunctionResolver) {
        return XPathHelper.createNewXPath(XPATH_FACTORY, null, xPathFunctionResolver, null);
    }

    public static @NonNull XPath createNewXPath(@NonNull XPathFactory xPathFactory, @Nullable XPathFunctionResolver xPathFunctionResolver) {
        return XPathHelper.createNewXPath(xPathFactory, null, xPathFunctionResolver, null);
    }

    public static @NonNull XPath createNewXPath(@Nullable NamespaceContext namespaceContext) {
        return XPathHelper.createNewXPath(XPATH_FACTORY, null, null, namespaceContext);
    }

    public static @NonNull XPath createNewXPath(@NonNull XPathFactory xPathFactory, @Nullable NamespaceContext namespaceContext) {
        return XPathHelper.createNewXPath(xPathFactory, null, null, namespaceContext);
    }

    public static @NonNull XPath createNewXPath(@Nullable XPathVariableResolver xPathVariableResolver, @Nullable NamespaceContext namespaceContext) {
        return XPathHelper.createNewXPath(XPATH_FACTORY, xPathVariableResolver, null, namespaceContext);
    }

    public static @NonNull XPath createNewXPath(@Nullable XPathVariableResolver xPathVariableResolver, @Nullable XPathFunctionResolver xPathFunctionResolver, @Nullable NamespaceContext namespaceContext) {
        return XPathHelper.createNewXPath(XPATH_FACTORY, xPathVariableResolver, xPathFunctionResolver, namespaceContext);
    }

    public static @NonNull XPath createNewXPath(@NonNull XPathFactory xPathFactory, @Nullable XPathVariableResolver xPathVariableResolver, @Nullable XPathFunctionResolver xPathFunctionResolver, @Nullable NamespaceContext namespaceContext) {
        ValueEnforcer.notNull((Object)xPathFactory, (String)"XPathFactory");
        XPath xPath = xPathFactory.newXPath();
        if (xPathVariableResolver != null) {
            xPath.setXPathVariableResolver(xPathVariableResolver);
        }
        if (xPathFunctionResolver != null) {
            xPath.setXPathFunctionResolver(xPathFunctionResolver);
        }
        if (namespaceContext != null) {
            xPath.setNamespaceContext(namespaceContext);
        }
        return xPath;
    }

    public static @NonNull XPathExpression createNewXPathExpression(@Nullable XPathVariableResolver xPathVariableResolver, @Nullable XPathFunctionResolver xPathFunctionResolver, @Nullable NamespaceContext namespaceContext, @Nonempty @NonNull String string) {
        return XPathHelper.createNewXPathExpression(XPathHelper.createNewXPath(xPathVariableResolver, xPathFunctionResolver, namespaceContext), string);
    }

    public static @NonNull XPathExpression createNewXPathExpression(@Nullable XPathVariableResolver xPathVariableResolver, @Nonempty @NonNull String string) {
        return XPathHelper.createNewXPathExpression(XPathHelper.createNewXPath(xPathVariableResolver), string);
    }

    public static @NonNull XPathExpression createNewXPathExpression(@Nullable XPathFunctionResolver xPathFunctionResolver, @Nonempty @NonNull String string) {
        return XPathHelper.createNewXPathExpression(XPathHelper.createNewXPath(xPathFunctionResolver), string);
    }

    public static @NonNull XPathExpression createNewXPathExpression(@Nullable NamespaceContext namespaceContext, @Nonempty @NonNull String string) {
        return XPathHelper.createNewXPathExpression(XPathHelper.createNewXPath(namespaceContext), string);
    }

    public static @NonNull XPathExpression createNewXPathExpression(@Nonempty @NonNull String string) {
        return XPathHelper.createNewXPathExpression(XPathHelper.createNewXPath(), string);
    }

    public static @NonNull XPathExpression createNewXPathExpression(@NonNull XPath xPath, @Nonempty @NonNull String string) {
        ValueEnforcer.notNull((Object)xPath, (String)"XPath");
        ValueEnforcer.notNull((Object)string, (String)"XPathExpression");
        try {
            return xPath.compile(string);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new IllegalArgumentException("Failed to compile XPath expression '" + string + "'", xPathExpressionException);
        }
    }

    static {
        EXMLParserFeature.SECURE_PROCESSING.applyTo(XPATH_FACTORY, true);
        INSTANCE = new XPathHelper();
    }
}

