/*
 * Decompiled with CFR 0.152.
 */
package com.helger.diver.api.settings;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.cache.regex.RegExHelper;
import com.helger.diver.api.settings.DVRGlobalCoordinateSettings;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@Immutable
public final class DVRValidityHelper {
    private DVRValidityHelper() {
    }

    private static boolean _isValidPart(@Nonnull String string, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isTrue(() -> n <= n2, () -> "Min length (" + n + ") must be <= Max length (" + n2 + ")");
        return RegExHelper.stringMatchesPattern((String)("[a-zA-Z0-9_\\-\\.]{" + n + "," + n2 + "}"), (String)string);
    }

    public static boolean isValidCoordinateGroupID(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return false;
        }
        return DVRValidityHelper._isValidPart(string, DVRGlobalCoordinateSettings.getGroupIDMinLen(), DVRGlobalCoordinateSettings.getGroupIDMaxLen());
    }

    public static boolean isValidCoordinateArtifactID(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return false;
        }
        return DVRValidityHelper._isValidPart(string, DVRGlobalCoordinateSettings.getArtifactIDMinLen(), DVRGlobalCoordinateSettings.getArtifactIDMaxLen());
    }

    public static boolean isValidCoordinateVersion(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return false;
        }
        return DVRValidityHelper._isValidPart(string, DVRGlobalCoordinateSettings.getVersionMinLen(), DVRGlobalCoordinateSettings.getVersionMaxLen());
    }

    public static boolean isValidCoordinateClassifier(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return true;
        }
        return DVRValidityHelper._isValidPart(string, DVRGlobalCoordinateSettings.getClassifierMinLen(), DVRGlobalCoordinateSettings.getClassifierMaxLen());
    }
}

