/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.ean;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EValidity;
import com.helger.base.string.StringHelper;
import com.helger.masterdata.ean.AbstractUPCEAN;
import com.helger.masterdata.ean.EEANChecksumMode;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public final class UPCA
extends AbstractUPCEAN {
    public UPCA(@Nonnull String string) {
        this(string, DEFAULT_CHECKSUM_MODE);
    }

    public UPCA(@Nonnull String string, @Nonnull EEANChecksumMode eEANChecksumMode) {
        super(string, eEANChecksumMode);
    }

    @Override
    @Nonnull
    public EValidity validate() {
        return UPCA.validateMessage(this.getMessage());
    }

    @Nonnull
    public static EValidity validateMessage(@Nullable String string) {
        int n = StringHelper.getLength((CharSequence)string);
        if (n >= 11 && n <= 12 && AbstractUPCEAN.validateMessage(string).isValid()) {
            return EValidity.VALID;
        }
        return EValidity.INVALID;
    }

    public static String handleChecksum(@Nonnull String string, @Nonnull EEANChecksumMode eEANChecksumMode) {
        ValueEnforcer.notNull((Object)string, (String)"Msg");
        ValueEnforcer.notNull((Object)((Object)eEANChecksumMode), (String)"ChecksumMode");
        EEANChecksumMode eEANChecksumMode2 = eEANChecksumMode;
        if (eEANChecksumMode2 == EEANChecksumMode.AUTO) {
            if (string.length() == 11) {
                eEANChecksumMode2 = EEANChecksumMode.ADD;
            } else if (string.length() == 12) {
                eEANChecksumMode2 = EEANChecksumMode.CHECK;
            } else {
                throw new IllegalArgumentException("Failed to automatically detect the checksum mode");
            }
        }
        switch (eEANChecksumMode2) {
            case ADD: {
                if (string.length() != 11) {
                    throw new IllegalArgumentException("Message must be 11 characters long");
                }
                return string + UPCA.calcChecksumChar(string, 11);
            }
            case CHECK: {
                char c;
                if (string.length() != 12) {
                    throw new IllegalArgumentException("Message must be 12 characters long");
                }
                char c2 = string.charAt(11);
                if (c2 != (c = UPCA.calcChecksumChar(string, 11))) {
                    throw new IllegalArgumentException("Checksum is bad (" + c2 + "). Expected: " + c);
                }
                return string;
            }
            case IGNORE: {
                return string;
            }
        }
        throw new IllegalArgumentException("Unknown checksum mode: " + String.valueOf((Object)eEANChecksumMode2));
    }
}

