/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.postal;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.masterdata.postal.IPostalCodeCountry;
import com.helger.masterdata.postal.PostalCodeFormat;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;

@NotThreadSafe
public class PostalCodeCountry
implements IPostalCodeCountry,
Serializable {
    private final String m_sISO;
    private final ICommonsList<PostalCodeFormat> m_aFormats = new CommonsArrayList();
    private final ICommonsList<String> m_aSpecificPostalCodes = new CommonsArrayList();
    private String m_sNote;

    public PostalCodeCountry(@Nonnull @Nonempty String string) {
        this.m_sISO = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"ISO");
    }

    @Override
    @Nonnull
    @Nonempty
    public String getISO() {
        return this.m_sISO;
    }

    void addFormat(@Nonnull PostalCodeFormat postalCodeFormat) {
        ValueEnforcer.notNull((Object)postalCodeFormat, (String)"Format");
        this.m_aFormats.add((Object)postalCodeFormat);
    }

    @Override
    @Nonnegative
    public int getFormatCount() {
        return this.m_aFormats.size();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PostalCodeFormat> getAllFormats() {
        return (ICommonsList)this.m_aFormats.getClone();
    }

    @Override
    @Nullable
    public PostalCodeFormat getFormatOfIndex(int n) {
        return (PostalCodeFormat)this.m_aFormats.getAtIndex(n);
    }

    void addSpecificPostalCode(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"SpecificPostalCode");
        ValueEnforcer.isTrue((boolean)this.isValidPostalCode(string), () -> "The passed code '" + string + "' is not valid according to the rules!");
        this.m_aSpecificPostalCodes.add((Object)string);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllSpecificPostalCodes() {
        return (ICommonsList)this.m_aSpecificPostalCodes.getClone();
    }

    @Override
    @Nonnegative
    public int getSpecificPostalCodeCount() {
        return this.m_aSpecificPostalCodes.size();
    }

    void setNote(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Note");
        this.m_sNote = string;
    }

    @Override
    @Nullable
    public String getNote() {
        return this.m_sNote;
    }

    @Override
    public boolean isValidPostalCode(@Nullable String string) {
        if (StringHelper.isNotEmpty((String)string)) {
            for (PostalCodeFormat postalCodeFormat : this.m_aFormats) {
                if (!postalCodeFormat.isValidPostalCode(string)) continue;
                return true;
            }
        }
        return this.m_aFormats.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllExamples() {
        return this.m_aFormats.getAllMapped(PostalCodeFormat::getExample);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ISO", (Object)this.m_sISO).append("formats", this.m_aFormats).append("specificPostalCodes", this.m_aSpecificPostalCodes).appendIfNotNull("note", (Object)this.m_sNote).getToString();
    }
}

