/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tenancy.accarea;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.masterdata.address.IPostalAddress;
import com.helger.masterdata.address.PostalAddress;
import com.helger.masterdata.currency.ECurrency;
import com.helger.tenancy.IBusinessObject;
import com.helger.tenancy.accarea.IAccountingArea;
import com.helger.tenancy.tenant.AbstractTenantObject;
import com.helger.tenancy.tenant.ITenant;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

@NotThreadSafe
public abstract class AbstractAccountingArea
extends AbstractTenantObject
implements IAccountingArea {
    private String m_sDisplayName;
    private String m_sCompanyType;
    private String m_sCompanyVATIN;
    private String m_sCompanyNumber;
    private String m_sCustomerNumber;
    private PostalAddress m_aAddress;
    private String m_sTelephone;
    private String m_sFax;
    private String m_sEmailAddress;
    private String m_sWebSite;
    private ECurrency m_eDefaultCurrency;
    private String m_sOfficeLocation;
    private String m_sCommercialRegistrationNumber;
    private String m_sCommercialCourt;

    protected AbstractAccountingArea(@Nonnull ITenant iTenant, @Nonnull IBusinessObject iBusinessObject, @Nonnull @Nonempty String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nonnull IPostalAddress iPostalAddress, @Nullable String string6, @Nullable String string7, @Nullable String string8, @Nullable String string9, @Nullable ECurrency eCurrency, @Nullable String string10, @Nullable String string11, @Nullable String string12, @Nonnull Locale locale) {
        super(iTenant, iBusinessObject);
        this.setDisplayName(string);
        this.setCompanyType(string2);
        this.setCompanyVATIN(string3);
        this.setCompanyNumber(string4);
        this.setCustomerNumber(string5);
        this.setAddress(iPostalAddress, locale);
        this.setTelephone(string6);
        this.setFax(string7);
        this.setEmailAddress(string8);
        this.setWebSite(string9);
        this.setDefaultCurrency(eCurrency);
        this.setOfficeLocation(string10);
        this.setCommercialRegistrationNumber(string11);
        this.setCommercialCourt(string12);
    }

    @Nonnull
    @Nonempty
    public String getDisplayName() {
        return this.m_sDisplayName;
    }

    @Nonnull
    public EChange setDisplayName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"DisplayName");
        if (string.equals(this.m_sDisplayName)) {
            return EChange.UNCHANGED;
        }
        this.m_sDisplayName = string;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getCompanyType() {
        return this.m_sCompanyType;
    }

    @Nonnull
    public EChange setCompanyType(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sCompanyType)) {
            return EChange.UNCHANGED;
        }
        this.m_sCompanyType = string;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getCompanyVATIN() {
        return this.m_sCompanyVATIN;
    }

    @Nonnull
    public EChange setCompanyVATIN(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sCompanyVATIN)) {
            return EChange.UNCHANGED;
        }
        this.m_sCompanyVATIN = string;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getCompanyNumber() {
        return this.m_sCompanyNumber;
    }

    @Nonnull
    public EChange setCompanyNumber(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sCompanyNumber)) {
            return EChange.UNCHANGED;
        }
        this.m_sCompanyNumber = string;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getCustomerNumber() {
        return this.m_sCustomerNumber;
    }

    @Nonnull
    public EChange setCustomerNumber(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sCustomerNumber)) {
            return EChange.UNCHANGED;
        }
        this.m_sCustomerNumber = string;
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public IPostalAddress getAddress() {
        return this.m_aAddress;
    }

    @Nonnull
    public EChange setAddress(@Nonnull IPostalAddress iPostalAddress, @Nonnull Locale locale) {
        ValueEnforcer.notNull((Object)iPostalAddress, (String)"Address");
        PostalAddress postalAddress = new PostalAddress(iPostalAddress, locale);
        if (postalAddress.equals((Object)this.m_aAddress)) {
            return EChange.UNCHANGED;
        }
        this.m_aAddress = postalAddress;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getTelephone() {
        return this.m_sTelephone;
    }

    @Nonnull
    public EChange setTelephone(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sTelephone)) {
            return EChange.UNCHANGED;
        }
        this.m_sTelephone = string;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getFax() {
        return this.m_sFax;
    }

    @Nonnull
    public EChange setFax(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sFax)) {
            return EChange.UNCHANGED;
        }
        this.m_sFax = string;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getEmailAddress() {
        return this.m_sEmailAddress;
    }

    @Nonnull
    public EChange setEmailAddress(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sEmailAddress)) {
            return EChange.UNCHANGED;
        }
        this.m_sEmailAddress = string;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getWebSite() {
        return this.m_sWebSite;
    }

    @Nonnull
    public EChange setWebSite(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sWebSite)) {
            return EChange.UNCHANGED;
        }
        this.m_sWebSite = string;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public ECurrency getDefaultCurrency() {
        return this.m_eDefaultCurrency;
    }

    @Nonnull
    public EChange setDefaultCurrency(@Nullable ECurrency eCurrency) {
        if (EqualsHelper.equals((Object)eCurrency, (Object)this.m_eDefaultCurrency)) {
            return EChange.UNCHANGED;
        }
        this.m_eDefaultCurrency = eCurrency;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getOfficeLocation() {
        return this.m_sOfficeLocation;
    }

    @Nonnull
    public EChange setOfficeLocation(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sOfficeLocation)) {
            return EChange.UNCHANGED;
        }
        this.m_sOfficeLocation = string;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getCommercialRegistrationNumber() {
        return this.m_sCommercialRegistrationNumber;
    }

    @Nonnull
    public EChange setCommercialRegistrationNumber(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sCommercialRegistrationNumber)) {
            return EChange.UNCHANGED;
        }
        this.m_sCommercialRegistrationNumber = string;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getCommercialCourt() {
        return this.m_sCommercialCourt;
    }

    @Nonnull
    public EChange setCommercialCourt(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sCommercialCourt)) {
            return EChange.UNCHANGED;
        }
        this.m_sCommercialCourt = string;
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsUIText(Locale locale) {
        return this.getTenant().getAsUIText(locale) + " - " + this.getDisplayName();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("displayName", (Object)this.m_sDisplayName).appendIfNotNull("companyType", (Object)this.m_sCompanyType).appendIfNotNull("companyVATIN", (Object)this.m_sCompanyVATIN).appendIfNotNull("companyNumber", (Object)this.m_sCompanyNumber).appendIfNotNull("debtorNumber", (Object)this.m_sCustomerNumber).append("address", (Object)this.m_aAddress).appendIfNotNull("telephone", (Object)this.m_sTelephone).appendIfNotNull("fax", (Object)this.m_sFax).appendIfNotNull("emailAddress", (Object)this.m_sEmailAddress).appendIfNotNull("website", (Object)this.m_sWebSite).appendIfNotNull("defaultCurrency", (Object)this.m_eDefaultCurrency).appendIfNotNull("officeLocation", (Object)this.m_sOfficeLocation).appendIfNotNull("commercialRegistrationNumber", (Object)this.m_sCommercialRegistrationNumber).appendIfNotNull("commercialCourt", (Object)this.m_sCommercialCourt).getToString();
    }
}

