/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.reporting.api.backend;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.IsSPIInterface;
import com.helger.base.name.IHasDisplayName;
import com.helger.base.state.ESuccess;
import com.helger.config.IConfig;
import com.helger.peppol.reporting.api.PeppolReportingItem;
import com.helger.peppol.reporting.api.backend.PeppolReportingBackendException;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;

@IsSPIInterface
public interface IPeppolReportingBackendSPI
extends IHasDisplayName {
    @Nonempty
    public @NonNull String getDisplayName();

    public @NonNull ESuccess initBackend(@NonNull IConfig var1);

    public boolean isInitialized();

    public void shutdownBackend();

    public void storeReportingItem(@NonNull PeppolReportingItem var1) throws PeppolReportingBackendException;

    public @NonNull Iterable<PeppolReportingItem> iterateReportingItems(@NonNull LocalDate var1, @NonNull LocalDate var2) throws PeppolReportingBackendException;

    default public @NonNull Iterable<PeppolReportingItem> iterateReportingItems(@NonNull YearMonth yearMonth) throws PeppolReportingBackendException {
        return this.iterateReportingItems(yearMonth.atDay(1), yearMonth.atEndOfMonth());
    }

    default public void forEachReportingItem(@NonNull LocalDate localDate, @NonNull LocalDate localDate2, @NonNull Consumer<? super PeppolReportingItem> consumer) throws PeppolReportingBackendException {
        this.iterateReportingItems(localDate, localDate2).forEach(consumer);
    }

    default public void forEachReportingItem(@NonNull YearMonth yearMonth, @NonNull Consumer<? super PeppolReportingItem> consumer) throws PeppolReportingBackendException {
        this.iterateReportingItems(yearMonth).forEach(consumer);
    }
}

