/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.attachment;

import com.helger.annotation.WillNotClose;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.io.stream.HasInputStream;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.logging.Phase4LoggerFactory;
import com.helger.phase4.util.AS4ResourceHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.wss4j.common.ext.Attachment;
import org.apache.wss4j.common.ext.AttachmentRequestCallback;
import org.apache.wss4j.common.ext.AttachmentResultCallback;
import org.slf4j.Logger;

public class WSS4JAttachmentCallbackHandler
implements CallbackHandler {
    public static final String ATTACHMENT_ID_ATTACHMENTS = "Attachments";
    private static final Logger LOGGER = Phase4LoggerFactory.getLogger(WSS4JAttachmentCallbackHandler.class);
    private final ICommonsOrderedMap<String, WSS4JAttachment> m_aAttachmentMap = new CommonsLinkedHashMap();
    private final AS4ResourceHelper m_aResHelper;

    public WSS4JAttachmentCallbackHandler(@Nullable Iterable<? extends WSS4JAttachment> iterable, @Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper) {
        ValueEnforcer.notNull((Object)aS4ResourceHelper, (String)"ResHelper");
        if (iterable != null) {
            for (WSS4JAttachment wSS4JAttachment : iterable) {
                String string = wSS4JAttachment.getId();
                if (this.m_aAttachmentMap.containsKey((Object)string)) {
                    LOGGER.error("Another attachment with ID '" + string + "' is already contained in the Map. The latter one will override the previous object");
                }
                this.m_aAttachmentMap.put((Object)string, (Object)wSS4JAttachment);
            }
        }
        this.m_aResHelper = aS4ResourceHelper;
    }

    @Nonnull
    public final AS4ResourceHelper getResourceHelper() {
        return this.m_aResHelper;
    }

    @Nonnull
    @ReturnsMutableCopy
    private ICommonsList<Attachment> _getAttachmentsToAdd(@Nullable String string) {
        WSS4JAttachment wSS4JAttachment = (WSS4JAttachment)this.m_aAttachmentMap.get((Object)string);
        if (wSS4JAttachment != null) {
            return new CommonsArrayList((Object)wSS4JAttachment);
        }
        if (ATTACHMENT_ID_ATTACHMENTS.equals(string)) {
            return new CommonsArrayList(this.m_aAttachmentMap.values());
        }
        throw new IllegalStateException("Failed to resolve attachment with ID '" + string + "' in " + String.valueOf(this.m_aAttachmentMap.keySet()));
    }

    @Override
    public void handle(@Nonnull Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbackArray) {
            Object object;
            String string;
            AttachmentRequestCallback attachmentRequestCallback;
            if (callback instanceof AttachmentRequestCallback) {
                attachmentRequestCallback = (AttachmentRequestCallback)callback;
                string = attachmentRequestCallback.getAttachmentId();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Requesting attachment ID '" + string + "'");
                }
                if ((object = this._getAttachmentsToAdd(string)).isEmpty()) {
                    throw new IllegalStateException("No attachments present for ID '" + string + "' in " + String.valueOf(this.m_aAttachmentMap.keySet()));
                }
                attachmentRequestCallback.setAttachments(object);
                continue;
            }
            if (callback instanceof AttachmentResultCallback) {
                attachmentRequestCallback = (AttachmentResultCallback)callback;
                string = attachmentRequestCallback.getAttachmentId();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Resulting attachment ID '" + string + "'");
                }
                if ((object = (WSS4JAttachment)this.m_aAttachmentMap.get((Object)string)) == null) {
                    throw new IllegalStateException("Failed to resolve source attachment with ID '" + string + "' in " + String.valueOf(this.m_aAttachmentMap.keySet()));
                }
                Attachment attachment = attachmentRequestCallback.getAttachment();
                WSS4JAttachment wSS4JAttachment = new WSS4JAttachment(this.m_aResHelper, attachment.getMimeType());
                wSS4JAttachment.setId(string);
                wSS4JAttachment.addHeaders(attachment.getHeaders());
                wSS4JAttachment.setCharset(((WSS4JAttachment)object).getCharsetOrDefault(null));
                wSS4JAttachment.setSourceStreamProvider((IHasInputStream)HasInputStream.once(() -> ((Attachment)attachment).getSourceStream()));
                this.m_aAttachmentMap.put((Object)string, (Object)wSS4JAttachment);
                continue;
            }
            throw new UnsupportedCallbackException(callback, "Unrecognized Callback of class " + callback.getClass().getName());
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<WSS4JAttachment> getAllResponseAttachments() {
        return this.m_aAttachmentMap.copyOfValues();
    }

    @Nonnull
    @ReturnsMutableObject
    public ICommonsOrderedMap<String, WSS4JAttachment> responseAttachments() {
        return this.m_aAttachmentMap;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("AttachmentMap", this.m_aAttachmentMap).append("ResHelper", (Object)this.m_aResHelper).getToString();
    }
}

