/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.client;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.ICommonsList;
import com.helger.http.header.HttpHeaderMap;
import com.helger.phase4.messaging.http.HttpMimeMessageEntity;
import com.helger.phase4.messaging.http.HttpXMLEntity;
import com.helger.phase4.messaging.mime.AS4MimeMessageHelper;
import com.helger.xsds.xmldsig.ReferenceType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.mail.MessagingException;
import org.apache.hc.core5.http.HttpEntity;

@NotThreadSafe
public final class AS4ClientBuiltMessage {
    private final String m_sMessageID;
    private final HttpEntity m_aHttpEntity;
    private final HttpHeaderMap m_aCustomHttpHeaders;
    private final ICommonsList<ReferenceType> m_aDSReferences;

    public AS4ClientBuiltMessage(@Nonnull @Nonempty String string, @Nonnull HttpXMLEntity httpXMLEntity, @Nullable ICommonsList<ReferenceType> iCommonsList) {
        this.m_sMessageID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"MessageID");
        this.m_aHttpEntity = (HttpEntity)ValueEnforcer.notNull((Object)((Object)httpXMLEntity), (String)"HttpEntity");
        this.m_aCustomHttpHeaders = null;
        this.m_aDSReferences = iCommonsList;
    }

    public AS4ClientBuiltMessage(@Nonnull @Nonempty String string, @Nonnull HttpMimeMessageEntity httpMimeMessageEntity, @Nullable ICommonsList<ReferenceType> iCommonsList) throws MessagingException {
        this.m_sMessageID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"MessageID");
        this.m_aHttpEntity = (HttpEntity)ValueEnforcer.notNull((Object)((Object)httpMimeMessageEntity), (String)"HttpEntity");
        this.m_aCustomHttpHeaders = AS4MimeMessageHelper.getAndRemoveAllHeaders(httpMimeMessageEntity.getMimeMessage());
        this.m_aDSReferences = iCommonsList;
    }

    @Nonnull
    @Nonempty
    public String getMessageID() {
        return this.m_sMessageID;
    }

    @Nonnull
    @ReturnsMutableCopy
    public HttpEntity getHttpEntity() {
        return this.m_aHttpEntity;
    }

    @Nullable
    @ReturnsMutableCopy
    public HttpHeaderMap getAllCustomHttpHeaders() {
        return this.m_aCustomHttpHeaders == null ? null : this.m_aCustomHttpHeaders.getClone();
    }

    public boolean hasCustomHttpHeaders() {
        return this.m_aCustomHttpHeaders != null && this.m_aCustomHttpHeaders.isNotEmpty();
    }

    @Nullable
    @ReturnsMutableCopy
    public ICommonsList<ReferenceType> getAllDSReferences() {
        return this.m_aDSReferences == null ? null : (ICommonsList)this.m_aDSReferences.getClone();
    }

    public boolean hasDSReferences() {
        return this.m_aDSReferences != null && this.m_aDSReferences.isNotEmpty();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("MessageID", (Object)this.m_sMessageID).append("HttpEntity", (Object)this.m_aHttpEntity).appendIfNotNull("CustomHttpHeaders", (Object)this.m_aCustomHttpHeaders).appendIfNotNull("DSReferences", this.m_aDSReferences).getToString();
    }
}

