/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.config;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.string.StringParser;
import com.helger.config.ConfigFactory;
import com.helger.config.fallback.ConfigWithFallback;
import com.helger.config.fallback.IConfigWithFallback;
import com.helger.config.source.EConfigSourceType;
import com.helger.config.source.MultiConfigurationValueProvider;
import com.helger.config.source.resource.properties.ConfigurationSourceProperties;
import com.helger.config.value.IConfigurationValueProvider;
import com.helger.io.resource.IReadableResource;
import com.helger.io.resource.IResourceBase;
import com.helger.io.resourceprovider.ReadableResourceProviderChain;
import com.helger.phase4.logging.Phase4LoggerFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;

public final class AS4Configuration {
    public static final String PROPERTY_PHASE4_MANAGER_INMEMORY = "phase4.manager.inmemory";
    public static final boolean DEFAULT_PHASE4_MANAGER_INMEMORY = true;
    public static final String PROPERTY_PHASE4_WSS4J_SYNCSECURITY = "phase4.wss4j.syncsecurity";
    public static final boolean DEFAULT_PHASE4_WSS4J_SYNCSECURITY = false;
    public static final long DEFAULT_PHASE4_INCOMING_DUPLICATEDISPOSAL_MINUTES = 10L;
    private static final Logger LOGGER = Phase4LoggerFactory.getLogger(AS4Configuration.class);
    private static final MultiConfigurationValueProvider VP = AS4Configuration.createPhase4ValueProvider();
    private static final IConfigWithFallback DEFAULT_INSTANCE = new ConfigWithFallback((IConfigurationValueProvider)VP);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static IConfigWithFallback s_aConfig = DEFAULT_INSTANCE;

    @Nonnull
    @Deprecated(forRemoval=true, since="4.0.1")
    public static MultiConfigurationValueProvider createPhase4ValueProvider() {
        MultiConfigurationValueProvider multiConfigurationValueProvider = ConfigFactory.createDefaultValueProvider();
        int n = EConfigSourceType.RESOURCE.getDefaultPriority();
        ReadableResourceProviderChain readableResourceProviderChain = ConfigFactory.createDefaultResourceProviderChain();
        IReadableResource iReadableResource = readableResourceProviderChain.getReadableResourceIf("private-phase4.properties", IResourceBase::exists);
        if (iReadableResource != null) {
            LOGGER.warn("Using the phase4 specific configuration file 'private-phase4.properties' is deprecated. Please use 'private-application.properties' instead! Support for this file will be removed in the next major release.");
            multiConfigurationValueProvider.addConfigurationSource((IConfigurationValueProvider)new ConfigurationSourceProperties(iReadableResource, StandardCharsets.UTF_8), n + 4);
        }
        if ((iReadableResource = readableResourceProviderChain.getReadableResourceIf("phase4.properties", IResourceBase::exists)) != null) {
            LOGGER.warn("Using the phase4 specific configuration file 'phase4.properties' is deprecated. Please use 'application.properties' instead! Support for this file will be removed in the next major release.");
            multiConfigurationValueProvider.addConfigurationSource((IConfigurationValueProvider)new ConfigurationSourceProperties(iReadableResource, StandardCharsets.UTF_8), n + 3);
        }
        return multiConfigurationValueProvider;
    }

    private AS4Configuration() {
    }

    @Nonnull
    public static IConfigWithFallback getConfig() {
        RW_LOCK.readLock().lock();
        try {
            IConfigWithFallback iConfigWithFallback = s_aConfig;
            return iConfigWithFallback;
        }
        finally {
            RW_LOCK.readLock().unlock();
        }
    }

    @Nonnull
    public static IConfigWithFallback setConfig(@Nonnull IConfigWithFallback iConfigWithFallback) {
        IConfigWithFallback iConfigWithFallback2;
        ValueEnforcer.notNull((Object)iConfigWithFallback, (String)"NewConfig");
        RW_LOCK.writeLock().lock();
        try {
            iConfigWithFallback2 = s_aConfig;
            s_aConfig = iConfigWithFallback;
        }
        finally {
            RW_LOCK.writeLock().unlock();
        }
        if (!EqualsHelper.identityEqual((Object)iConfigWithFallback2, (Object)iConfigWithFallback)) {
            LOGGER.info("The phase4 configuration provider was changed to " + String.valueOf(iConfigWithFallback));
        }
        return iConfigWithFallback2;
    }

    public static boolean isGlobalDebug() {
        return AS4Configuration.getConfig().getAsBoolean((Object)"global.debug", false);
    }

    public static boolean isGlobalProduction() {
        return AS4Configuration.getConfig().getAsBoolean((Object)"global.production", false);
    }

    public static boolean isNoStartupInfo() {
        return AS4Configuration.getConfig().getAsBoolean((Object)"global.nostartupinfo", true);
    }

    @Nonnull
    public static String getDataPath() {
        return AS4Configuration.getConfig().getAsString((Object)"global.datapath", "phase4-data");
    }

    public static boolean isUseInMemoryManagers() {
        String string = AS4Configuration.getConfig().getAsString((Object)PROPERTY_PHASE4_MANAGER_INMEMORY);
        return StringParser.parseBool((String)string, (boolean)true);
    }

    public static boolean isWSS4JSynchronizedSecurity() {
        String string = AS4Configuration.getConfig().getAsString((Object)PROPERTY_PHASE4_WSS4J_SYNCSECURITY);
        return StringParser.parseBool((String)string, (boolean)false);
    }

    @Nullable
    public static String getDefaultAS4ProfileID() {
        return AS4Configuration.getConfig().getAsStringOrFallback("phase4.default.profile", new String[]{"phase4.profile"});
    }

    public static long getIncomingDuplicateDisposalMinutes() {
        return AS4Configuration.getConfig().getAsLong((Object)"phase4.incoming.duplicatedisposal.minutes", 10L);
    }

    @Nonnull
    public static String getDumpBasePath() {
        return AS4Configuration.getConfig().getAsString((Object)"phase4.dump.path", "phase4-dumps");
    }

    @Nonnull
    public static File getDumpBasePathFile() {
        return new File(AS4Configuration.getDumpBasePath()).getAbsoluteFile();
    }

    @Nullable
    public static String getThisEndpointAddress() {
        return AS4Configuration.getConfig().getAsString((Object)"phase4.endpoint.address");
    }

    public static boolean isIncludeStackTraceInErrorMessages() {
        return AS4Configuration.getConfig().getAsBoolean((Object)"phase4.errormsg.include.stacktraces", false);
    }

    public static boolean isCompatibilityModeDomibus() {
        return AS4Configuration.getConfig().getAsBoolean((Object)"phase4.compatibility.domibus", false);
    }
}

