/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.crypto;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.config.fallback.IConfigWithFallback;
import com.helger.phase4.config.AS4Configuration;
import com.helger.phase4.crypto.AS4CryptoFactoryInMemoryKeyStore;
import com.helger.phase4.crypto.AS4KeyStoreDescriptor;
import com.helger.phase4.crypto.AS4TrustStoreDescriptor;
import com.helger.phase4.logging.Phase4LoggerFactory;
import com.helger.phase4.util.Phase4RuntimeException;
import com.helger.security.keystore.IKeyStoreAndKeyDescriptor;
import com.helger.security.keystore.ITrustStoreDescriptor;
import com.helger.security.keystore.KeyStoreAndKeyDescriptor;
import com.helger.security.keystore.LoadedKey;
import com.helger.security.keystore.LoadedKeyStore;
import com.helger.security.keystore.TrustStoreDescriptor;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;
import org.slf4j.Logger;

@Immutable
public class AS4CryptoFactoryConfiguration
extends AS4CryptoFactoryInMemoryKeyStore {
    private static final Logger LOGGER = Phase4LoggerFactory.getLogger(AS4CryptoFactoryConfiguration.class);
    private final IKeyStoreAndKeyDescriptor m_aKeyStoreDesc;
    private final ITrustStoreDescriptor m_aTrustStorDesc;

    @Nonnull
    public static AS4CryptoFactoryConfiguration getDefaultInstance() throws Phase4RuntimeException {
        return new AS4CryptoFactoryConfiguration(AS4Configuration.getConfig(), "org.apache.wss4j.crypto.merlin.", false);
    }

    @Nullable
    public static AS4CryptoFactoryConfiguration getDefaultInstanceOrNull() {
        try {
            return AS4CryptoFactoryConfiguration.getDefaultInstance();
        }
        catch (Phase4RuntimeException phase4RuntimeException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Failed to create AS4CryptoFactoryConfiguration default instance", (Throwable)phase4RuntimeException);
            }
            return null;
        }
    }

    public AS4CryptoFactoryConfiguration(@Nonnull IConfigWithFallback iConfigWithFallback) throws Phase4RuntimeException {
        this(iConfigWithFallback, "org.apache.wss4j.crypto.merlin.");
    }

    @Nonnull
    private static IKeyStoreAndKeyDescriptor _loadKeyStore(@Nonnull IConfigWithFallback iConfigWithFallback, @Nonnull @Nonempty String string, boolean bl) throws Phase4RuntimeException {
        KeyStoreAndKeyDescriptor keyStoreAndKeyDescriptor = AS4KeyStoreDescriptor.createFromConfig(iConfigWithFallback, string, null);
        if (keyStoreAndKeyDescriptor == null) {
            String string2 = "Failed to load the key store configuration from properties starting with '" + string + "'";
            if (bl) {
                LOGGER.error(string2);
            }
            throw new Phase4RuntimeException(string2);
        }
        LoadedKeyStore loadedKeyStore = keyStoreAndKeyDescriptor.loadKeyStore();
        if (loadedKeyStore.getKeyStore() == null) {
            String string3 = "Failed to load the key store from the properties starting with '" + string + "': " + loadedKeyStore.getErrorText(Locale.ROOT);
            if (bl) {
                LOGGER.error(string3);
            }
            throw new Phase4RuntimeException(string3);
        }
        LoadedKey loadedKey = keyStoreAndKeyDescriptor.loadKey();
        if (loadedKey.getKeyEntry() == null) {
            String string4 = "Failed to load the private key from the key store properties starting with '" + string + "': " + loadedKey.getErrorText(Locale.ROOT);
            if (bl) {
                LOGGER.error(string4);
            }
            throw new Phase4RuntimeException(string4);
        }
        return keyStoreAndKeyDescriptor;
    }

    @Nullable
    private static ITrustStoreDescriptor _loadTrustStore(@Nonnull IConfigWithFallback iConfigWithFallback, @Nonnull @Nonempty String string, boolean bl) {
        LoadedKeyStore loadedKeyStore;
        TrustStoreDescriptor trustStoreDescriptor = AS4TrustStoreDescriptor.createFromConfig(iConfigWithFallback, string, null);
        if (trustStoreDescriptor != null && (loadedKeyStore = trustStoreDescriptor.loadTrustStore()).getKeyStore() == null && bl) {
            LOGGER.error("Failed to load the trust store from the properties starting with '" + string + "': " + loadedKeyStore.getErrorText(Locale.ROOT));
        }
        return trustStoreDescriptor;
    }

    public AS4CryptoFactoryConfiguration(@Nonnull IConfigWithFallback iConfigWithFallback, @Nonnull @Nonempty String string) throws Phase4RuntimeException {
        this(iConfigWithFallback, string, true);
    }

    public AS4CryptoFactoryConfiguration(@Nonnull IConfigWithFallback iConfigWithFallback, @Nonnull @Nonempty String string, boolean bl) throws Phase4RuntimeException {
        this(AS4CryptoFactoryConfiguration._loadKeyStore(iConfigWithFallback, string, bl), AS4CryptoFactoryConfiguration._loadTrustStore(iConfigWithFallback, string, bl));
    }

    private AS4CryptoFactoryConfiguration(@Nonnull IKeyStoreAndKeyDescriptor iKeyStoreAndKeyDescriptor, @Nullable ITrustStoreDescriptor iTrustStoreDescriptor) {
        super(iKeyStoreAndKeyDescriptor, iTrustStoreDescriptor);
        this.m_aKeyStoreDesc = iKeyStoreAndKeyDescriptor;
        this.m_aTrustStorDesc = iTrustStoreDescriptor;
    }

    @Nonnull
    public IKeyStoreAndKeyDescriptor getKeyStoreDescriptor() {
        return this.m_aKeyStoreDesc;
    }

    @Nonnull
    public ITrustStoreDescriptor getTrustStoreDescriptor() {
        return this.m_aTrustStorDesc;
    }
}

