/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.dump;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.http.header.HttpHeaderMap;
import com.helger.io.file.FileHelper;
import com.helger.phase4.config.AS4Configuration;
import com.helger.phase4.dump.AbstractAS4IncomingDumperWithHeaders;
import com.helger.phase4.dump.IAS4IncomingDumperFileProvider;
import com.helger.phase4.incoming.IAS4IncomingMessageMetadata;
import com.helger.phase4.logging.Phase4LoggerFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;

public class AS4IncomingDumperFileBased
extends AbstractAS4IncomingDumperWithHeaders<AS4IncomingDumperFileBased> {
    public static final String DEFAULT_BASE_PATH = "incoming/";
    private static final Logger LOGGER = Phase4LoggerFactory.getLogger(AS4IncomingDumperFileBased.class);
    private final IAS4IncomingDumperFileProvider m_aFileProvider;

    public AS4IncomingDumperFileBased() {
        this((iAS4IncomingMessageMetadata, httpHeaderMap) -> new File(AS4Configuration.getDumpBasePathFile(), DEFAULT_BASE_PATH + IAS4IncomingDumperFileProvider.getDefaultDirectoryAndFilename(iAS4IncomingMessageMetadata)));
    }

    public AS4IncomingDumperFileBased(@Nonnull IAS4IncomingDumperFileProvider iAS4IncomingDumperFileProvider) {
        ValueEnforcer.notNull((Object)iAS4IncomingDumperFileProvider, (String)"FileProvider");
        this.m_aFileProvider = iAS4IncomingDumperFileProvider;
    }

    @Override
    @Nullable
    protected OutputStream openOutputStream(@Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nonnull HttpHeaderMap httpHeaderMap) throws IOException {
        File file = this.m_aFileProvider.createFile(iAS4IncomingMessageMetadata, httpHeaderMap);
        LOGGER.info("Logging incoming AS4 message to '" + file.getAbsolutePath() + "' " + (this.isIncludeHeaders() ? "including headers" : "excluding headers"));
        return FileHelper.getBufferedOutputStream((File)file);
    }

    @Nonnull
    public static AS4IncomingDumperFileBased createForDirectory(@Nonnull File file) {
        ValueEnforcer.notNull((Object)file, (String)"BaseDirectory");
        return new AS4IncomingDumperFileBased((iAS4IncomingMessageMetadata, httpHeaderMap) -> new File(file, IAS4IncomingDumperFileProvider.getDefaultDirectoryAndFilename(iAS4IncomingMessageMetadata)));
    }
}

