/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.dump;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.http.header.HttpHeaderMap;
import com.helger.io.file.FileHelper;
import com.helger.phase4.config.AS4Configuration;
import com.helger.phase4.dump.AbstractAS4OutgoingDumperWithHeaders;
import com.helger.phase4.dump.IAS4OutgoingDumperFileProvider;
import com.helger.phase4.incoming.IAS4IncomingMessageMetadata;
import com.helger.phase4.incoming.IAS4IncomingMessageState;
import com.helger.phase4.logging.Phase4LoggerFactory;
import com.helger.phase4.messaging.EAS4MessageMode;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;

public class AS4OutgoingDumperFileBased
extends AbstractAS4OutgoingDumperWithHeaders<AS4OutgoingDumperFileBased> {
    public static final String DEFAULT_BASE_PATH = "outgoing/";
    private static final Logger LOGGER = Phase4LoggerFactory.getLogger(AS4OutgoingDumperFileBased.class);
    private final IAS4OutgoingDumperFileProvider m_aFileProvider;

    public AS4OutgoingDumperFileBased() {
        this((eAS4MessageMode, string, n) -> new File(AS4Configuration.getDumpBasePathFile(), DEFAULT_BASE_PATH + IAS4OutgoingDumperFileProvider.getDefaultDirectoryAndFilename(string, n)));
    }

    public AS4OutgoingDumperFileBased(@Nonnull IAS4OutgoingDumperFileProvider iAS4OutgoingDumperFileProvider) {
        ValueEnforcer.notNull((Object)iAS4OutgoingDumperFileProvider, (String)"FileProvider");
        this.m_aFileProvider = iAS4OutgoingDumperFileProvider;
    }

    @Nonnull
    protected final IAS4OutgoingDumperFileProvider getFileProvider() {
        return this.m_aFileProvider;
    }

    @Override
    protected OutputStream openOutputStream(@Nonnull EAS4MessageMode eAS4MessageMode, @Nullable IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nullable IAS4IncomingMessageState iAS4IncomingMessageState, @Nonnull @Nonempty String string, @Nullable HttpHeaderMap httpHeaderMap, @Nonnegative int n) throws IOException {
        File file = this.m_aFileProvider.getFile(eAS4MessageMode, string, n);
        LOGGER.info("Logging outgoing AS4 message to '" + file.getAbsolutePath() + "' " + (this.isIncludeHeaders() ? "including headers" : "excluding headers"));
        return FileHelper.getBufferedOutputStream((File)file);
    }

    @Nonnull
    public static AS4OutgoingDumperFileBased createForDirectory(@Nonnull File file) {
        ValueEnforcer.notNull((Object)file, (String)"BaseDirectory");
        return new AS4OutgoingDumperFileBased((eAS4MessageMode, string, n) -> new File(file, IAS4OutgoingDumperFileProvider.getDefaultDirectoryAndFilename(string, n)));
    }
}

