/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.incoming;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.string.StringHelper;
import com.helger.base.trait.IAddableByTrait;
import com.helger.collection.commons.ICommonsList;
import com.helger.datetime.web.PDTWebDateHelper;
import com.helger.json.IJson;
import com.helger.json.IJsonObject;
import com.helger.json.JsonArray;
import com.helger.json.JsonObject;
import com.helger.phase4.incoming.IAS4IncomingMessageMetadata;
import jakarta.annotation.Nonnull;
import java.time.OffsetDateTime;

@Immutable
public final class AS4IncomingHelper {
    private AS4IncomingHelper() {
    }

    @Nonnull
    @Nonempty
    public static IJsonObject getIncomingMetadataAsJson(@Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata) {
        JsonObject jsonObject;
        JsonObject jsonObject2 = new JsonObject();
        jsonObject2.add((Object)"IncomingUniqueID", (Object)iAS4IncomingMessageMetadata.getIncomingUniqueID());
        jsonObject2.add((Object)"IncomingDT", (Object)PDTWebDateHelper.getAsStringXSD((OffsetDateTime)iAS4IncomingMessageMetadata.getIncomingDT()));
        jsonObject2.add((Object)"Mode", (Object)iAS4IncomingMessageMetadata.getMode().getID());
        if (iAS4IncomingMessageMetadata.hasRemoteAddr()) {
            jsonObject2.add((Object)"RemoteAddr", (Object)iAS4IncomingMessageMetadata.getRemoteAddr());
        }
        if (iAS4IncomingMessageMetadata.hasRemoteHost()) {
            jsonObject2.add((Object)"RemoteHost", (Object)iAS4IncomingMessageMetadata.getRemoteHost());
        }
        if (iAS4IncomingMessageMetadata.hasRemotePort()) {
            jsonObject2.add((Object)"RemotePort", iAS4IncomingMessageMetadata.getRemotePort());
        }
        if (iAS4IncomingMessageMetadata.hasRemoteUser()) {
            jsonObject2.add((Object)"RemoteUser", (Object)iAS4IncomingMessageMetadata.getRemoteUser());
        }
        JsonArray jsonArray = new JsonArray();
        for (Object object : iAS4IncomingMessageMetadata.cookies()) {
            jsonObject = new JsonObject();
            if (StringHelper.isNotEmpty((String)object.getDomain())) {
                jsonObject.add((Object)"Domain", (Object)object.getDomain());
            }
            if (StringHelper.isNotEmpty((String)object.getPath())) {
                jsonObject.add((Object)"Path", (Object)object.getPath());
            }
            jsonObject.add((Object)"Secure", object.getSecure());
            jsonObject.add((Object)"HttpOnly", object.isHttpOnly());
            jsonObject.add((Object)"Name", (Object)object.getName());
            jsonObject.add((Object)"Value", (Object)object.getValue());
            jsonObject.add((Object)"MaxAge", object.getMaxAge());
            jsonArray.add((IAddableByTrait)jsonObject);
        }
        if (jsonArray.isNotEmpty()) {
            jsonObject2.add((Object)"Cookies", (IAddableByTrait)jsonArray);
        }
        jsonArray = new JsonArray();
        for (Object object : iAS4IncomingMessageMetadata.getAllHttpHeaders()) {
            jsonObject = (ICommonsList)object.getValue();
            JsonObject jsonObject3 = new JsonObject();
            if (jsonObject.size() != 1) {
                jsonObject3.add((Object)((String)object.getKey()), (IAddableByTrait)((IJson)new JsonArray().addAll((Iterable)jsonObject)));
            } else {
                jsonObject3.add((Object)((String)object.getKey()), jsonObject.getFirstOrNull());
            }
            jsonArray.add((IAddableByTrait)jsonObject3);
        }
        if (jsonArray.isNotEmpty()) {
            jsonObject2.add((Object)"HttpHeaders", (IAddableByTrait)jsonArray);
        }
        return jsonObject2;
    }
}

