/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.logging;

import com.helger.annotation.Nonempty;
import com.helger.base.string.StringHelper;
import com.helger.phase4.logging.Phase4DelegatedLogger;
import com.helger.phase4.logging.Phase4LogCustomizer;
import jakarta.annotation.Nonnull;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Phase4LoggerFactory {
    private static final Phase4LoggerFactory INSTANCE = new Phase4LoggerFactory();
    private static final Function<String, String> MSG_CUSTOMIZER = string -> {
        String string2 = Phase4LogCustomizer.getThreadLocalLogPrefix();
        String string3 = Phase4LogCustomizer.getThreadLocalLogSuffix();
        boolean bl = StringHelper.isNotEmpty((String)string2);
        boolean bl2 = StringHelper.isNotEmpty((String)string3);
        if (bl || bl2) {
            StringBuilder stringBuilder = new StringBuilder();
            if (bl) {
                stringBuilder.append(string2);
            }
            if (StringHelper.isNotEmpty((String)string)) {
                stringBuilder.append((String)string);
            }
            if (bl2) {
                stringBuilder.append(string3);
            }
            return stringBuilder.toString();
        }
        return string;
    };

    @Deprecated(forRemoval=false)
    private Phase4LoggerFactory() {
    }

    @Nonnull
    public static Phase4DelegatedLogger getLogger(@Nonnull Class<?> clazz) {
        Logger logger = LoggerFactory.getLogger(clazz);
        return new Phase4DelegatedLogger(logger, MSG_CUSTOMIZER);
    }

    @Nonnull
    public static Phase4DelegatedLogger getLogger(@Nonnull @Nonempty String string) {
        Logger logger = LoggerFactory.getLogger((String)string);
        return new Phase4DelegatedLogger(logger, MSG_CUSTOMIZER);
    }
}

