/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.messaging.crypto;

import com.helger.annotation.Nonempty;
import com.helger.annotation.WillNotClose;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.ICommonsList;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.attachment.WSS4JAttachmentCallbackHandler;
import com.helger.phase4.config.AS4Configuration;
import com.helger.phase4.crypto.AS4SigningParams;
import com.helger.phase4.crypto.ECryptoMode;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.logging.Phase4LoggerFactory;
import com.helger.phase4.model.ESoapVersion;
import com.helger.phase4.model.message.MessageHelperMethods;
import com.helger.phase4.util.AS4ResourceHelper;
import com.helger.phase4.wss.WSSConfigManager;
import com.helger.phase4.wss.WSSSynchronizer;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.slf4j.Logger;
import org.w3c.dom.Document;

@Immutable
public final class AS4Signer {
    static final String ENCRYPTION_MODE_CONTENT = "Content";
    private static final Logger LOGGER = Phase4LoggerFactory.getLogger(AS4Signer.class);
    private static final String CID_ATTACHMENTS = MessageHelperMethods.PREFIX_CID + "Attachments";

    private AS4Signer() {
    }

    @Nonnull
    private static Document _createSignedMessage(@Nonnull IAS4CryptoFactory iAS4CryptoFactory, @Nonnull Document document, @Nonnull ESoapVersion eSoapVersion, @Nonnull @Nonempty String string, @Nullable ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper, boolean bl, @Nonnull AS4SigningParams aS4SigningParams) throws WSSecurityException {
        Object object;
        WSSecSignature wSSecSignature;
        ValueEnforcer.notNull((Object)iAS4CryptoFactory, (String)"CryptoFactorySign");
        ValueEnforcer.notNull((Object)document, (String)"PreSigningMessage");
        ValueEnforcer.notNull((Object)((Object)eSoapVersion), (String)"SoapVersion");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"MessagingID");
        ValueEnforcer.notNull((Object)aS4ResourceHelper, (String)"ResHelper");
        ValueEnforcer.notNull((Object)aS4SigningParams, (String)"SigningParams");
        LOGGER.info("Now signing AS4 message [" + String.valueOf((Object)eSoapVersion) + "]. KeyIdentifierType=" + aS4SigningParams.getKeyIdentifierType().name() + "; KeyAlias=" + iAS4CryptoFactory.getKeyAlias() + "; SignAlgo=" + aS4SigningParams.getAlgorithmSign().getAlgorithmURI() + "; DigestAlgo=" + aS4SigningParams.getAlgorithmSignDigest().getAlgorithmURI() + "; C14NAlgo=" + aS4SigningParams.getAlgorithmC14N().getAlgorithmURI());
        WSSecHeader wSSecHeader = new WSSecHeader(document);
        wSSecHeader.insertSecurityHeader();
        WSSecSignature wSSecSignature2 = wSSecSignature = aS4SigningParams.hasWSSecSignatureCustomizer() ? aS4SigningParams.getWSSecSignatureCustomizer().createWSSecSignature(wSSecHeader) : new WSSecSignature(wSSecHeader);
        if (wSSecSignature == null) {
            throw new IllegalStateException("Failed to create WSSecSignature for " + String.valueOf(wSSecHeader));
        }
        wSSecSignature.setKeyIdentifierType(aS4SigningParams.getKeyIdentifierType().getTypeID());
        wSSecSignature.setUserInfo(iAS4CryptoFactory.getKeyAlias(), iAS4CryptoFactory.getKeyPasswordPerAlias(iAS4CryptoFactory.getKeyAlias()));
        wSSecSignature.setSignatureAlgorithm(aS4SigningParams.getAlgorithmSign().getAlgorithmURI());
        wSSecSignature.setDigestAlgo(aS4SigningParams.getAlgorithmSignDigest().getAlgorithmURI());
        wSSecSignature.setSigCanonicalization(aS4SigningParams.getAlgorithmC14N().getAlgorithmURI());
        wSSecSignature.setSignatureProvider(aS4SigningParams.getSecurityProviderSign());
        wSSecSignature.setUseSingleCertificate(aS4SigningParams.isUseSingleCertificate());
        wSSecSignature.getParts().add(new WSEncryptionPart(string, ENCRYPTION_MODE_CONTENT));
        wSSecSignature.getParts().add(new WSEncryptionPart("Body", eSoapVersion.getNamespaceURI(), ENCRYPTION_MODE_CONTENT));
        if (CollectionHelper.isNotEmpty(iCommonsList)) {
            wSSecSignature.getParts().add(new WSEncryptionPart(CID_ATTACHMENTS, ENCRYPTION_MODE_CONTENT));
            object = new WSS4JAttachmentCallbackHandler((Iterable<? extends WSS4JAttachment>)iCommonsList, aS4ResourceHelper);
            wSSecSignature.setAttachmentCallbackHandler((CallbackHandler)object);
        }
        if ((object = wSSecHeader.getSecurityHeaderElement().getAttributeNodeNS(eSoapVersion.getNamespaceURI(), "mustUnderstand")) != null) {
            object.setValue(eSoapVersion.getMustUnderstandValue(bl));
        }
        if (aS4SigningParams.hasWSSecSignatureCustomizer()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Before running WSSecSignatureCustomizer.customize");
            }
            aS4SigningParams.getWSSecSignatureCustomizer().customize(wSSecSignature);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("After running WSSecSignatureCustomizer.customize");
            }
        }
        return wSSecSignature.build(iAS4CryptoFactory.getCrypto(ECryptoMode.ENCRYPT_SIGN));
    }

    @Nonnull
    public static Document createSignedMessage(@Nonnull IAS4CryptoFactory iAS4CryptoFactory, @Nonnull Document document, @Nonnull ESoapVersion eSoapVersion, @Nonnull @Nonempty String string, @Nullable ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper, boolean bl, @Nonnull AS4SigningParams aS4SigningParams) throws WSSecurityException {
        Document document2;
        ValueEnforcer.notNull((Object)iAS4CryptoFactory, (String)"CryptoFactorySign");
        ValueEnforcer.notNull((Object)document, (String)"PreSigningMessage");
        ValueEnforcer.notNull((Object)((Object)eSoapVersion), (String)"SoapVersion");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"MessagingID");
        ValueEnforcer.notNull((Object)aS4ResourceHelper, (String)"ResHelper");
        ValueEnforcer.notNull((Object)aS4SigningParams, (String)"SigningParams");
        LOGGER.info("phase4 --- sign:start");
        if (AS4Configuration.isWSS4JSynchronizedSecurity()) {
            document2 = (Document)WSSSynchronizer.call(() -> AS4Signer._createSignedMessage(iAS4CryptoFactory, document, eSoapVersion, string, iCommonsList, aS4ResourceHelper, bl, aS4SigningParams));
        } else {
            WSSConfigManager.getInstance();
            document2 = AS4Signer._createSignedMessage(iAS4CryptoFactory, document, eSoapVersion, string, iCommonsList, aS4ResourceHelper, bl, aS4SigningParams);
        }
        LOGGER.info("phase4 --- sign:end");
        return document2;
    }
}

