/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.mgr;

import com.helger.dao.DAOException;
import com.helger.phase4.duplicate.AS4DuplicateManagerXML;
import com.helger.phase4.duplicate.IAS4DuplicateManager;
import com.helger.phase4.mgr.IAS4ManagerFactory;
import com.helger.phase4.mgr.IAS4TimestampManager;
import com.helger.phase4.model.mpc.IMPCManager;
import com.helger.phase4.model.mpc.MPCManagerXML;
import com.helger.phase4.model.pmode.IPModeManager;
import com.helger.phase4.model.pmode.PModeManagerXML;
import com.helger.phase4.profile.AS4ProfileManager;
import com.helger.phase4.profile.IAS4ProfileManager;
import com.helger.phase4.util.Phase4Exception;
import jakarta.annotation.Nonnull;

public class AS4ManagerFactoryPersistingFileSystem
implements IAS4ManagerFactory {
    private static final String MPC_XML = "as4-mpc.xml";
    private static final String PMODE_XML = "as4-pmode.xml";
    private static final String INCOMING_DUPLICATE_XML = "as4-duplicate-incoming.xml";

    @Override
    @Nonnull
    public IMPCManager createMPCManager() throws Phase4Exception {
        try {
            return new MPCManagerXML(MPC_XML);
        }
        catch (DAOException dAOException) {
            throw new Phase4Exception("Error creating MPCManager", dAOException).setRetryFeasible(false);
        }
    }

    @Override
    @Nonnull
    public IPModeManager createPModeManager() throws Phase4Exception {
        try {
            return new PModeManagerXML(PMODE_XML);
        }
        catch (DAOException dAOException) {
            throw new Phase4Exception("Error creating PModeManager", dAOException).setRetryFeasible(false);
        }
    }

    @Override
    @Nonnull
    public IAS4DuplicateManager createDuplicateManager() throws Phase4Exception {
        try {
            return new AS4DuplicateManagerXML(INCOMING_DUPLICATE_XML);
        }
        catch (DAOException dAOException) {
            throw new Phase4Exception("Error creating AS4DuplicateManager", dAOException).setRetryFeasible(false);
        }
    }

    @Override
    @Nonnull
    public IAS4ProfileManager createProfileManager() {
        return new AS4ProfileManager();
    }

    @Override
    @Nonnull
    public IAS4TimestampManager createTimestampManager() {
        return IAS4TimestampManager.createDefaultInstance();
    }
}

