/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.message;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.ICommonsList;
import com.helger.phase4.ebms3header.Ebms3Error;
import com.helger.phase4.ebms3header.Ebms3MessageInfo;
import com.helger.phase4.ebms3header.Ebms3SignalMessage;
import com.helger.phase4.model.ESoapVersion;
import com.helger.phase4.model.message.AbstractAS4Message;
import com.helger.phase4.model.message.EAS4MessageType;
import com.helger.phase4.model.message.MessageHelperMethods;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;

public class AS4ErrorMessage
extends AbstractAS4Message<AS4ErrorMessage> {
    private final Ebms3SignalMessage m_aSignalMessage;

    public AS4ErrorMessage(@Nonnull ESoapVersion eSoapVersion, @Nonnull Ebms3SignalMessage ebms3SignalMessage) {
        super(eSoapVersion, EAS4MessageType.ERROR_MESSAGE);
        ValueEnforcer.notNull((Object)ebms3SignalMessage, (String)"SignalMessage");
        this.m_aMessaging.addSignalMessage(ebms3SignalMessage);
        this.m_aSignalMessage = ebms3SignalMessage;
        for (Ebms3Error ebms3Error : ebms3SignalMessage.getError()) {
            if (ebms3Error.getDescription() == null || !StringHelper.isEmpty((String)ebms3Error.getDescription().getValue())) continue;
            throw new IllegalArgumentException("Error description may not be empty - will lead to invalid XML!");
        }
    }

    @Nonnull
    public final Ebms3SignalMessage getEbms3SignalMessage() {
        return this.m_aSignalMessage;
    }

    @Nonnull
    public static AS4ErrorMessage create(@Nonnull ESoapVersion eSoapVersion, @Nullable String string, @Nonnull ICommonsList<Ebms3Error> iCommonsList) {
        Ebms3MessageInfo ebms3MessageInfo = MessageHelperMethods.createEbms3MessageInfo(string);
        return AS4ErrorMessage.create(eSoapVersion, ebms3MessageInfo, iCommonsList);
    }

    @Nonnull
    public static AS4ErrorMessage create(@Nonnull ESoapVersion eSoapVersion, @Nonnull Ebms3MessageInfo ebms3MessageInfo, @Nonnull ICommonsList<Ebms3Error> iCommonsList) {
        Ebms3SignalMessage ebms3SignalMessage = new Ebms3SignalMessage();
        ebms3SignalMessage.setMessageInfo(ebms3MessageInfo);
        ebms3SignalMessage.setError((List<Ebms3Error>)iCommonsList);
        return new AS4ErrorMessage(eSoapVersion, ebms3SignalMessage);
    }
}

