/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.message;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.ICommonsList;
import com.helger.phase4.CAS4Version;
import com.helger.phase4.ebms3header.Ebms3Receipt;
import com.helger.phase4.ebms3header.Ebms3SignalMessage;
import com.helger.phase4.ebms3header.Ebms3UserMessage;
import com.helger.phase4.ebms3header.MessagePartNRInformation;
import com.helger.phase4.ebms3header.NonRepudiationInformation;
import com.helger.phase4.logging.Phase4LoggerFactory;
import com.helger.phase4.marshaller.Ebms3UserMessageMarshaller;
import com.helger.phase4.marshaller.NonRepudiationInformationMarshaller;
import com.helger.phase4.model.ESoapVersion;
import com.helger.phase4.model.message.AbstractAS4Message;
import com.helger.phase4.model.message.EAS4MessageType;
import com.helger.phase4.model.message.MessageHelperMethods;
import com.helger.xml.XMLFactory;
import com.helger.xsds.xmldsig.ReferenceType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AS4ReceiptMessage
extends AbstractAS4Message<AS4ReceiptMessage> {
    private static final String PHASE4_RECEIPT_WRAPPER_NS = "urn:fdc:com.helger.phase4:ns:wrapper";
    private static final String PHASE4_RECEIPT_INFO_NS = "urn:fdc:com.helger.phase4:ns:info";
    private static final Logger LOGGER = Phase4LoggerFactory.getLogger(AS4ReceiptMessage.class);
    private final Ebms3SignalMessage m_aSignalMessage;

    public AS4ReceiptMessage(@Nonnull ESoapVersion eSoapVersion, @Nonnull Ebms3SignalMessage ebms3SignalMessage) {
        super(eSoapVersion, EAS4MessageType.RECEIPT);
        ValueEnforcer.notNull((Object)ebms3SignalMessage, (String)"SignalMessage");
        this.m_aMessaging.addSignalMessage(ebms3SignalMessage);
        this.m_aSignalMessage = ebms3SignalMessage;
    }

    @Nonnull
    public final Ebms3SignalMessage getEbms3SignalMessage() {
        return this.m_aSignalMessage;
    }

    @Nonnull
    public static AS4ReceiptMessage create(@Nonnull ESoapVersion eSoapVersion, @Nonnull @Nonempty String string, @Nullable Ebms3UserMessage ebms3UserMessage, @Nullable Node node, boolean bl, @Nullable String string2) {
        Object object;
        Object object2;
        ICommonsList<ReferenceType> iCommonsList = MessageHelperMethods.getAllDSigReferences(node);
        Ebms3SignalMessage ebms3SignalMessage = new Ebms3SignalMessage();
        Object object3 = ebms3UserMessage != null ? ebms3UserMessage.getMessageInfo().getMessageId() : string2;
        ebms3SignalMessage.setMessageInfo(MessageHelperMethods.createEbms3MessageInfo(string, (String)object3));
        object3 = new Ebms3Receipt();
        if (iCommonsList.isNotEmpty() && bl) {
            object2 = new NonRepudiationInformation();
            for (ReferenceType referenceType : iCommonsList) {
                MessagePartNRInformation messagePartNRInformation = new MessagePartNRInformation();
                messagePartNRInformation.setReference(referenceType);
                ((NonRepudiationInformation)object2).addMessagePartNRInformation(messagePartNRInformation);
            }
            object = new NonRepudiationInformationMarshaller().getAsElement(object2);
            if (object == null) {
                LOGGER.error("Failed to serialize NonRepudiationInformation object");
            } else {
                ((Ebms3Receipt)object3).addAny(object);
            }
        } else {
            if (iCommonsList.isEmpty()) {
                LOGGER.info("Found no ds:Reference elements in the source message, hence returning the source UserMessage in the Receipt");
            } else {
                LOGGER.info("Non-repudiation is disabled, hence returning the source UserMessage in the Receipt");
            }
            object2 = XMLFactory.newDocument();
            if (ebms3UserMessage != null) {
                object = (Element)object2.appendChild(object2.createElementNS(PHASE4_RECEIPT_WRAPPER_NS, "OriginalUserMessage"));
                object.appendChild(object2.adoptNode(new Ebms3UserMessageMarshaller().getAsElement(ebms3UserMessage)));
            } else {
                object2.appendChild(object2.createElementNS(PHASE4_RECEIPT_WRAPPER_NS, "WithoutOriginalUserMessage"));
            }
            ((Ebms3Receipt)object3).addAny(object2.getDocumentElement());
        }
        object2 = XMLFactory.newDocument();
        object = (Element)object2.appendChild(object2.createElementNS(PHASE4_RECEIPT_INFO_NS, "phase4"));
        object.setAttributeNS(PHASE4_RECEIPT_INFO_NS, "version", CAS4Version.BUILD_VERSION);
        object.setAttributeNS(PHASE4_RECEIPT_INFO_NS, "timestamp", CAS4Version.BUILD_TIMESTAMP);
        ((Ebms3Receipt)object3).addAny(object2.getDocumentElement());
        ebms3SignalMessage.setReceipt((Ebms3Receipt)object3);
        return new AS4ReceiptMessage(eSoapVersion, ebms3SignalMessage);
    }
}

