/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.phase4.mgr.MetaAS4Manager;
import com.helger.phase4.model.EMEP;
import com.helger.phase4.model.EMEPBinding;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.IPModeIDProvider;
import com.helger.phase4.model.pmode.PMode;
import com.helger.phase4.model.pmode.PModeParty;
import com.helger.phase4.model.pmode.PModePayloadService;
import com.helger.phase4.model.pmode.PModeReceptionAwareness;
import com.helger.phase4.model.pmode.leg.EPModeSendReceiptReplyPattern;
import com.helger.phase4.model.pmode.leg.PModeLeg;
import com.helger.phase4.model.pmode.leg.PModeLegBusinessInformation;
import com.helger.phase4.model.pmode.leg.PModeLegErrorHandling;
import com.helger.phase4.model.pmode.leg.PModeLegProtocol;
import com.helger.phase4.model.pmode.leg.PModeLegReliability;
import com.helger.phase4.model.pmode.leg.PModeLegSecurity;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@Immutable
public final class DefaultPMode {
    private DefaultPMode() {
    }

    @Nonnull
    private static PModeLegProtocol _generatePModeLegProtocol(@Nullable String string) {
        return PModeLegProtocol.createForDefaultSoapVersion(string);
    }

    @Nonnull
    private static PModeLegBusinessInformation _generatePModeLegBusinessInformation() {
        return PModeLegBusinessInformation.create("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/service", "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/test", null, "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/defaultMPC");
    }

    @Nonnull
    private static PModeLeg _generatePModeLeg(@Nullable String string) {
        PModeLegErrorHandling pModeLegErrorHandling = PModeLegErrorHandling.createUndefined();
        pModeLegErrorHandling.setReportAsResponse(true);
        PModeLegReliability pModeLegReliability = null;
        PModeLegSecurity pModeLegSecurity = new PModeLegSecurity();
        pModeLegSecurity.setSendReceipt(true);
        pModeLegSecurity.setSendReceiptReplyPattern(EPModeSendReceiptReplyPattern.RESPONSE);
        return new PModeLeg(DefaultPMode._generatePModeLegProtocol(string), DefaultPMode._generatePModeLegBusinessInformation(), pModeLegErrorHandling, pModeLegReliability, pModeLegSecurity);
    }

    @Nonnull
    public static IPMode getOrCreateDefaultPMode(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nullable String string3, boolean bl) {
        PModeParty pModeParty = new PModeParty("default", string, "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/initiator", null, null);
        PModeParty pModeParty2 = new PModeParty("default", string2, "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/responder", null, null);
        String string4 = "default-" + IPModeIDProvider.DEFAULT_DYNAMIC.getPModeID(pModeParty, pModeParty2);
        PMode pMode = new PMode(string4, pModeParty, pModeParty2, "urn:as4:agreement", EMEP.ONE_WAY, EMEPBinding.PUSH, DefaultPMode._generatePModeLeg(string3), (PModeLeg)null, (PModePayloadService)null, (PModeReceptionAwareness)null);
        if (bl) {
            MetaAS4Manager.getPModeMgr().createOrUpdatePMode(pMode);
        }
        return pMode;
    }
}

