/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode;

import com.helger.annotation.concurrent.ELockType;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.MustBeLocked;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.base.state.IChangeIndicator;
import com.helger.base.string.StringHelper;
import com.helger.collection.CollectionFind;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsSet;
import com.helger.phase4.logging.Phase4LoggerFactory;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.IPModeManager;
import com.helger.phase4.model.pmode.PMode;
import com.helger.phase4.model.pmode.PModeValidationException;
import com.helger.photon.security.object.BusinessObjectHelper;
import com.helger.tenancy.AbstractBusinessObject;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.function.Predicate;
import org.slf4j.Logger;

@ThreadSafe
public class PModeManagerInMemory
implements IPModeManager {
    private static final Logger LOGGER = Phase4LoggerFactory.getLogger(PModeManagerInMemory.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, PMode> m_aMap = new CommonsHashMap();

    private void _validatePMode(@Nonnull IPMode iPMode) {
        try {
            this.validatePMode(iPMode);
        }
        catch (PModeValidationException pModeValidationException) {
            throw new IllegalArgumentException("PMode is invalid", pModeValidationException);
        }
    }

    @MustBeLocked(value=ELockType.WRITE)
    private void _createPModeLocked(@Nonnull PMode pMode) {
        String string = pMode.getID();
        if (this.m_aMap.containsKey((Object)string)) {
            throw new IllegalArgumentException("An object with ID '" + string + "' is already contained!");
        }
        this.m_aMap.put((Object)string, (Object)pMode);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Created PMode with ID '" + pMode.getID() + "'");
        }
    }

    @Override
    public void createPMode(@Nonnull PMode pMode) {
        ValueEnforcer.notNull((Object)pMode, (String)"PMode");
        this._validatePMode(pMode);
        this.m_aRWLock.writeLocked(() -> this._createPModeLocked(pMode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange updatePMode(@Nonnull IPMode iPMode) {
        ValueEnforcer.notNull((Object)iPMode, (String)"PMode");
        this._validatePMode(iPMode);
        PMode pMode = this.getOfID((String)iPMode.getID());
        if (pMode == null || pMode.isDeleted()) {
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = EChange.UNCHANGED;
            eChange = eChange.or((IChangeIndicator)pMode.setInitiator(iPMode.getInitiator()));
            eChange = eChange.or((IChangeIndicator)pMode.setResponder(iPMode.getResponder()));
            eChange = eChange.or((IChangeIndicator)pMode.setAgreement(iPMode.getAgreement()));
            eChange = eChange.or((IChangeIndicator)pMode.setMEP(iPMode.getMEP()));
            eChange = eChange.or((IChangeIndicator)pMode.setMEPBinding(iPMode.getMEPBinding()));
            eChange = eChange.or((IChangeIndicator)pMode.setLeg1(iPMode.getLeg1()));
            eChange = eChange.or((IChangeIndicator)pMode.setLeg2(iPMode.getLeg2()));
            eChange = eChange.or((IChangeIndicator)pMode.setPayloadService(iPMode.getPayloadService()));
            eChange = eChange.or((IChangeIndicator)pMode.setReceptionAwareness(iPMode.getReceptionAwareness()));
            if (eChange.isUnchanged()) {
                EChange eChange2 = EChange.UNCHANGED;
                return eChange2;
            }
            BusinessObjectHelper.setLastModificationNow((AbstractBusinessObject)pMode);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Updated PMode with ID '" + (String)iPMode.getID() + "'");
        }
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createOrUpdatePMode(@Nonnull PMode pMode) {
        ValueEnforcer.notNull((Object)pMode, (String)"PMode");
        this._validatePMode(pMode);
        Predicate<IPMode> predicate = IPModeManager.getPModeFilter(pMode.getID(), pMode.getInitiator(), pMode.getResponder());
        IPMode iPMode = this.findFirst(predicate);
        if (iPMode == null) {
            this.m_aRWLock.writeLock().lock();
            try {
                iPMode = this.findFirst(predicate);
                if (iPMode == null) {
                    this._createPModeLocked(pMode);
                }
            }
            finally {
                this.m_aRWLock.writeLock().unlock();
            }
        }
        if (iPMode != null) {
            this.updatePMode(iPMode);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Updated PMode with ID '" + pMode.getID() + "'");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange markPModeDeleted(@Nullable String string) {
        PMode pMode = this.getOfID(string);
        if (pMode == null) {
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (BusinessObjectHelper.setDeletionNow((AbstractBusinessObject)pMode).isUnchanged()) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Marked PMode with ID '" + pMode.getID() + "' as deleted");
        }
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public EChange deletePMode(@Nullable String string) {
        PMode pMode = this.getOfID(string);
        if (pMode == null) {
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aMap.remove((Object)string);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        return EChange.CHANGED;
    }

    @Nullable
    PMode getOfID(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        return (PMode)this.m_aRWLock.readLockedGet(() -> (PMode)this.m_aMap.get((Object)string));
    }

    @Override
    @Nullable
    public IPMode getPModeOfID(@Nullable String string) {
        return this.getOfID(string);
    }

    @Override
    @Nullable
    public IPMode findFirst(@Nonnull Predicate<? super IPMode> predicate) {
        return (IPMode)this.m_aRWLock.readLockedGet(() -> (PMode)CollectionFind.findFirst((Iterable)this.m_aMap.values(), (Predicate)predicate));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IPMode> getAll() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> new CommonsArrayList(this.m_aMap.values()));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<String> getAllIDs() {
        return (ICommonsSet)this.m_aRWLock.readLockedGet(() -> this.m_aMap.copyOfKeySet());
    }
}

