/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode;

import com.helger.base.state.ETriState;
import com.helger.phase4.model.pmode.AbstractPModeMicroTypeConverter;
import com.helger.phase4.model.pmode.PModeReceptionAwareness;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroQName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class PModeReceptionAwarenessMicroTypeConverter
extends AbstractPModeMicroTypeConverter<PModeReceptionAwareness> {
    private static final IMicroQName ATTR_RECEPTION_AWARENESS = new MicroQName("ReceptionAwareness");
    private static final IMicroQName ATTR_RETRY = new MicroQName("Retry");
    private static final IMicroQName ATTR_MAX_RETRIES = new MicroQName("MaxRetries");
    private static final IMicroQName ATTR_RETRY_INTERVAL_MS = new MicroQName("RetryIntervalMS");
    private static final IMicroQName ATTR_DUPLICATE_DETECTION = new MicroQName("DuplicateDetection");

    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull PModeReceptionAwareness pModeReceptionAwareness, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        if (pModeReceptionAwareness.isReceptionAwarenessDefined()) {
            microElement.setAttribute(ATTR_RECEPTION_AWARENESS, pModeReceptionAwareness.isReceptionAwareness());
        }
        if (pModeReceptionAwareness.isRetryDefined()) {
            microElement.setAttribute(ATTR_RETRY, pModeReceptionAwareness.isRetry());
        }
        microElement.setAttribute(ATTR_MAX_RETRIES, pModeReceptionAwareness.getMaxRetries());
        microElement.setAttribute(ATTR_RETRY_INTERVAL_MS, pModeReceptionAwareness.getRetryIntervalMS());
        if (pModeReceptionAwareness.isDuplicateDetectionDefined()) {
            microElement.setAttribute(ATTR_DUPLICATE_DETECTION, pModeReceptionAwareness.isDuplicateDetection());
        }
        return microElement;
    }

    @Nonnull
    public PModeReceptionAwareness convertToNative(IMicroElement iMicroElement) {
        ETriState eTriState = PModeReceptionAwarenessMicroTypeConverter.getTriState(iMicroElement.getAttributeValue(ATTR_RECEPTION_AWARENESS), true);
        ETriState eTriState2 = PModeReceptionAwarenessMicroTypeConverter.getTriState(iMicroElement.getAttributeValue(ATTR_RETRY), true);
        int n = iMicroElement.getAttributeValueAsInt(ATTR_MAX_RETRIES, 1);
        long l = iMicroElement.getAttributeValueAsLong(ATTR_RETRY_INTERVAL_MS, iMicroElement.getAttributeValueAsLong("MayRetries", 10000L));
        ETriState eTriState3 = PModeReceptionAwarenessMicroTypeConverter.getTriState(iMicroElement.getAttributeValue(ATTR_DUPLICATE_DETECTION), true);
        return new PModeReceptionAwareness(eTriState, eTriState2, n, l, eTriState3);
    }
}

