/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode.leg;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.MustImplementEqualsAndHashcode;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.name.IHasName;
import com.helger.base.state.EChange;
import com.helger.base.state.EMandatory;
import com.helger.base.state.IMandatoryIndicator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.phase4.logging.Phase4LoggerFactory;
import com.helger.text.IHasDescription;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import org.slf4j.Logger;

@NotThreadSafe
@MustImplementEqualsAndHashcode
public class PModeProperty
implements IHasName,
IHasDescription,
IMandatoryIndicator,
Serializable {
    public static final String DATA_TYPE_STRING = "string";
    public static final boolean DEFAULT_MANDATORY = false;
    private static final Logger LOGGER = Phase4LoggerFactory.getLogger(PModeProperty.class);
    private String m_sName;
    private String m_sDescription;
    private String m_sDataType;
    private EMandatory m_eMandatory;

    private static void _checkDataType(@Nonnull String string) {
        if (!DATA_TYPE_STRING.equals(string)) {
            LOGGER.warn("A non-standard data type (everything besides 'string') is used: " + string);
        }
    }

    public PModeProperty() {
    }

    public PModeProperty(@Nonnull @Nonempty String string, @Nullable String string2, @Nonnull @Nonempty String string3, @Nonnull EMandatory eMandatory) {
        this.setName(string);
        this.setDescription(string2);
        this.setDataType(string3);
        this.setMandatory(eMandatory);
    }

    @Nonnull
    @Nonempty
    public final String getName() {
        return this.m_sName;
    }

    @Nonnull
    public final EChange setName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        if (string.equals(this.m_sName)) {
            return EChange.UNCHANGED;
        }
        this.m_sName = string;
        return EChange.CHANGED;
    }

    @Nullable
    public final String getDescription() {
        return this.m_sDescription;
    }

    @Nonnull
    public final EChange setDescription(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sDescription)) {
            return EChange.UNCHANGED;
        }
        this.m_sDescription = string;
        return EChange.CHANGED;
    }

    @Nonnull
    @Nonempty
    public final String getDataType() {
        return this.m_sDataType;
    }

    @Nonnull
    public final EChange setDataType(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"DataType");
        if (string.equals(this.m_sDataType)) {
            return EChange.UNCHANGED;
        }
        this.m_sDataType = string;
        PModeProperty._checkDataType(string);
        return EChange.CHANGED;
    }

    public final boolean isMandatory() {
        return this.m_eMandatory.isMandatory();
    }

    public final boolean isOptional() {
        return this.m_eMandatory.isOptional();
    }

    @Nonnull
    public final EChange setMandatory(@Nonnull EMandatory eMandatory) {
        ValueEnforcer.notNull((Object)eMandatory, (String)"Mandatory");
        if (eMandatory.equals((Object)this.m_eMandatory)) {
            return EChange.UNCHANGED;
        }
        this.m_eMandatory = eMandatory;
        return EChange.CHANGED;
    }

    @Nonnull
    public final EChange setMandatory(boolean bl) {
        return this.setMandatory(EMandatory.valueOf((boolean)bl));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PModeProperty pModeProperty = (PModeProperty)object;
        return this.m_sName.equals(pModeProperty.m_sName) && EqualsHelper.equals((Object)this.m_sDescription, (Object)pModeProperty.m_sDescription) && this.m_sDataType.equals(pModeProperty.m_sDataType) && this.m_eMandatory.equals((Object)pModeProperty.m_eMandatory);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sName).append((Object)this.m_sDescription).append((Object)this.m_sDataType).append((Object)this.m_eMandatory).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Name", (Object)this.m_sName).append("Description", (Object)this.m_sDescription).append("DataType", (Object)this.m_sDataType).append("Mandatory", (Enum)this.m_eMandatory).getToString();
    }
}

