/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.profile;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.phase4.model.pmode.IPModeIDProvider;
import com.helger.phase4.model.pmode.PMode;
import com.helger.phase4.profile.IAS4Profile;
import com.helger.phase4.profile.IAS4ProfilePModeProvider;
import com.helger.phase4.profile.IAS4ProfileValidator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.function.Supplier;

@Immutable
public class AS4Profile
implements IAS4Profile {
    private final String m_sID;
    private final String m_sDisplayName;
    private final Supplier<? extends IAS4ProfileValidator> m_aProfileValidatorProvider;
    private final IAS4ProfilePModeProvider m_aDefaultPModeProvider;
    private final IPModeIDProvider m_aPModeIDProvider;
    private final boolean m_bDeprecated;
    private final boolean m_bInvokeSPIForPingMessage;

    public AS4Profile(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull Supplier<? extends IAS4ProfileValidator> supplier, @Nonnull IAS4ProfilePModeProvider iAS4ProfilePModeProvider, @Nonnull IPModeIDProvider iPModeIDProvider, boolean bl, boolean bl2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ID");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"DisplayName");
        ValueEnforcer.notNull(supplier, (String)"ProfileValidatorProvider");
        ValueEnforcer.notNull((Object)iAS4ProfilePModeProvider, (String)"aDefaultPModeProvider");
        ValueEnforcer.notNull((Object)iPModeIDProvider, (String)"PModeIDProvider");
        this.m_sID = string;
        this.m_sDisplayName = string2;
        this.m_aProfileValidatorProvider = supplier;
        this.m_aDefaultPModeProvider = iAS4ProfilePModeProvider;
        this.m_aPModeIDProvider = iPModeIDProvider;
        this.m_bDeprecated = bl;
        this.m_bInvokeSPIForPingMessage = bl2;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    @Nonempty
    public String getDisplayName() {
        return this.m_sDisplayName;
    }

    @Override
    @Nullable
    public IAS4ProfileValidator getValidator() {
        return this.m_aProfileValidatorProvider.get();
    }

    @Override
    @Nonnull
    public PMode createPModeTemplate(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nullable String string3) {
        return this.m_aDefaultPModeProvider.getOrCreatePMode(string, string2, string3);
    }

    @Override
    @Nonnull
    public IPModeIDProvider getPModeIDProvider() {
        return this.m_aPModeIDProvider;
    }

    @Override
    public boolean isDeprecated() {
        return this.m_bDeprecated;
    }

    @Override
    public boolean isInvokeSPIForPingMessage() {
        return this.m_bInvokeSPIForPingMessage;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AS4Profile aS4Profile = (AS4Profile)object;
        return this.m_sID.equals(aS4Profile.m_sID);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sID).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ID", (Object)this.m_sID).append("DisplayName", (Object)this.m_sDisplayName).append("ProfileValidatorProvider", this.m_aProfileValidatorProvider).append("DefaultPModeProvider", (Object)this.m_aDefaultPModeProvider).append("PModeIDProvider", (Object)this.m_aPModeIDProvider).append("Deprecated", this.m_bDeprecated).append("InvokeSPIForPingMessage", this.m_bInvokeSPIForPingMessage).getToString();
    }
}

