/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.servlet;

import com.helger.annotation.Nonnegative;
import com.helger.base.rt.StackTraceHelper;
import com.helger.http.EHttpMethod;
import com.helger.http.EHttpVersion;
import com.helger.mime.CMimeType;
import com.helger.phase4.logging.Phase4LoggerFactory;
import com.helger.servlet.response.UnifiedResponse;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;

public class AS4UnifiedResponse
extends UnifiedResponse {
    private static final Logger LOGGER = Phase4LoggerFactory.getLogger(AS4UnifiedResponse.class);

    public AS4UnifiedResponse(@Nonnull EHttpVersion eHttpVersion, @Nonnull EHttpMethod eHttpMethod, @Nonnull HttpServletRequest httpServletRequest) {
        super(eHttpVersion, eHttpMethod, httpServletRequest);
        this.disableCaching();
        this.setAllowContentOnStatusCode(true);
    }

    public void setResponseError(@Nonnegative int n, @Nonnull String string, @Nullable Throwable throwable) {
        LOGGER.error("HTTP " + n + ": " + string, throwable);
        Object object = string;
        if (throwable != null) {
            object = (String)object + "\nTechnical details:\n" + StackTraceHelper.getStackAsString((Throwable)throwable);
        }
        this.setContentAndCharset((String)object, StandardCharsets.UTF_8);
        this.setMimeType(CMimeType.TEXT_PLAIN);
        this.setStatus(n);
    }
}

